/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.activity.review;

import com.cenqua.crucible.model.Comment;
import com.cenqua.crucible.model.Review;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.HashSet;
import java.util.Set;

public class ProjectConstraint {
    Int2ObjectMap<ProjectConstraintItem> constraintMap = new Int2ObjectOpenHashMap();

    public void addComment(Comment comment) {
        int projectId = comment.getReview().getProject().getId();
        this.getConstraint(projectId).addComment(comment);
    }

    public void addProject(int projectId) {
        this.getConstraint(projectId).useWholeProject();
    }

    public void addReview(Review review) {
        int projectId = review.getProject().getId();
        this.getConstraint(projectId).addReview(review);
    }

    private ProjectConstraintItem getConstraint(int projectId) {
        ProjectConstraintItem constraint;
        if (this.constraintMap.containsKey(projectId)) {
            constraint = (ProjectConstraintItem)this.constraintMap.get(projectId);
        } else {
            constraint = new ProjectConstraintItem();
            this.constraintMap.put(projectId, (Object)constraint);
        }
        return constraint;
    }

    public boolean hasWholeProject(int projectId) {
        boolean result = false;
        if (this.constraintMap.containsKey(projectId)) {
            result = ((ProjectConstraintItem)this.constraintMap.get(projectId)).isWholeProject();
        }
        return result;
    }

    public IntSet getProjectIds() {
        return this.constraintMap.keySet();
    }

    public ProjectConstraintItem getConstraintsForProject(int projectId) {
        return (ProjectConstraintItem)this.constraintMap.get(projectId);
    }

    public static class ProjectConstraintItem {
        private boolean entireProject = false;
        private Set<Comment> comments = new HashSet<Comment>();
        private IntSet reviews = new IntOpenHashSet();

        private ProjectConstraintItem() {
        }

        private ProjectConstraintItem addComment(Comment comment) {
            if (!this.entireProject && !this.reviews.contains((Object)comment.getReview().getId())) {
                this.comments.add(comment);
                this.comments.addAll(comment.getComments());
            }
            return this;
        }

        public ProjectConstraintItem useWholeProject() {
            this.entireProject = true;
            this.reviews.clear();
            this.comments.clear();
            return this;
        }

        private ProjectConstraintItem addReview(Review review) {
            if (!this.entireProject) {
                this.reviews.add((Object)review.getId());
            }
            return this;
        }

        public boolean isWholeProject() {
            return this.entireProject;
        }

        public Set<Comment> getComments() {
            return this.comments;
        }

        public IntSet getReviews() {
            return this.reviews;
        }
    }
}

