/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.activity.review;

import com.atlassian.crucible.activity.lucene.ReviewItemIndexer;
import com.atlassian.crucible.activity.review.CoalescingActivityItemProviderBase;
import com.atlassian.crucible.activity.review.CrucibleQueryBuilder;
import com.atlassian.crucible.activity.review.LuceneReviewViewableItems;
import com.atlassian.crucible.activity.review.ReviewerJoinActivityItem;
import com.atlassian.crucible.activity.review.ReviewerJoinActivityItemList;
import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fisheye.activity.ActivityItemList;
import com.atlassian.fisheye.activity.ActivityItemSearchParams;
import com.atlassian.fisheye.activity.ActivitySearchMonitor;
import com.atlassian.fisheye.activity.annotation.ActivityProvider;
import com.cenqua.crucible.model.LogItem;
import com.cenqua.crucible.model.Principal;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.managers.CrucibleUserManager;
import com.cenqua.crucible.model.managers.LogAction;
import com.cenqua.crucible.model.managers.LogItemManager;
import com.cenqua.crucible.model.managers.ReviewManager;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.rep.DbException;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.List;
import java.util.TimeZone;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@ActivityProvider
@Component(value="reviewerJoinActivityItemProvider")
public class LuceneReviewerJoinActivityItemProvider
extends CoalescingActivityItemProviderBase<ReviewerJoinActivityItem, ReviewerJoinActivityItemList> {
    private final ReviewManager reviewManager;
    private final LogItemManager logItemManager;
    private final LuceneReviewViewableItems reviewViewableItems;

    @Autowired
    public LuceneReviewerJoinActivityItemProvider(ReviewManager reviewManager, LogItemManager logItemManager, LuceneReviewViewableItems reviewViewableItems) {
        this.reviewManager = reviewManager;
        this.logItemManager = logItemManager;
        this.reviewViewableItems = reviewViewableItems;
    }

    @Override
    public boolean isApplicable(ActivityItemSearchParams params) {
        return AppConfig.isCrucible() && params.isApplicableForCrucibleSearch();
    }

    @Override
    public int getQueryOrder() {
        return 2;
    }

    @Override
    @Transactional
    public ActivityItemList findActivityItems(ActivityItemSearchParams params, Principal user, ActivitySearchMonitor activitySearchMonitor) {
        if (!this.isApplicable(params)) {
            return ActivityItemList.EMPTY;
        }
        return LuceneReviewerJoinActivityItemProvider.super.findActivityItems(params, user, activitySearchMonitor);
    }

    private ReviewerJoinActivityItem createActivityItem(LogItem entity, Review r2) {
        FecruUser actor = CrucibleUserManager.getUserById(entity.getUserId());
        FecruUser reviewer = CrucibleUserManager.getUserById(entity.getEntityId());
        boolean isJoin = LogAction.REVIEW_REVIEWER_ADDED_MID_REVIEW.getKey().equals(entity.getAction());
        return new ReviewerJoinActivityItem(actor, reviewer, r2, entity.getCreateDate(), isJoin);
    }

    @Override
    protected ReviewerJoinActivityItemList getMoreActivityItems(ActivityItemSearchParams params, Principal user, ActivitySearchMonitor activitySearchMonitor) throws Exception {
        CrucibleQueryBuilder queryBuilder = CrucibleQueryBuilder.create(ReviewItemIndexer.DocumentType.REVIEWER_JOIN).dateRange(params.getMinDate(), params.getMaxDate()).userName(params.getUserFilter()).repoAndPath(params.getRepFilter(), params.getPaths()).projectId(params.getProjectId()).reviewIds(params.getReviewIds());
        return this.searchIndex(user, queryBuilder.build(), params.getMaxItems(), params.getSearchDirection().getLuceneSort(), params.getTz());
    }

    private ReviewerJoinActivityItemList searchIndex(Principal user, BooleanQuery query, int maxItems, Sort sort, TimeZone timeZone) throws DbException {
        List<Integer> visibleIds = this.reviewViewableItems.findViewableIds((Query)query, "reviewerJoinId", maxItems, sort);
        List<LogItem> visibleItems = this.logItemManager.getLogItemsByIds(visibleIds);
        ImmutableMap visibleItemMap = Maps.uniqueIndex(visibleItems, LogItem.TO_ID);
        ImmutableSet reviewIds = ImmutableSet.copyOf((Iterable)Iterables.transform(visibleItems, LogItem.TO_REVIEW_ID));
        Collection<Review> reviews = this.reviewManager.getReviewsByIds((Collection<Integer>)reviewIds);
        ImmutableMap reviewMap = Maps.uniqueIndex(reviews, Review.TO_ID);
        ReviewerJoinActivityItemList items = new ReviewerJoinActivityItemList(timeZone);
        for (int visibleId : visibleIds) {
            Review r2;
            ReviewerJoinActivityItem item;
            LogItem logItem = (LogItem)visibleItemMap.get(visibleId);
            if (logItem == null || items.contains(item = this.createActivityItem(logItem, r2 = (Review)reviewMap.get(logItem.getReviewId())))) continue;
            items.add(item);
        }
        return items;
    }
}

