/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.activity.review;

import com.atlassian.crucible.activity.lucene.ReviewItemIndexer;
import com.atlassian.crucible.activity.review.CoalescingActivityItemProviderBase;
import com.atlassian.crucible.activity.review.CrucibleQueryBuilder;
import com.atlassian.crucible.activity.review.LuceneReviewViewableItems;
import com.atlassian.crucible.activity.review.ReviewStateChangeActivityItem;
import com.atlassian.crucible.activity.review.ReviewStateChangeActivityItemList;
import com.atlassian.fisheye.activity.ActivityItemList;
import com.atlassian.fisheye.activity.ActivityItemSearchParams;
import com.atlassian.fisheye.activity.ActivitySearchMonitor;
import com.atlassian.fisheye.activity.annotation.ActivityProvider;
import com.cenqua.crucible.model.Principal;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.State;
import com.cenqua.crucible.model.StateChangeLog;
import com.cenqua.crucible.model.managers.ReviewManager;
import com.cenqua.crucible.model.managers.StateChangeLogManager;
import com.cenqua.crucible.model.managers.StateManager;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.rep.DbException;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.List;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@ActivityProvider
@Component(value="reviewStateChangeActivityItemProvider")
public class LuceneReviewStateChangeActivityItemProvider
extends CoalescingActivityItemProviderBase<ReviewStateChangeActivityItem, ReviewStateChangeActivityItemList> {
    private final ReviewManager reviewManager;
    private final StateChangeLogManager stateChangeLogManager;
    private final LuceneReviewViewableItems luceneReviewViewableItems;

    @Autowired
    public LuceneReviewStateChangeActivityItemProvider(ReviewManager reviewManager, StateChangeLogManager stateChangeLogManager, LuceneReviewViewableItems luceneReviewViewableItems) {
        this.reviewManager = reviewManager;
        this.stateChangeLogManager = stateChangeLogManager;
        this.luceneReviewViewableItems = luceneReviewViewableItems;
    }

    @Override
    public boolean isApplicable(ActivityItemSearchParams params) {
        return AppConfig.isCrucible() && params.isApplicableForCrucibleSearch();
    }

    @Override
    @Transactional
    public ActivityItemList findActivityItems(ActivityItemSearchParams params, Principal user, ActivitySearchMonitor activitySearchMonitor) {
        if (!this.isApplicable(params)) {
            return ActivityItemList.EMPTY;
        }
        return LuceneReviewStateChangeActivityItemProvider.super.findActivityItems(params, user, activitySearchMonitor);
    }

    @Override
    protected ReviewStateChangeActivityItemList getMoreActivityItems(ActivityItemSearchParams params, Principal user, ActivitySearchMonitor activitySearchMonitor) throws Exception {
        CrucibleQueryBuilder queryBuilder = CrucibleQueryBuilder.create(ReviewItemIndexer.DocumentType.STATE_CHANGE).dateRange(params.getMinDate(), params.getMaxDate()).userName(params.getUserFilter()).repoAndPath(params.getRepFilter(), params.getPaths()).projectId(params.getProjectId()).reviewIds(params.getReviewIds());
        return this.searchIndex(user, queryBuilder.build(), params.getMaxItems(), params.getSearchDirection().getLuceneSort());
    }

    private ReviewStateChangeActivityItemList searchIndex(Principal user, BooleanQuery query, int maxItems, Sort sort) throws DbException {
        List<Integer> visibleIds = this.luceneReviewViewableItems.findViewableIds((Query)query, "stateChangeId", maxItems, sort);
        List<StateChangeLog> visibleItems = this.stateChangeLogManager.getStateChangeByIds(visibleIds);
        ImmutableMap visibleItemMap = Maps.uniqueIndex(visibleItems, StateChangeLog.TO_ID);
        ImmutableSet reviewIds = ImmutableSet.copyOf((Iterable)Iterables.transform(visibleItems, StateChangeLog.TO_REVIEW_ID));
        Collection<Review> reviews = this.reviewManager.getReviewsByIds((Collection<Integer>)reviewIds);
        ImmutableMap reviewMap = Maps.uniqueIndex(reviews, Review.TO_ID);
        ReviewStateChangeActivityItemList items = new ReviewStateChangeActivityItemList();
        for (int visibleSclId : visibleIds) {
            ReviewStateChangeActivityItem item;
            Review r2;
            StateChangeLog scl = (StateChangeLog)visibleItemMap.get(visibleSclId);
            if (scl == null || (r2 = (Review)reviewMap.get(scl.getReviewId())) == null || items.contains(item = this.createActivityItem(scl, r2))) continue;
            items.add(item);
        }
        return items;
    }

    private ReviewStateChangeActivityItem createActivityItem(StateChangeLog log, Review r2) {
        State s2 = StateManager.INSTANCE.getStateByName(log.getNewState());
        return new ReviewStateChangeActivityItem(r2, s2.getName(), s2.getStateType(), s2.getVerbage(), log.getTimeStamp(), log.getUser(), log.getId());
    }

    @Override
    public int getQueryOrder() {
        return 3;
    }
}

