/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.activity.review;

import com.atlassian.crucible.activity.lucene.ReviewItemIndexer;
import com.atlassian.crucible.activity.review.CoalescingActivityItemProviderBase;
import com.atlassian.crucible.activity.review.CrucibleQueryBuilder;
import com.atlassian.crucible.activity.review.LuceneReviewViewableItems;
import com.atlassian.crucible.activity.review.ReviewCompletionActivityItem;
import com.atlassian.crucible.activity.review.ReviewCompletionActivityItemList;
import com.atlassian.fecru.review.ParticipantDAO;
import com.atlassian.fisheye.activity.ActivityItemList;
import com.atlassian.fisheye.activity.ActivityItemSearchParams;
import com.atlassian.fisheye.activity.ActivitySearchMonitor;
import com.atlassian.fisheye.activity.annotation.ActivityProvider;
import com.cenqua.crucible.model.Principal;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.ReviewParticipant;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.rep.DbException;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.TimeZone;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@ActivityProvider
@Component(value="reviewCompletionActivityItemProvider")
public class LuceneReviewCompletionActivityItemProvider
extends CoalescingActivityItemProviderBase<ReviewCompletionActivityItem, ReviewCompletionActivityItemList> {
    private final ParticipantDAO participantDAO;
    private final LuceneReviewViewableItems luceneReviewViewableItems;

    @Autowired
    public LuceneReviewCompletionActivityItemProvider(ParticipantDAO participantDAO, LuceneReviewViewableItems luceneReviewViewableItems) {
        this.participantDAO = participantDAO;
        this.luceneReviewViewableItems = luceneReviewViewableItems;
    }

    @Override
    public boolean isApplicable(ActivityItemSearchParams params) {
        return AppConfig.isCrucible() && params.isApplicableForCrucibleSearch();
    }

    @Override
    public int getQueryOrder() {
        return 2;
    }

    @Override
    @Transactional
    public ActivityItemList findActivityItems(ActivityItemSearchParams params, Principal user, ActivitySearchMonitor activitySearchMonitor) {
        if (!this.isApplicable(params)) {
            return ActivityItemList.EMPTY;
        }
        return LuceneReviewCompletionActivityItemProvider.super.findActivityItems(params, user, activitySearchMonitor);
    }

    private ReviewCompletionActivityItem createActivityItem(ReviewParticipant entity, Review r2) {
        return new ReviewCompletionActivityItem(entity, r2);
    }

    @Override
    protected ReviewCompletionActivityItemList getMoreActivityItems(ActivityItemSearchParams params, Principal user, ActivitySearchMonitor activitySearchMonitor) throws Exception {
        CrucibleQueryBuilder queryBuilder = CrucibleQueryBuilder.create(ReviewItemIndexer.DocumentType.COMPLETION).dateRange(params.getMinDate(), params.getMaxDate()).userName(params.getUserFilter()).repoAndPath(params.getRepFilter(), params.getPaths()).projectId(params.getProjectId()).reviewIds(params.getReviewIds());
        return this.searchIndex(user, queryBuilder.build(), params.getMaxItems(), params.getSearchDirection().getLuceneSort(), params.getTz());
    }

    private ReviewCompletionActivityItemList searchIndex(Principal user, BooleanQuery query, int maxItems, Sort sort, TimeZone timeZone) throws DbException {
        List<Integer> visibleIds = this.luceneReviewViewableItems.findViewableIds((Query)query, "completionId", maxItems, sort);
        List<ReviewParticipant> visibleItems = this.participantDAO.getByIds(visibleIds);
        ImmutableMap visibleItemMap = Maps.uniqueIndex(visibleItems, ReviewParticipant.TO_ID);
        ReviewCompletionActivityItemList items = new ReviewCompletionActivityItemList(timeZone);
        for (int id : visibleIds) {
            ReviewCompletionActivityItem item;
            Review r2;
            ReviewParticipant rp = (ReviewParticipant)visibleItemMap.get(id);
            if (rp == null || (r2 = rp.getReview()) == null || items.contains(item = this.createActivityItem(rp, r2))) continue;
            items.add(item);
        }
        return items;
    }
}

