/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.activity.review;

import com.atlassian.crucible.activity.lucene.ReviewItemIndexer;
import com.atlassian.crucible.activity.review.CrucibleQueryBuilder;
import com.atlassian.crucible.activity.review.LuceneReviewViewableItems;
import com.atlassian.crucible.activity.review.ReviewCommentActivityItem;
import com.atlassian.fisheye.activity.ActivityItem;
import com.atlassian.fisheye.activity.ActivityItemComparators;
import com.atlassian.fisheye.activity.ActivityItemList;
import com.atlassian.fisheye.activity.ActivityItemSearchParams;
import com.atlassian.fisheye.activity.ActivitySearchMonitor;
import com.atlassian.fisheye.activity.BaseActivityItemProvider;
import com.atlassian.fisheye.activity.annotation.ActivityProvider;
import com.cenqua.crucible.model.Comment;
import com.cenqua.crucible.model.Principal;
import com.cenqua.crucible.model.managers.CommentManager;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.util.SortedList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.List;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@ActivityProvider
@Component(value="reviewCommentActivityItemProvider")
public class LuceneReviewCommentActivityItemProvider
extends BaseActivityItemProvider {
    private final CommentManager commentManager;
    private final LuceneReviewViewableItems luceneReviewViewableItems;

    @Autowired
    public LuceneReviewCommentActivityItemProvider(CommentManager commentManager, LuceneReviewViewableItems luceneReviewViewableItems) {
        this.commentManager = commentManager;
        this.luceneReviewViewableItems = luceneReviewViewableItems;
    }

    @Override
    public boolean isApplicable(ActivityItemSearchParams params) {
        return AppConfig.isCrucible() && params.isApplicableForCrucibleSearch();
    }

    @Override
    public int getQueryOrder() {
        return 1;
    }

    @Override
    @Transactional
    public ActivityItemList findActivityItems(ActivityItemSearchParams params, Principal user, ActivitySearchMonitor activitySearchMonitor) {
        if (!this.isApplicable(params)) {
            return ActivityItemList.EMPTY;
        }
        CrucibleQueryBuilder queryBuilder = CrucibleQueryBuilder.create(ReviewItemIndexer.DocumentType.COMMENT).dateRange(params.getMinDate(), params.getMaxDate()).userName(params.getUserFilter()).repoAndPath(params.getRepFilter(), params.getPaths()).projectId(params.getProjectId()).reviewIds(params.getReviewIds());
        try {
            List<ActivityItem> items = this.searchIndex(user, queryBuilder.build(), params.getMaxItems(), params.getSearchDirection().getLuceneSort());
            return new ActivityItemList(items);
        }
        catch (DbException e2) {
            return new ActivityItemList(e2);
        }
    }

    private List<ActivityItem> searchIndex(Principal user, BooleanQuery query, int maxItems, Sort sort) throws DbException {
        List<Integer> visibleIds = this.luceneReviewViewableItems.findViewableIds((Query)query, "commentId", maxItems, sort);
        List<Comment> visibleItems = this.commentManager.getByIds(visibleIds);
        ImmutableMap visibleItemMap = Maps.uniqueIndex(visibleItems, Comment.TO_ID);
        SortedList<ActivityItem> items = new SortedList<ActivityItem>(ActivityItemComparators.desc());
        for (int visibleId : visibleIds) {
            Comment comment = (Comment)visibleItemMap.get(visibleId);
            if (comment == null) continue;
            items.add(new ReviewCommentActivityItem(comment));
        }
        return items;
    }
}

