/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.activity.review;

import com.atlassian.crucible.activity.lucene.ReviewItemIndexer;
import com.atlassian.crucible.activity.review.LuceneReviewViewableItems;
import java.util.List;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefaultLuceneReviewViewableItems
implements LuceneReviewViewableItems {
    private final ReviewItemIndexer reviewItemIndexer;

    @Autowired
    public DefaultLuceneReviewViewableItems(ReviewItemIndexer reviewItemIndexer) {
        this.reviewItemIndexer = reviewItemIndexer;
    }

    @Override
    public List<Integer> findViewableIds(Query query, String idFieldName, int maxItems, Sort sort) {
        Query visibleQuery = this.getVisibleQuery(query);
        return this.reviewItemIndexer.findIds(visibleQuery, idFieldName, maxItems, sort);
    }

    private Query getVisibleQuery(Query query) {
        BooleanQuery visibleQuery = new BooleanQuery();
        visibleQuery.add(query, BooleanClause.Occur.MUST);
        visibleQuery.add(this.reviewItemIndexer.queryForSecurityConstraint(), BooleanClause.Occur.MUST);
        return visibleQuery;
    }
}

