/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.activity.review;

import com.atlassian.crucible.activity.lucene.ReviewItemIndexer;
import com.atlassian.crucible.activity.review.CrucibleQueryBuilder;
import com.atlassian.crucible.spi.data.ReviewData;
import com.atlassian.fecru.search.common.lucene.LuceneUtils;
import com.atlassian.fecru.user.FecruUser;
import com.cenqua.fisheye.lucene.FreeTextAnalyzer;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.Iterables;
import java.util.Locale;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;

public class CrucibleReviewQueryBuilder
extends CrucibleQueryBuilder {
    private CrucibleReviewQueryBuilder() {
        super(ReviewItemIndexer.DocumentType.REVIEW);
    }

    public static CrucibleReviewQueryBuilder newBuilder() {
        return new CrucibleReviewQueryBuilder();
    }

    public CrucibleReviewQueryBuilder title(String title) {
        Query titleQuery = LuceneUtils.matchAnyTokens(new FreeTextAnalyzer(), "reviewTitle", title, true);
        this.query.add(titleQuery, BooleanClause.Occur.MUST);
        return this;
    }

    public CrucibleReviewQueryBuilder allComplete(Boolean allComplete) {
        if (allComplete != null) {
            this.query.add((Query)new TermQuery(new Term("allReviewersComplete", allComplete.toString())), BooleanClause.Occur.MUST);
        }
        return this;
    }

    public CrucibleReviewQueryBuilder participants(FecruUser creator, FecruUser author, FecruUser moderator, FecruUser reviewer, boolean orRoles, Boolean completion) {
        if (creator == null && author == null && moderator == null && reviewer == null) {
            return this;
        }
        BooleanClause.Occur joinType = orRoles ? BooleanClause.Occur.SHOULD : BooleanClause.Occur.MUST;
        BooleanQuery participantQuery = new BooleanQuery();
        if (creator != null) {
            participantQuery.add((Query)new TermQuery(new Term("reviewCreator", creator.getUsername())), joinType);
        }
        if (author != null) {
            participantQuery.add((Query)new TermQuery(new Term("reviewAuthor", author.getUsername())), joinType);
        }
        if (moderator != null) {
            participantQuery.add((Query)new TermQuery(new Term("reviewModeratorEquiv", moderator.getUsername())), joinType);
        }
        if (reviewer != null) {
            String field = "reviewers";
            if (completion != null) {
                field = completion != false ? "completedReviewer" : "uncompletedReviewer";
            }
            participantQuery.add((Query)new TermQuery(new Term(field, reviewer.getUsername())), joinType);
        }
        this.query.add((Query)participantQuery, BooleanClause.Occur.MUST);
        return this;
    }

    public CrucibleReviewQueryBuilder withIssueKeys(Iterable<String> issueKeys) {
        BooleanQuery issueQuery = new BooleanQuery();
        for (String issueKey : issueKeys) {
            issueQuery.add((Query)new TermQuery(new Term("issueKeys", issueKey)), BooleanClause.Occur.SHOULD);
        }
        this.query.add((Query)issueQuery, BooleanClause.Occur.MUST);
        return this;
    }

    public CrucibleReviewQueryBuilder states(String[] states) {
        if (states != null) {
            BooleanQuery or = new BooleanQuery();
            for (String state : states) {
                or.add((Query)new TermQuery(new Term("state", state)), BooleanClause.Occur.SHOULD);
            }
            this.query.add((Query)or, BooleanClause.Occur.MUST);
        }
        return this;
    }

    public CrucibleReviewQueryBuilder states(Iterable<ReviewData.State> states) {
        return this.states((String[])Iterables.toArray((Iterable)Iterables.transform(states, (Function)Functions.toStringFunction()), String.class));
    }

    public CrucibleReviewQueryBuilder withIds(Iterable<Integer> ids) {
        BooleanQuery idQuery = new BooleanQuery();
        for (Integer id : ids) {
            idQuery.add(new BooleanClause((Query)new TermQuery(new Term("reviewPK", String.valueOf(id))), BooleanClause.Occur.SHOULD));
        }
        this.query.add((Query)idQuery, BooleanClause.Occur.MUST);
        return this;
    }

    public CrucibleReviewQueryBuilder moderatorIsNotAuthor(Boolean moderatorIsNotAuthor, FecruUser author) {
        if (moderatorIsNotAuthor != null && moderatorIsNotAuthor.booleanValue() && author != null) {
            this.query.add((Query)new TermQuery(new Term("reviewModeratorEquiv", author.getUsername())), BooleanClause.Occur.MUST_NOT);
        }
        return this;
    }

    public CrucibleReviewQueryBuilder withPermaIds(Iterable<String> permaIds) {
        BooleanQuery permaIdQuery = new BooleanQuery();
        for (String permaId : permaIds) {
            permaIdQuery.add(new BooleanClause((Query)new TermQuery(new Term("permaIds", permaId.toLowerCase(Locale.US))), BooleanClause.Occur.SHOULD));
        }
        this.query.add((Query)permaIdQuery, BooleanClause.Occur.MUST);
        return this;
    }
}

