/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.activity.review;

import com.atlassian.crucible.activity.lucene.ReviewItemIndexer;
import com.cenqua.crucible.model.Review;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.lucene.LuceneHelper;
import com.google.common.base.Strings;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Date;
import java.util.List;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;

public class CrucibleQueryBuilder {
    protected final BooleanQuery query;
    private final ReviewItemIndexer.DocumentType type;

    public static CrucibleQueryBuilder create(ReviewItemIndexer.DocumentType type) {
        return new CrucibleQueryBuilder(type);
    }

    protected CrucibleQueryBuilder(ReviewItemIndexer.DocumentType type) {
        this.type = type;
        this.query = new BooleanQuery();
        this.query.add((Query)new TermQuery(new Term("type", type.name())), BooleanClause.Occur.MUST);
        if (type == ReviewItemIndexer.DocumentType.COMMENT) {
            this.query.add((Query)CrucibleQueryBuilder.notDraft(), BooleanClause.Occur.MUST);
        }
    }

    public CrucibleQueryBuilder dateRange(Date from, Date to) {
        LuceneHelper.addDateClause(this.query, from, to);
        return this;
    }

    public CrucibleQueryBuilder userName(String userName) {
        if (!Strings.isNullOrEmpty((String)userName)) {
            this.query.add((Query)new TermQuery(new Term(this.type.getActionerField(), userName)), BooleanClause.Occur.MUST);
        }
        return this;
    }

    public BooleanQuery build() {
        return this.query;
    }

    public CrucibleQueryBuilder repoAndPath(String repFilter, Path path) {
        if (path != null && !Strings.isNullOrEmpty((String)repFilter)) {
            if (!path.isRoot()) {
                repFilter = repFilter + "/";
            }
            this.query.add((Query)new TermQuery(new Term("pathcomponents", repFilter + path.getPath())), BooleanClause.Occur.MUST);
        }
        return this;
    }

    public CrucibleQueryBuilder repoAndPath(String repFilter, List<Path> paths) {
        if (paths != null && !paths.isEmpty()) {
            return this.repoAndPath(repFilter, paths.get(0));
        }
        return this;
    }

    public CrucibleQueryBuilder projectId(Integer projectId) {
        if (projectId != null) {
            this.query.add((Query)new TermQuery(new Term("projectId", projectId.toString())), BooleanClause.Occur.MUST);
        }
        return this;
    }

    public CrucibleQueryBuilder reviewType(Review.ReviewType type) {
        if (type != null) {
            this.query.add((Query)new TermQuery(new Term("reviewType", Integer.toString(type.getId()))), BooleanClause.Occur.MUST);
        }
        return this;
    }

    public CrucibleQueryBuilder reviewIds(IntSet reviewIds) {
        if (!reviewIds.isEmpty()) {
            BooleanQuery reviewQuery = new BooleanQuery();
            IntIterator intIterator = reviewIds.iterator();
            while (intIterator.hasNext()) {
                int reviewId = (Integer)intIterator.next();
                reviewQuery.add((Query)new TermQuery(new Term("reviewId", Integer.toString(reviewId))), BooleanClause.Occur.SHOULD);
            }
            this.query.add((Query)reviewQuery, BooleanClause.Occur.MUST);
        }
        return this;
    }

    public CrucibleQueryBuilder creator(String creator) {
        if (!Strings.isNullOrEmpty((String)creator)) {
            this.query.add((Query)new TermQuery(new Term("reviewCreator", creator)), BooleanClause.Occur.MUST);
        }
        return this;
    }

    public static TermQuery notDraft() {
        return new TermQuery(new Term("commentDraft", "false"));
    }
}

