/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.activity.review;

import com.atlassian.crucible.activity.review.CoalescingList;
import com.atlassian.fisheye.activity.ActivityItem;
import com.atlassian.fisheye.activity.ActivityItemList;
import com.atlassian.fisheye.activity.ActivityItemSearchParams;
import com.atlassian.fisheye.activity.ActivitySearchMonitor;
import com.atlassian.fisheye.activity.BaseActivityItemProvider;
import com.cenqua.crucible.model.Principal;

public abstract class CoalescingActivityItemProviderBase<A extends ActivityItem, E extends CoalescingList<A>>
extends BaseActivityItemProvider {
    protected E findActivityItemsAndCoalesce(ActivityItemSearchParams params, Principal user, ActivitySearchMonitor activitySearchMonitor) throws Exception {
        ActivityItemSearchParams.Builder builder = ActivityItemSearchParams.Builder.fromParams(params);
        builder.maxItems(params.getMaxItems() * 2);
        ActivityItemSearchParams newParams = builder.build();
        E items = this.getMoreActivityItems(newParams, user, activitySearchMonitor);
        int prevSize = 0;
        while (prevSize != items.size() && items.size() < params.getMaxItems()) {
            if (activitySearchMonitor.isTimeExceeded()) {
                activitySearchMonitor.setSearchTruncated(true);
                break;
            }
            if (items.size() < params.getMaxItems()) {
                int undershoot = params.getMaxItems() - items.size();
                builder.maxItems(newParams.getMaxItems() + undershoot * 2);
                newParams = builder.build();
            }
            items = this.getMoreActivityItems(newParams, user, activitySearchMonitor);
            prevSize = items.size();
        }
        return items;
    }

    protected abstract E getMoreActivityItems(ActivityItemSearchParams var1, Principal var2, ActivitySearchMonitor var3) throws Exception;

    @Override
    public ActivityItemList findActivityItems(ActivityItemSearchParams params, Principal user, ActivitySearchMonitor activitySearchMonitor) {
        try {
            return new ActivityItemList(this.findActivityItemsAndCoalesce(params, user, activitySearchMonitor).getItems(params.getMaxItems()));
        }
        catch (Exception e2) {
            return new ActivityItemList(e2);
        }
    }
}

