/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.activity.lucene;

import com.atlassian.fecru.search.common.api.SearchScope;
import com.cenqua.crucible.hibernate.ReviewItemIndexListener;
import com.cenqua.crucible.model.Project;
import com.cenqua.fisheye.lucene.LuceneConnection;
import com.cenqua.fisheye.rep.DbException;
import it.unimi.dsi.fastutil.ints.IntList;
import java.io.IOException;
import java.util.concurrent.Future;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;

public interface ReviewItemIndexer {
    public <T> T withIndexSearcher(LuceneConnection.IndexSearcherAction<T> var1) throws DbException;

    public IntList findIds(Query var1, String var2, int var3, Sort var4) throws DbException;

    public IntList findIds(Query var1, String var2) throws DbException;

    public int countHits(Query var1) throws DbException;

    public Query queryForReviewDetails(String var1, SearchScope var2);

    public Query queryForReviewComments(String var1, SearchScope var2);

    public Query queryToRestrictByProject(Project var1);

    public void index(ReviewItemIndexListener.Changes var1);

    public Future<Boolean> forceIndexRebuild() throws DbException;

    public void start() throws IOException;

    public void stop();

    public Query queryForSecurityConstraint();

    public static enum DocumentType {
        REVIEW("reviewAuthor"),
        COMMENT("commentAuthor"),
        STATE_CHANGE("stateChangeAuthor"),
        COMPLETION("completionAuthor"),
        REVIEWER_JOIN("reviewerJoinAuthor");

        private final String actioner;

        private DocumentType(String actioner) {
            this.actioner = actioner;
        }

        public String getActionerField() {
            return this.actioner;
        }
    }

    public static interface ReviewerJoinItem {
        public static final DocumentType type = DocumentType.REVIEWER_JOIN;
        public static final String ID = "reviewerJoinId";
        public static final String AUTHOR = "reviewerJoinAuthor";
        public static final String REVIEWER = "reviewerJoinReviewer";
    }

    public static interface CompletionItem {
        public static final DocumentType type = DocumentType.COMPLETION;
        public static final String ID = "completionId";
        public static final String AUTHOR = "completionAuthor";
    }

    public static interface StateChangeItem {
        public static final DocumentType type = DocumentType.STATE_CHANGE;
        public static final String ID = "stateChangeId";
        public static final String AUTHOR = "stateChangeAuthor";
    }

    public static interface CommentItem {
        public static final DocumentType type = DocumentType.COMMENT;
        public static final String ID = "commentId";
        public static final String AUTHOR = "commentAuthor";
        public static final String DRAFT = "commentDraft";
        public static final String DELETED = "commentDeleted";
        public static final String DEFECT = "commentDefect";
        public static final String TEXT = "commentText";
    }

    public static interface ReviewItem {
        public static final DocumentType type = DocumentType.REVIEW;
        public static final String ID = "reviewPK";
        public static final String PERMA_ID = "permaId";
        public static final String PERMA_ID_NUMBER = "permaIdNumber";
        public static final String PERMA_IDS = "permaIds";
        public static final String TITLE = "reviewTitle";
        public static final String SUMMARY = "reviewSummary";
        public static final String OBJECTIVES = "reviewObjectives";
        public static final String LINKED_ISSUE = "linkedIssue";
        public static final String LINKED_REVIEWS = "linkedReviews";
        public static final String ALL_REVIEWERS_COMPLETE = "allReviewersComplete";
        public static final String COMPLETED_REVIEWER = "completedReviewer";
        public static final String UNCOMPLETED_REVIEWER = "uncompletedReviewer";
        public static final String PARTICIPANTS = "participants";
        public static final String REVIEWERS = "reviewers";
        public static final String AUTHOR = "reviewAuthor";
        public static final String CREATOR = "reviewCreator";
        public static final String MODERATOR = "reviewModerator";
        public static final String MODERATOR_EQUIV = "reviewModeratorEquiv";
        public static final String STATE = "state";
        public static final String CREATE_TIME = "createTime";
        public static final String DUE_TIME = "dueTime";
        public static final String NAME = "name";
        public static final String OWNER = "owner";
        public static final String COUNT_REVIEWERS = "countReviewers";
        public static final String COUNT_REVIEWERS_COMPLETED = "countReviewersCompleted";
        public static final String COUNT_FRXS = "countFrxs";
        public static final String COUNT_COMMENTS = "countComments";
        public static final String ISSUE_KEY_REFERENCES = "issueKeys";
        public static final String TITLE_SORT_TOKEN = "reviewTitleSort";
    }

    public static interface Common {
        public static final String TYPE = "type";
        public static final String PATH_COMPONENTS = "pathcomponents";
        public static final String REVIEW_ID = "reviewId";
        public static final String REVIEW_TYPE = "reviewType";
        public static final String DATE_TIME_MS = "dTimeMillis";
        public static final String PROJECT_ID = "projectId";
        public static final String PROJECT_NAME = "projectName";
        public static final String PROJECT_KEY = "projectKey";
    }
}

