/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.activity.lucene;

import com.atlassian.crucible.activity.lucene.CrucibleIndexes;
import com.atlassian.crucible.activity.lucene.ReviewItemIndexer;
import com.atlassian.crucible.activity.review.CrucibleQueryBuilder;
import com.atlassian.fecru.jira.devsummary.ReviewDevDetails;
import com.atlassian.fecru.locks.PriorityLock;
import com.atlassian.fecru.locks.TwoLevelPriorityLock;
import com.atlassian.fecru.review.ParticipantDAO;
import com.atlassian.fecru.search.common.api.QuickSearchTimeBucket;
import com.atlassian.fecru.search.common.api.SearchScope;
import com.atlassian.fecru.search.common.lucene.LuceneUtils;
import com.atlassian.fecru.search.common.lucene.RecencyBoostingQuery;
import com.atlassian.fecru.search.reviews.ReviewCommentResult;
import com.atlassian.fecru.search.reviews.ReviewDetailsResult;
import com.atlassian.fecru.search.reviews.ReviewDevSummaryResult;
import com.atlassian.fecru.search.reviews.ReviewOverviewResult;
import com.atlassian.fecru.search.reviews.ReviewPermaIdResult;
import com.atlassian.fecru.user.EffectiveUserProvider;
import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fisheye.Visitor;
import com.atlassian.fisheye.bucket.TimeZoneVariables;
import com.atlassian.fisheye.jira.JiraIssueUtil;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.cenqua.crucible.hibernate.DbVersionManager;
import com.cenqua.crucible.hibernate.HibernateUtil;
import com.cenqua.crucible.hibernate.ReviewItemIndexListener;
import com.cenqua.crucible.model.Comment;
import com.cenqua.crucible.model.CommentVisitor;
import com.cenqua.crucible.model.CommentVisitorContext;
import com.cenqua.crucible.model.CrucibleRevision;
import com.cenqua.crucible.model.FileRevisionExtraInfo;
import com.cenqua.crucible.model.LogItem;
import com.cenqua.crucible.model.PermaIdKey;
import com.cenqua.crucible.model.Principal;
import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.ReviewParticipant;
import com.cenqua.crucible.model.ReviewPermaId;
import com.cenqua.crucible.model.StateChangeLog;
import com.cenqua.crucible.model.discussion.CommentOperator;
import com.cenqua.crucible.model.managers.CommentManager;
import com.cenqua.crucible.model.managers.LogItemManager;
import com.cenqua.crucible.model.managers.LogItemSearchCriteria;
import com.cenqua.crucible.model.managers.Order;
import com.cenqua.crucible.model.managers.PermissionManager;
import com.cenqua.crucible.model.managers.ProjectManager;
import com.cenqua.crucible.model.managers.ReviewManager;
import com.cenqua.crucible.model.managers.SecureProjectManager;
import com.cenqua.crucible.model.managers.StateChangeLogManager;
import com.cenqua.crucible.model.managers.StateManager;
import com.cenqua.crucible.model.managers.UserActionManager;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.config.SpringContext;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.lucene.FreeTextAnalyzer;
import com.cenqua.fisheye.lucene.LowerCaseAnalyser;
import com.cenqua.fisheye.lucene.LuceneConnection;
import com.cenqua.fisheye.lucene.LuceneHelper;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.user.UserManager;
import com.cenqua.fisheye.util.CollectionsUtil;
import com.cenqua.fisheye.util.ConfigurableThreadFactory;
import com.cenqua.fisheye.util.Disposer;
import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.time.FastDateFormat;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.document.NumericField;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.search.TotalHitCountCollector;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@AvailableToPlugins
@Component(value="reviewItemIndexer")
public class DefaultReviewItemIndexer
implements ReviewItemIndexer {
    private static final String INDEX_VERSION = "53";
    private static final int BATCH_SIZE = 100;
    private static final String DB_SCHEMA_TIMESTAMP = "timestamp";
    private final StateManager stateManager;
    private final DbVersionManager dbVersionManager;
    private final SecureProjectManager secureProjectManager;
    private final CommentManager commentManager;
    private final EffectiveUserProvider effectiveUserProvider;
    private final ParticipantDAO participantDAO;
    private final LogItemManager logItemManager;
    private final StateChangeLogManager stateChangeLogManager;
    private final UserManager userManager;
    private ReviewManager reviewManager;
    private static final int REQUEST_INDEX_PRIORITY = 50;
    private static final int BACKGROUND_INDEX_PRIORITY = 49;
    private final PriorityLock indexLock = new TwoLevelPriorityLock();
    private final PermissionManager permissionManager;
    private ExecutorService queue;
    private LuceneConnection<CrucibleIndexes> indexConnection;
    private final File indexBaseDir;
    private Analyzer analyzer = LuceneUtils.createPerFieldAnalyzer(new FreeTextAnalyzer(), Collections.singletonMap("permaIds", new LowerCaseAnalyser()));
    private static final FieldSelector PERMA_ID_SELECTOR = LuceneUtils.singleFieldSelector("permaId");
    private static final FieldSelector REVIEW_OVERVIEW_SELECTOR = LuceneUtils.multipleFieldsSelector("permaId", "state", "permaIds");
    private static final FieldSelector DEV_SUMMARY_SELECTOR = LuceneUtils.multipleFieldsSelector("permaId", "state", "reviewAuthor", "dueTime", "dTimeMillis");
    private static final FieldSelector REVIEW_DETAILS_FIELD_SELECTOR = LuceneUtils.multipleFieldsSelector("permaId", "reviewAuthor", "reviewTitle", "reviewObjectives", "reviewSummary", "linkedIssue", "linkedReviews", "dTimeMillis", "projectId");
    private static final FieldSelector REVIEW_COMMENT_FIELD_SELECTOR = LuceneUtils.multipleFieldsSelector("permaId", "reviewAuthor", "reviewTitle", "commentAuthor", "commentText", "commentDefect", "commentDraft", "commentId", "dTimeMillis", "projectId");
    private static final FieldSelector FUSION_REVIEW_DETAILS_SELECTOR = LuceneUtils.multipleFieldsSelector("dueTime", "dTimeMillis", "permaId", "state", "reviewTitle", "countComments", "reviewAuthor", "reviewModerator", "uncompletedReviewer", "completedReviewer");

    private Long getLastLoggedTimeForReview(Integer reviewId) {
        LogItemSearchCriteria lastLogCriteria = LogItemSearchCriteria.create().reviewIds(reviewId).limit(1).order(Order.DESC);
        LogItem lastLogItem = (LogItem)Iterables.getFirst(this.logItemManager.getLogItems(lastLogCriteria), null);
        return lastLogItem != null ? Long.valueOf(lastLogItem.getCreateDateTime()) : null;
    }

    protected DefaultReviewItemIndexer(DbVersionManager dbVersionManager, File indexBaseDir, SecureProjectManager secureProjectManager, CommentManager commentManager, EffectiveUserProvider effectiveUserProvider, PermissionManager permissionManager, ParticipantDAO participantDAO, LogItemManager logItemManager, StateChangeLogManager stateChangeLogManager, UserManager userManager) {
        this.dbVersionManager = dbVersionManager;
        this.secureProjectManager = secureProjectManager;
        this.commentManager = commentManager;
        this.effectiveUserProvider = effectiveUserProvider;
        this.logItemManager = logItemManager;
        this.stateChangeLogManager = stateChangeLogManager;
        this.userManager = userManager;
        this.stateManager = StateManager.INSTANCE;
        this.indexBaseDir = indexBaseDir;
        this.permissionManager = permissionManager;
        this.participantDAO = participantDAO;
    }

    @Autowired
    public DefaultReviewItemIndexer(DbVersionManager dbVersionManager, CommentManager commentManager, SecureProjectManager secureProjectManager, EffectiveUserProvider effectiveUserProvider, PermissionManager permissionManager, ParticipantDAO participantDAO, LogItemManager logItemManager, StateChangeLogManager stateChangeLogManager, UserManager userManager) {
        this(dbVersionManager, new File(AppConfig.getCacheDir(), "cruidx"), secureProjectManager, commentManager, effectiveUserProvider, permissionManager, participantDAO, logItemManager, stateChangeLogManager, userManager);
    }

    @Autowired
    public void setReviewManager(ReviewManager reviewManager) {
        this.reviewManager = reviewManager;
    }

    @Override
    @Transactional
    public void index(ReviewItemIndexListener.Changes changes) {
        this.checkStatus();
        try {
            this.indexInBatches(new IndexOperationIterator(changes), false);
        }
        catch (IOException e2) {
            Logs.APP_LOG.error((Object)"Failed to index review changes", (Throwable)e2);
        }
    }

    private void checkStatus() {
        if (this.isStopped()) {
            throw new IllegalStateException("Indexer is stopped (" + this + ")");
        }
    }

    private boolean isStopped() {
        return this.queue == null || this.queue.isShutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int indexInBatches(final IndexOperationIterator iterator, final boolean backgroundIndexing) throws IOException, DbException {
        Disposer.pushThreadInstance();
        try {
            int total = 0;
            while (iterator.hasNext()) {
                try {
                    this.indexLock.lock(backgroundIndexing ? 49 : 50);
                    if (backgroundIndexing && this.queue.isShutdown()) break;
                    total += this.indexConnection.withWriter(CrucibleIndexes.REVIEW, new LuceneConnection.WriterAction<Integer>(){

                        @Override
                        public Integer perform(IndexWriter writer) throws IOException, DbException {
                            int count;
                            for (count = 0; !(count >= 100 || !iterator.hasNext() || backgroundIndexing && DefaultReviewItemIndexer.this.queue.isShutdown()); ++count) {
                                iterator.doNext(writer);
                            }
                            return count;
                        }
                    }).intValue();
                }
                finally {
                    try {
                        this.indexLock.unlock();
                    }
                    catch (Exception e2) {
                        Logs.APP_LOG.error((Object)"Problem releasing review index lock", (Throwable)e2);
                    }
                    if (!backgroundIndexing) continue;
                    HibernateUtil.commitTransaction();
                    HibernateUtil.closeSession();
                }
            }
            int n2 = total;
            return n2;
        }
        finally {
            Disposer.popThreadInstance();
        }
    }

    private void indexReview(IndexWriter writer, ReviewData reviewData, Integer id, Long lastModified) throws IOException {
        Term t2 = new Term("reviewPK", id.toString());
        if (reviewData != null) {
            Review review = reviewData.getReview();
            Document doc = new Document();
            reviewData.addHeaderFields(doc);
            if (review.getCreateDate() != null) {
                doc.add((Fieldable)new NumericField("createTime").setLongValue(review.getCreateDate().getTime()));
            }
            if (review.getDueDate() != null) {
                doc.add((Fieldable)new NumericField("dueTime", Field.Store.YES, true).setLongValue(review.getDueDate().getTime()));
            }
            String owner = null;
            if (review.getAuthor() != null) {
                owner = review.getAuthor().getUsername();
            }
            if (review.getModerator() != null) {
                owner = review.getModerator().getUsername();
            }
            if (owner != null) {
                doc.add((Fieldable)LuceneHelper.Indexed("owner", owner));
            }
            doc.add((Fieldable)LuceneHelper.Indexed("name", review.getName()));
            doc.add((Fieldable)new NumericField("countReviewers").setIntValue(review.getCountAllReviewers()));
            doc.add((Fieldable)new NumericField("countReviewersCompleted").setIntValue(review.getCountCompletedReviewers()));
            doc.add((Fieldable)new NumericField("countFrxs").setIntValue(review.getFrxs().size()));
            int reviewCommentCount = this.commentManager.getReviewCommentCount(review, null, false, false, null, null);
            doc.add((Fieldable)new NumericField("countComments", Field.Store.YES, true).setIntValue(reviewCommentCount));
            doc.add((Fieldable)LuceneHelper.Keyword("type", ReviewItemIndexer.DocumentType.REVIEW.name()));
            doc.add((Fieldable)LuceneHelper.Keyword("reviewPK", id.toString()));
            doc.add((Fieldable)LuceneHelper.Text("reviewObjectives", review.getDescription()));
            doc.add((Fieldable)LuceneHelper.Text("reviewSummary", review.getSummary()));
            doc.add((Fieldable)LuceneHelper.Keyword("linkedIssue", review.getJiraIssueKey()));
            doc.add((Fieldable)LuceneHelper.Indexed("reviewTitleSort", Strings.nullToEmpty((String)review.getName()).toLowerCase(Locale.US)));
            Iterables.concat(JiraIssueUtil.getJiraKeysFromString(review.getDescription()), JiraIssueUtil.getJiraKeysFromString(review.getName()), Collections.singleton(review.getJiraIssueKey())).forEach(issueKey -> doc.add((Fieldable)LuceneHelper.Indexed("issueKeys", issueKey)));
            Set<ReviewPermaId> permaIds = review.getPermaIdHistory();
            for (ReviewPermaId permaId : permaIds) {
                doc.add((Fieldable)LuceneHelper.Text("permaIds", permaId.toString()));
            }
            List<Review> linkedReviews = review.getLinkedReviews();
            for (Review linkedReview : linkedReviews) {
                Set<ReviewPermaId> ids = linkedReview.getPermaIdHistory();
                for (ReviewPermaId permaId : ids) {
                    doc.add((Fieldable)LuceneHelper.Keyword("linkedReviews", permaId.toString()));
                }
            }
            if (review.getCreator() != null) {
                doc.add((Fieldable)LuceneHelper.Indexed("reviewCreator", review.getCreator().getUsername()));
            }
            doc.add((Fieldable)LuceneHelper.Keyword("state", review.getStateName()));
            if (lastModified == null) {
                lastModified = this.getLastLoggedTimeForReview(review.getId());
            }
            this.addDateTime(doc, lastModified != null ? new Date(lastModified) : review.getStateSetDate(), Field.Store.YES);
            this.indexRolesForReview(review, doc);
            doc.add((Fieldable)LuceneHelper.Indexed("allReviewersComplete", Boolean.toString(review.isAllReviewersComplete())));
            reviewData.addFields(doc);
            writer.updateDocument(t2, doc);
        } else {
            writer.deleteDocuments(t2);
        }
    }

    private void indexRolesForReview(Review review, Document doc) {
        boolean isModerated = review.isModerated();
        for (ReviewParticipant p2 : review.getParticipants()) {
            if (p2.getUser() == null) {
                Logs.APP_LOG.warn((Object)("Review " + review.getPermaId() + " has null participant " + p2.toString()));
                continue;
            }
            if (p2.isAuthor()) {
                doc.add((Fieldable)LuceneHelper.Keyword("reviewAuthor", p2.getUser().getUsername()));
                if (!isModerated) {
                    doc.add((Fieldable)LuceneHelper.Indexed("reviewModeratorEquiv", p2.getUser().getUsername()));
                }
            }
            if (p2.isModerator()) {
                doc.add((Fieldable)LuceneHelper.Keyword("reviewModerator", p2.getUser().getUsername()));
                if (isModerated) {
                    doc.add((Fieldable)LuceneHelper.Indexed("reviewModeratorEquiv", p2.getUser().getUsername()));
                }
            }
            if (p2.isReviewer()) {
                doc.add((Fieldable)LuceneHelper.Indexed("reviewers", p2.getUser().getUsername()));
                doc.add((Fieldable)LuceneHelper.Keyword(p2.isAllComplete() ? "completedReviewer" : "uncompletedReviewer", p2.getUser().getUsername()));
            }
            doc.add((Fieldable)LuceneHelper.Indexed("participants", p2.getUser().getUsername()));
        }
    }

    private void indexComment(IndexWriter writer, ReviewData reviewData, Integer id) throws IOException {
        Term t2 = new Term("commentId", id.toString());
        Comment comment = this.loadCommentIfIndexable(reviewData, id);
        if (this.areEntityAndReviewAvailable(comment, reviewData)) {
            Document doc = new Document();
            doc.add((Fieldable)LuceneHelper.Keyword("type", ReviewItemIndexer.DocumentType.COMMENT.name()));
            doc.add((Fieldable)LuceneHelper.Keyword("commentId", comment.getId().toString()));
            doc.add((Fieldable)LuceneHelper.Keyword("commentAuthor", comment.getUser().getUsername()));
            doc.add((Fieldable)LuceneHelper.Keyword("commentDraft", Boolean.toString(comment.isDraft())));
            doc.add((Fieldable)LuceneHelper.Indexed("commentDeleted", Boolean.toString(comment.isDeleted())));
            doc.add((Fieldable)LuceneHelper.Keyword("commentDefect", Boolean.toString(comment.isDefectRaised())));
            doc.add((Fieldable)LuceneHelper.Text("commentText", comment.getMessage()));
            FecruUser author = reviewData.getReview().getAuthor();
            if (author != null) {
                doc.add((Fieldable)LuceneHelper.Keyword("reviewAuthor", author.getUsername()));
            }
            this.indexRolesForReview(reviewData.getReview(), doc);
            this.addDateTime(doc, comment.getUpdatedDate(), Field.Store.YES);
            doc.add((Fieldable)LuceneHelper.lastModifiedField(comment.getUpdatedDate()));
            reviewData.addFields(doc);
            reviewData.addHeaderFields(doc);
            writer.updateDocument(t2, doc);
        } else {
            writer.deleteDocuments(t2);
        }
    }

    private boolean areEntityAndReviewAvailable(Object entity, ReviewData reviewData) {
        if (entity != null && reviewData == null) {
            Logs.APP_LOG.debug((Object)("Missing review when indexing entity " + entity));
        }
        return entity != null && reviewData != null;
    }

    private Comment loadCommentIfIndexable(ReviewData reviewData, Integer id) {
        Comment comment = this.commentManager.getById(id);
        if (comment != null && !comment.isDeleted()) {
            return comment;
        }
        return null;
    }

    private void indexStateChangeLog(IndexWriter writer, ReviewData reviewData, Integer id) throws IOException {
        Term t2 = new Term("stateChangeId", id.toString());
        StateChangeLog scl = this.stateChangeLogManager.getStateChangeById(id);
        if (this.areEntityAndReviewAvailable(scl, reviewData)) {
            if (!this.stateManager.getStateByName(scl.getNewState()).isDraftState()) {
                Document doc = new Document();
                doc.add((Fieldable)LuceneHelper.Keyword("type", ReviewItemIndexer.DocumentType.STATE_CHANGE.name()));
                doc.add((Fieldable)LuceneHelper.Keyword("stateChangeId", Integer.toString(id)));
                doc.add((Fieldable)LuceneHelper.Indexed("stateChangeAuthor", scl.getUser().getUsername()));
                this.addDateTime(doc, scl.getTimeStamp(), Field.Store.NO);
                reviewData.addFields(doc);
                this.indexRolesForReview(reviewData.review, doc);
                writer.updateDocument(t2, doc);
            }
        } else {
            writer.deleteDocuments(t2);
        }
    }

    private void indexReviewParticipant(IndexWriter writer, ReviewData reviewData, Integer id) throws IOException {
        if (!reviewData.isSnippet()) {
            Term t2 = new Term("completionId", id.toString());
            ReviewParticipant rp = this.participantDAO.getById(id);
            if (this.areEntityAndReviewAvailable(rp, reviewData) && rp.getCompletionStatusChangeDate() != null && rp.isReviewer()) {
                Document doc = new Document();
                doc.add((Fieldable)LuceneHelper.Keyword("type", ReviewItemIndexer.DocumentType.COMPLETION.name()));
                doc.add((Fieldable)LuceneHelper.Keyword("completionId", Integer.toString(id)));
                doc.add((Fieldable)LuceneHelper.Indexed("completionAuthor", rp.getUser().getUsername()));
                this.addDateTime(doc, rp.getCompletionStatusChangeDate(), Field.Store.NO);
                reviewData.addFields(doc);
                this.indexRolesForReview(reviewData.review, doc);
                writer.updateDocument(t2, doc);
            } else {
                writer.deleteDocuments(t2);
            }
        }
    }

    private FecruUser getUserById(Integer userId) {
        return userId != null ? this.userManager.getUserById(userId) : null;
    }

    private void indexLogItem(IndexWriter writer, ReviewData reviewData, Integer id) throws IOException {
        if (!reviewData.isSnippet()) {
            Term t2 = new Term("reviewerJoinId", id.toString());
            LogItem logItem = this.logItemManager.getLogItemById(id);
            if (this.areEntityAndReviewAvailable(logItem, reviewData)) {
                FecruUser author = this.getUserById(logItem.getUserId());
                FecruUser reviewer = this.getUserById(logItem.getUserId());
                Document doc = new Document();
                doc.add((Fieldable)LuceneHelper.Keyword("type", ReviewItemIndexer.DocumentType.REVIEWER_JOIN.name()));
                doc.add((Fieldable)LuceneHelper.Keyword("reviewerJoinId", id.toString()));
                if (author != null) {
                    doc.add((Fieldable)LuceneHelper.Indexed("reviewerJoinAuthor", author.getUsername()));
                }
                if (reviewer != null) {
                    doc.add((Fieldable)LuceneHelper.Indexed("reviewerJoinReviewer", reviewer.getUsername()));
                }
                this.addDateTime(doc, logItem.getCreateDate(), Field.Store.NO);
                reviewData.addFields(doc);
                this.indexRolesForReview(reviewData.review, doc);
                writer.updateDocument(t2, doc);
            } else {
                writer.deleteDocuments(t2);
            }
        }
    }

    private void upgradeOrCreateIndex() {
        try {
            this.indexConnection.close();
            this.indexConnection.killLuceneLocks();
            boolean indexFormatOk = this.indexConnection.checkIndexVersionIsCurrent(INDEX_VERSION, CrucibleIndexes.REVIEW);
            boolean indexMatchesDb = this.checkDbTimestampMatchesIndex();
            if (!indexFormatOk || !indexMatchesDb) {
                this.forceIndexRebuild();
            }
        }
        catch (Exception e2) {
            Logs.APP_LOG.error((Object)"Error creating comment index", (Throwable)e2);
        }
    }

    @Override
    public Future<Boolean> forceIndexRebuild() throws DbException {
        this.indexConnection.resetProperties();
        this.indexConnection.close();
        this.indexConnection.killLuceneLocks();
        this.indexConnection.recreateIndex(CrucibleIndexes.REVIEW);
        return this.queue.submit(new Callable<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Boolean call() {
                block8: {
                    long t2 = System.currentTimeMillis();
                    int totalDocuments = 0;
                    try {
                        Logs.APP_LOG.info((Object)"Starting review re-indexing");
                        final ReviewItemIndexListener.Changes reviewChanges = new ReviewItemIndexListener.Changes();
                        DefaultReviewItemIndexer.this.reviewManager.visitAllReviews(new Visitor<Review>(){

                            @Override
                            public void visit(Review review) {
                                ReviewItemIndexListener.ReviewChanges changes = reviewChanges.getChangesForReview(review.getId());
                                changes.setReviewChanged(true);
                            }
                        });
                        HibernateUtil.closeSession();
                        totalDocuments = DefaultReviewItemIndexer.this.indexInBatches(new IndexOperationIterator(reviewChanges), true);
                        try {
                            DefaultReviewItemIndexer.this.indexConnection.updateIndexVersion(DefaultReviewItemIndexer.INDEX_VERSION, CrucibleIndexes.REVIEW);
                            DefaultReviewItemIndexer.this.indexConnection.setProperty(DefaultReviewItemIndexer.DB_SCHEMA_TIMESTAMP, Integer.toString(DefaultReviewItemIndexer.this.dbVersionManager.getDbTimeStamp()));
                            Logs.APP_LOG.info((Object)("Completed review re-indexing of " + totalDocuments + " documents, took " + (System.currentTimeMillis() - t2) / 1000L + " seconds"));
                            Boolean bl = true;
                            return bl;
                        }
                        catch (Exception e2) {
                            try {
                                Logs.APP_LOG.error((Object)"Error recording review indexing completion", (Throwable)e2);
                            }
                            catch (Exception e3) {
                                Logs.APP_LOG.error((Object)"Error indexing reviews", (Throwable)e3);
                                break block8;
                            }
                            HibernateUtil.closeSession();
                        }
                    }
                    finally {
                        HibernateUtil.closeSession();
                    }
                }
                return false;
            }
        });
    }

    private boolean checkDbTimestampMatchesIndex() throws IOException, SQLException {
        String timestampString = this.indexConnection.getProperty(DB_SCHEMA_TIMESTAMP);
        int indexTimestamp = 0;
        if (timestampString != null) {
            try {
                indexTimestamp = Integer.parseInt(timestampString);
            }
            catch (NumberFormatException nfe) {
                Logs.APP_LOG.warn((Object)("Exception parsing index timestamp string is '" + timestampString + "'"));
            }
        }
        return indexTimestamp == this.dbVersionManager.getDbTimeStamp();
    }

    @Override
    public <T> T withIndexSearcher(LuceneConnection.IndexSearcherAction<T> searcher) throws DbException {
        this.checkStatus();
        return this.indexConnection.withIndexSearcher(CrucibleIndexes.REVIEW, searcher);
    }

    @Override
    public IntList findIds(final Query query, final String idFieldName, final int maxItems, final Sort sort) throws DbException {
        return this.withIndexSearcher(new LuceneConnection.IndexSearcherAction<IntList>(){

            @Override
            public IntList perform(IndexSearcher indexSearcher) throws IOException, DbException {
                TopFieldDocs hits = indexSearcher.search(query, null, maxItems, sort);
                return DefaultReviewItemIndexer.this.hitsToFieldIds(indexSearcher, (TopDocs)hits, idFieldName);
            }
        });
    }

    @Override
    public IntList findIds(final Query query, final String idFieldName) throws DbException {
        return this.withIndexSearcher(new LuceneConnection.IndexSearcherAction<IntList>(){

            @Override
            public IntList perform(IndexSearcher indexSearcher) throws IOException, DbException {
                TopDocs hits = indexSearcher.search(query, Integer.MAX_VALUE);
                return DefaultReviewItemIndexer.this.hitsToFieldIds(indexSearcher, hits, idFieldName);
            }
        });
    }

    private IntList hitsToFieldIds(IndexSearcher indexSearcher, TopDocs hits, String idFieldName) throws IOException {
        IntArrayList ids = new IntArrayList();
        FieldSelector field = LuceneUtils.singleFieldSelector(idFieldName);
        for (int i2 = 0; i2 < hits.scoreDocs.length; ++i2) {
            Document doc = indexSearcher.doc(hits.scoreDocs[i2].doc, field);
            ids.add(Integer.parseInt(doc.getFieldable(idFieldName).stringValue()));
        }
        return ids;
    }

    @Override
    public int countHits(final Query query) {
        return this.withIndexSearcher(new LuceneConnection.IndexSearcherAction<Integer>(){

            @Override
            public Integer perform(IndexSearcher indexSearcher) throws IOException, DbException {
                TotalHitCountCollector countingCollector = new TotalHitCountCollector();
                indexSearcher.search(query, (Collector)countingCollector);
                return countingCollector.getTotalHits();
            }
        });
    }

    @Override
    public Query queryForReviewDetails(String userQuery, SearchScope scope) {
        BooleanQuery query = this.queryForReviewDetailsWithoutSecurity(userQuery, scope);
        Query securityQ = this.queryForSecurityConstraint();
        query.add(securityQ, BooleanClause.Occur.MUST);
        return query;
    }

    @Override
    public Query queryForReviewComments(String userQuery, SearchScope scope) {
        BooleanQuery query = new BooleanQuery();
        if (!Strings.isNullOrEmpty((String)userQuery)) {
            Query textQ = LuceneUtils.generateParsedQuery(userQuery, "commentText", this.analyzer);
            textQ.setBoost(20.0f);
            PhraseQuery authorQ = LuceneUtils.parsePhrase(userQuery, "commentAuthor", this.analyzer);
            BooleanQuery commentQ = new BooleanQuery();
            commentQ.add(textQ, BooleanClause.Occur.SHOULD);
            commentQ.add((Query)authorQ, BooleanClause.Occur.SHOULD);
            query.add((Query)commentQ, BooleanClause.Occur.MUST);
        }
        BooleanQuery nonDraftOrMine = new BooleanQuery();
        nonDraftOrMine.add((Query)CrucibleQueryBuilder.notDraft(), BooleanClause.Occur.SHOULD);
        if (!Principal.Anonymous.isAnon((Principal)this.effectiveUserProvider.getEffectivePrincipal())) {
            nonDraftOrMine.add((Query)new TermQuery(new Term("commentAuthor", this.effectiveUserProvider.getEffectivePrincipal().getUserName())), BooleanClause.Occur.SHOULD);
        }
        query.add((Query)nonDraftOrMine, BooleanClause.Occur.MUST);
        query.add(this.queryForSecurityConstraint(), BooleanClause.Occur.MUST);
        query.add((Query)new TermQuery(new Term("type", ReviewItemIndexer.DocumentType.COMMENT.name())), BooleanClause.Occur.MUST);
        String user = scope.getUser();
        if (!Strings.isNullOrEmpty((String)user)) {
            query.add((Query)LuceneUtils.parsePhrase(user, "commentAuthor", this.analyzer), BooleanClause.Occur.MUST);
        }
        if (scope.getTimeBucket() != QuickSearchTimeBucket.ANY_DATE) {
            int hoursSinceEpoch = TimeZoneVariables.reduceMillisToHours(scope.getTimeBucket().getStartTime().getMillis());
            query.add((Query)NumericRangeQuery.newIntRange((String)"lastUpdateHours", (Integer)hoursSinceEpoch, null, (boolean)true, (boolean)true), BooleanClause.Occur.MUST);
        }
        return new RecencyBoostingQuery((Query)query, 10.0f, "lastUpdateHours");
    }

    @Override
    public Query queryToRestrictByProject(Project project) {
        return new TermQuery(new Term("projectId", Integer.toString(project.getId())));
    }

    BooleanQuery queryForReviewDetailsWithoutSecurity(String userQuery, SearchScope scope) {
        Query titleQ = LuceneUtils.generateParsedQuery(userQuery, "reviewTitle", this.analyzer);
        PrefixQuery authorQ = new PrefixQuery(new Term("reviewAuthor", userQuery));
        Query summaryQ = LuceneUtils.generateParsedQuery(userQuery, "reviewSummary", this.analyzer);
        PhraseQuery permaIdQ = LuceneUtils.parsePhrase(userQuery, "permaIds", this.analyzer);
        Query objectivesQ = LuceneUtils.generateParsedQuery(userQuery, "reviewObjectives", this.analyzer);
        PrefixQuery linkedIssueQ = new PrefixQuery(new Term("linkedIssue", userQuery));
        TermQuery linkedReviewsQ = new TermQuery(new Term("linkedReviews", userQuery));
        TermQuery stateQ = new TermQuery(new Term("state", userQuery));
        permaIdQ.setBoost(2.0f);
        linkedIssueQ.setBoost(2.0f);
        linkedReviewsQ.setBoost(2.0f);
        titleQ.setBoost(2.0f);
        BooleanQuery detailsQ = new BooleanQuery();
        detailsQ.add(titleQ, BooleanClause.Occur.SHOULD);
        detailsQ.add(summaryQ, BooleanClause.Occur.SHOULD);
        detailsQ.add(objectivesQ, BooleanClause.Occur.SHOULD);
        detailsQ.add((Query)permaIdQ, BooleanClause.Occur.SHOULD);
        detailsQ.add((Query)linkedIssueQ, BooleanClause.Occur.SHOULD);
        detailsQ.add((Query)linkedReviewsQ, BooleanClause.Occur.SHOULD);
        detailsQ.add((Query)authorQ, BooleanClause.Occur.SHOULD);
        detailsQ.add((Query)stateQ, BooleanClause.Occur.SHOULD);
        BooleanQuery result = new BooleanQuery();
        result.add((Query)new TermQuery(new Term("type", ReviewItemIndexer.DocumentType.REVIEW.name())), BooleanClause.Occur.MUST);
        result.add((Query)detailsQ, BooleanClause.Occur.MUST);
        String user = scope.getUser();
        if (!Strings.isNullOrEmpty((String)user)) {
            result.add((Query)new PrefixQuery(new Term("reviewAuthor", user)), BooleanClause.Occur.MUST);
        }
        if (scope.getTimeBucket() != QuickSearchTimeBucket.ANY_DATE) {
            String startTerm = LuceneHelper.getTimestampFormat().format((Calendar)scope.getTimeBucket().getStartTime().toGregorianCalendar());
            result.add((Query)new TermRangeQuery("dTimeMillis", startTerm, null, true, true), BooleanClause.Occur.MUST);
        }
        return result;
    }

    @Override
    public Query queryForSecurityConstraint() {
        Principal effectivePrincipal = this.effectiveUserProvider.getEffectivePrincipal();
        List<Project> projects = this.secureProjectManager.getVisibleProjects(effectivePrincipal);
        HashSet<Integer> visibleProjects = new HashSet<Integer>();
        for (Project project : projects) {
            visibleProjects.add(project.getId());
        }
        return this.queryForSecurityConstraint(effectivePrincipal, visibleProjects);
    }

    protected Query queryForSecurityConstraint(Principal principal, Set<Integer> viewableProjects) {
        BooleanQuery projectQ = new BooleanQuery();
        for (int projectId : viewableProjects) {
            TermQuery projectQuery = new TermQuery(new Term("projectId", Integer.toString(projectId)));
            projectQ.add((Query)projectQuery, BooleanClause.Occur.SHOULD);
        }
        BooleanQuery query = new BooleanQuery();
        if (!Principal.Anonymous.isAnon((Principal)principal)) {
            Set<Integer> projectsPrincipalMayViewIfAuthor = this.permissionManager.getProjectsRoleCanDoActionIn(ReviewManager.AUTHOR, UserActionManager.ACTION_VIEW);
            Set<Integer> projectsPrincipalMayViewIfCreator = this.permissionManager.getProjectsRoleCanDoActionIn(ReviewManager.CREATOR, UserActionManager.ACTION_VIEW);
            Set<Integer> projectsPrincipalMayViewIfModerator = this.permissionManager.getProjectsRoleCanDoActionIn(ReviewManager.MODERATOR, UserActionManager.ACTION_VIEW);
            Set<Integer> projectsPrincipalMayViewIfReviewer = this.permissionManager.getProjectsRoleCanDoActionIn(ReviewManager.REVIEWER, UserActionManager.ACTION_VIEW);
            DefaultReviewItemIndexer.addQueryForRoleToView(query, projectsPrincipalMayViewIfAuthor, "reviewAuthor", principal, viewableProjects);
            DefaultReviewItemIndexer.addQueryForRoleToView(query, projectsPrincipalMayViewIfCreator, "reviewCreator", principal, viewableProjects);
            DefaultReviewItemIndexer.addQueryForRoleToView(query, projectsPrincipalMayViewIfModerator, "reviewModerator", principal, viewableProjects);
            DefaultReviewItemIndexer.addQueryForRoleToView(query, projectsPrincipalMayViewIfReviewer, "reviewers", principal, viewableProjects);
        }
        query.add(new BooleanClause((Query)projectQ, BooleanClause.Occur.SHOULD));
        return query;
    }

    private static void addQueryForRoleToView(BooleanQuery mainQuery, Set<Integer> projIdsWhereRoleMayView, String roleFieldName, Principal principal, Set<Integer> allViewableProjects) {
        projIdsWhereRoleMayView.removeAll(allViewableProjects);
        if (projIdsWhereRoleMayView.isEmpty()) {
            return;
        }
        TermQuery roleQ = new TermQuery(new Term(roleFieldName, principal.getUserName()));
        BooleanQuery projectsRoleMayViewQ = new BooleanQuery();
        for (Integer projId : projIdsWhereRoleMayView) {
            projectsRoleMayViewQ.add((Query)new TermQuery(new Term("projectId", Integer.toString(projId))), BooleanClause.Occur.SHOULD);
        }
        BooleanQuery participantQ = new BooleanQuery();
        participantQ.add((Query)roleQ, BooleanClause.Occur.MUST);
        participantQ.add((Query)projectsRoleMayViewQ, BooleanClause.Occur.MUST);
        mainQuery.add(new BooleanClause((Query)participantQ, BooleanClause.Occur.SHOULD));
    }

    public static ReviewDevDetails.ReviewDetails loadReviewDetails(IndexReader reader, int doc) throws IOException {
        Document document = reader.document(doc, FUSION_REVIEW_DETAILS_SELECTOR);
        final ReviewDevDetails.DevDetailsUser.UsernameToUserFunction toUserFunction = new ReviewDevDetails.DevDetailsUser.UsernameToUserFunction();
        String dueDateStr = document.get("dueTime");
        Date dueDate = dueDateStr == null ? null : new Date(Long.parseLong(dueDateStr));
        Date lastModifiedDate = LuceneHelper.parseDate(document.get("dTimeMillis"));
        String id = document.get("permaId");
        return new ReviewDevDetails.ReviewDetails(id, document.get("state"), document.get("reviewTitle"), dueDate, lastModifiedDate, Integer.parseInt(document.get("countComments")), (ReviewDevDetails.DevDetailsUser)toUserFunction.apply(document.get("reviewAuthor")), (ReviewDevDetails.DevDetailsUser)toUserFunction.apply(document.get("reviewModerator")), (List<ReviewDevDetails.Reviewer>)ImmutableList.copyOf((Iterable)Iterables.concat((Iterable)Iterables.transform(Arrays.asList(document.getFields("uncompletedReviewer")), (Function)new Function<Field, ReviewDevDetails.Reviewer>(){

            public ReviewDevDetails.Reviewer apply(Field input) {
                return ReviewDevDetails.newIncompleteReviewer((ReviewDevDetails.DevDetailsUser)toUserFunction.apply((Object)input.stringValue()));
            }
        }), (Iterable)Iterables.transform(Arrays.asList(document.getFields("completedReviewer")), (Function)new Function<Field, ReviewDevDetails.Reviewer>(){

            public ReviewDevDetails.Reviewer apply(Field input) {
                return ReviewDevDetails.newCompleteReviewer((ReviewDevDetails.DevDetailsUser)toUserFunction.apply((Object)input.stringValue()));
            }
        }))));
    }

    public static ReviewDetailsResult loadReviewDetailsDoc(ProjectManager projectManager, IndexSearcher searcher, int doc) throws IOException {
        Document document = searcher.doc(doc, REVIEW_DETAILS_FIELD_SELECTOR);
        Project project = projectManager.getProjectById(Integer.parseInt(document.get("projectId")));
        return new ReviewDetailsResult(document.get("permaId"), document.get("reviewAuthor"), document.get("reviewTitle"), document.get("reviewObjectives"), document.get("reviewSummary"), document.get("linkedIssue"), document.get("linkedReviews"), project.getName(), project.getProjKey(), project.getDefaultRepositoryName(), LuceneHelper.parseDate(document.get("dTimeMillis")));
    }

    public static ReviewCommentResult loadReviewCommentDoc(ProjectManager projectManager, IndexSearcher searcher, int doc) throws IOException {
        Document document = searcher.doc(doc, REVIEW_COMMENT_FIELD_SELECTOR);
        Project project = projectManager.getProjectById(Integer.parseInt(document.get("projectId")));
        return new ReviewCommentResult(document.get("permaId"), document.get("reviewAuthor"), document.get("reviewTitle"), document.get("commentAuthor"), document.get("commentText"), Boolean.parseBoolean(document.get("commentDefect")), Boolean.parseBoolean(document.get("commentDraft")), Integer.parseInt(document.get("commentId")), LuceneHelper.parseDate(document.get("dTimeMillis")), project.getName(), project.getProjKey(), project.getDefaultRepositoryName());
    }

    public static ReviewPermaIdResult loadReviewPermaIdDoc(IndexSearcher searcher, int doc) throws IOException {
        Document document = searcher.doc(doc, PERMA_ID_SELECTOR);
        return new ReviewPermaIdResult(document.get("permaId"));
    }

    public static ReviewDevSummaryResult loadReviewDevSummary(IndexReader reader, int docid) throws IOException {
        Document doc = reader.document(docid, DEV_SUMMARY_SELECTOR);
        String dueDate = doc.get("dueTime");
        return new ReviewDevSummaryResult(doc.get("permaId"), doc.get("state"), doc.get("reviewAuthor"), LuceneHelper.parseDate(doc.get("dTimeMillis")), dueDate == null ? null : new Date(Long.parseLong(dueDate)));
    }

    public static ReviewOverviewResult loadReviewOverview(IndexReader reader, int docid) throws IOException {
        Document doc = reader.document(docid, REVIEW_OVERVIEW_SELECTOR);
        return new ReviewOverviewResult(doc.get("permaId"), doc.get("state"), (Set<String>)ImmutableSet.copyOf((Object[])doc.getValues("permaIds")));
    }

    private void addDateTime(Document doc, Date date, Field.Store store) {
        if (date != null) {
            FastDateFormat timestampFmt = LuceneHelper.getTimestampFormat();
            doc.add((Fieldable)new Field("dTimeMillis", timestampFmt.format(date), store, Field.Index.NOT_ANALYZED_NO_NORMS));
        }
    }

    public void start(boolean upgradeOrCreate) throws IOException {
        this.indexConnection = new LuceneConnection(this.indexBaseDir, this.analyzer, (LuceneConnection.IndexConfig[])CrucibleIndexes.values());
        this.queue = Executors.newSingleThreadExecutor(new ConfigurableThreadFactory("ReviewIndexer", false));
        if (upgradeOrCreate) {
            this.upgradeOrCreateIndex();
        }
    }

    @Override
    public void start() throws IOException {
        this.start(true);
    }

    @Override
    public void stop() {
        if (this.queue != null) {
            this.queue.shutdown();
            try {
                if (!this.queue.awaitTermination(10L, TimeUnit.SECONDS)) {
                    this.queue.shutdownNow();
                }
            }
            catch (InterruptedException e2) {
                Logs.APP_LOG.error((Object)"Interrupted shutting down executor", (Throwable)e2);
            }
            this.indexConnection.close();
            this.queue = null;
            this.indexConnection = null;
        }
    }

    public static void doStart() {
        try {
            ReviewItemIndexer indexer = SpringContext.getComponent(ReviewItemIndexer.class, "reviewItemIndexer");
            if (indexer != null) {
                indexer.start();
            }
        }
        catch (Exception e2) {
            Logs.APP_LOG.error((Object)("Could not start DefaultReviewItemIndexer schedule: " + e2.getMessage()), (Throwable)e2);
        }
    }

    public static void doStop() {
        try {
            ReviewItemIndexer indexer = SpringContext.getComponent(ReviewItemIndexer.class, "reviewItemIndexer");
            if (indexer != null) {
                indexer.stop();
            }
        }
        catch (Throwable e2) {
            Logs.APP_LOG.error((Object)("Could not stop DefaultReviewItemIndexer schedule: " + e2.getMessage()), e2);
        }
    }

    private class IndexOperationIterator {
        private final Iterator<Int2ObjectMap.Entry<ReviewItemIndexListener.ReviewChanges>> reviewIterator;
        private Int2ObjectMap.Entry<ReviewItemIndexListener.ReviewChanges> currentChanges;
        private Iterator<Integer> commentIds = null;
        private Iterator<Integer> stateChangeLogIds = null;
        private Iterator<Integer> reviewParticipantIds = null;
        private ReviewData reviewData;
        private Iterator<Integer> logItemIds;

        public IndexOperationIterator(ReviewItemIndexListener.Changes changes) {
            this.reviewIterator = changes.getChangesForReviews().int2ObjectEntrySet().iterator();
        }

        public boolean hasNext() {
            return CollectionsUtil.anyHasNext(this.reviewIterator, this.commentIds, this.stateChangeLogIds, this.reviewParticipantIds, this.logItemIds);
        }

        public void doNext(IndexWriter writer) throws IOException {
            if (this.currentChanges == null) {
                this.currentChanges = this.reviewIterator.next();
                Integer reviewId = (Integer)this.currentChanges.getKey();
                ReviewItemIndexListener.ReviewChanges reviewChanges = (ReviewItemIndexListener.ReviewChanges)this.currentChanges.getValue();
                if (reviewChanges.isReviewChanged()) {
                    this.reviewChanged(reviewId, reviewChanges);
                }
                this.stateChangeLogIds = reviewChanges.getStateChangeLogIds().iterator();
                this.reviewParticipantIds = reviewChanges.getReviewParticipants().iterator();
                this.logItemIds = reviewChanges.getLogItemIds().iterator();
                Review review = DefaultReviewItemIndexer.this.reviewManager.getReviewById(reviewId);
                this.reviewData = review != null ? new ReviewData(review) : null;
                DefaultReviewItemIndexer.this.indexReview(writer, this.reviewData, reviewId, reviewChanges.getLastModified());
                if (!reviewChanges.getReviewParticipants().isEmpty()) {
                    this.addAllCommentsForReindex(this.reviewData.getReview());
                }
                this.commentIds = reviewChanges.getCommentIds().iterator();
            }
            if (this.commentIds.hasNext()) {
                DefaultReviewItemIndexer.this.indexComment(writer, this.reviewData, this.commentIds.next());
            } else if (this.stateChangeLogIds.hasNext()) {
                DefaultReviewItemIndexer.this.indexStateChangeLog(writer, this.reviewData, this.stateChangeLogIds.next());
            } else if (this.reviewParticipantIds.hasNext()) {
                DefaultReviewItemIndexer.this.indexReviewParticipant(writer, this.reviewData, this.reviewParticipantIds.next());
            } else if (this.logItemIds.hasNext()) {
                DefaultReviewItemIndexer.this.indexLogItem(writer, this.reviewData, this.logItemIds.next());
            } else {
                this.currentChanges = null;
            }
        }

        private void addAllCommentsForReindex(Review review) {
            DefaultReviewItemIndexer.this.commentManager.comments(review).includeFRXComments().includeInlineComments().includeReviewComments().visit(new CommentOperator(){

                @Override
                public void operate(Comment comment) {
                    ((ReviewItemIndexListener.ReviewChanges)IndexOperationIterator.this.currentChanges.getValue()).getCommentIds().add((Object)comment.getId());
                }
            });
        }

        public void reviewChanged(int reviewId, final ReviewItemIndexListener.ReviewChanges changes) {
            Review review = DefaultReviewItemIndexer.this.reviewManager.getReviewById(reviewId);
            if (review != null) {
                review.visit(new CommentVisitor(){

                    @Override
                    public void visit(CommentVisitorContext ctx) {
                        changes.getCommentIds().add((Object)ctx.getComment().getId());
                        ctx.proceed();
                    }
                });
                for (StateChangeLog scl : review.getStateChanges()) {
                    changes.getStateChangeLogIds().add((Object)scl.getId());
                }
                for (ReviewParticipant rp : review.getParticipants()) {
                    changes.getReviewParticipants().add((Object)rp.getId());
                }
                List<LogItem> reviewLogItems = DefaultReviewItemIndexer.this.logItemManager.getLogItems(LogItemSearchCriteria.create().reviewIds(review.getId()).actions(ReviewItemIndexListener.INDEXED_LOGITEM_ACTIONS));
                for (LogItem logItem : reviewLogItems) {
                    changes.getLogItemIds().add((Object)logItem.getId());
                }
                changes.setLastModified(DefaultReviewItemIndexer.this.getLastLoggedTimeForReview(review.getId()));
            }
        }
    }

    private static class ReviewData {
        private final Collection<Fieldable> fields = new ArrayList<Fieldable>();
        private final Collection<Fieldable> headerFields = new ArrayList<Fieldable>();
        private final Review review;

        private ReviewData(Review review) {
            this.review = review;
            this.fields.add((Fieldable)LuceneHelper.Indexed("reviewId", Integer.toString(review.getId())));
            Project project = review.getProject();
            this.fields.add((Fieldable)LuceneHelper.Keyword("projectId", Integer.toString(project.getId())));
            this.fields.add((Fieldable)LuceneHelper.Keyword("projectName", project.getName()));
            this.fields.add((Fieldable)LuceneHelper.Keyword("projectKey", project.getProjKey()));
            this.fields.add((Fieldable)LuceneHelper.Indexed("reviewType", Integer.toString(review.getType().getId())));
            this.addPathFields(this.fields, review);
            this.headerFields.add((Fieldable)LuceneHelper.Text("reviewTitle", review.getName()));
            this.headerFields.add((Fieldable)LuceneHelper.Keyword("permaId", review.getPermaId()));
            Integer permaIDNumber = PermaIdKey.parsePermaId(review.getPermaId()).getNumber();
            if (permaIDNumber != null) {
                this.headerFields.add((Fieldable)LuceneHelper.Keyword("permaIdNumber", Integer.toString(permaIDNumber)));
            }
        }

        public Review getReview() {
            return this.review;
        }

        public void addFields(Document doc) {
            for (Fieldable f2 : this.fields) {
                doc.add(f2);
            }
        }

        public void addHeaderFields(Document doc) {
            for (Fieldable f2 : this.headerFields) {
                doc.add(f2);
            }
        }

        private void addPathFields(Collection<Fieldable> fields, Review review) {
            HashSet<String> pathPrefixes = new HashSet<String>();
            for (FileRevisionExtraInfo frx : review.getFrxs()) {
                List<CrucibleRevision> revisions = frx.getCrucibleRevisions();
                for (CrucibleRevision rev : revisions) {
                    String path = rev.getPath();
                    String[] components = path.split("/");
                    StringBuilder sb = new StringBuilder(rev.getSourceName());
                    pathPrefixes.add(sb.toString());
                    for (String c2 : components) {
                        sb.append("/");
                        sb.append(c2);
                        pathPrefixes.add(sb.toString());
                    }
                }
            }
            for (String s2 : pathPrefixes) {
                fields.add((Fieldable)LuceneHelper.Indexed("pathcomponents", s2));
            }
        }

        public boolean isSnippet() {
            return this.review.isSnippet();
        }
    }
}

