/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.activity.changeset;

import com.atlassian.crucible.activity.changeset.ChangesetCommentActivityItem;
import com.atlassian.crucible.activity.changeset.ChangesetCommentActivityItemList;
import com.atlassian.crucible.activity.review.CoalescingActivityItemProviderBase;
import com.atlassian.crucible.activity.review.CoalescingList;
import com.atlassian.fisheye.activity.ActivityItemSearchParams;
import com.atlassian.fisheye.activity.ActivitySearchMonitor;
import com.atlassian.fisheye.activity.RepositoryConstraints;
import com.atlassian.fisheye.activity.annotation.ActivityProvider;
import com.atlassian.fisheye.model.ChangesetComment;
import com.atlassian.fisheye.model.managers.ChangesetCommentManager;
import com.cenqua.crucible.model.Principal;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.config.RepositoryManager;
import com.cenqua.fisheye.crossrepo.ChangesetCommentDocInfo;
import com.cenqua.fisheye.crossrepo.ChangesetQueryBuilder;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.lucene.CrossRepLuceneIndex;
import com.cenqua.fisheye.lucene.CrossRepLuceneIndexes;
import com.cenqua.fisheye.lucene.LuceneConnection;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.user.UserManager;
import java.io.IOException;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ActivityProvider
@Component(value="changesetCommentActivityItemProvider")
public class ChangesetCommentActivityItemProvider
extends CoalescingActivityItemProviderBase {
    private final CrossRepLuceneIndex crossRepLuceneIndex;
    private final RepositoryManager repositoryManager;
    private final UserManager userManager;
    private final ChangesetCommentManager changesetCommentManager;

    @Autowired
    public ChangesetCommentActivityItemProvider(ChangesetCommentManager changesetCommentManager, CrossRepLuceneIndex crossRepLuceneIndex, RepositoryManager repositoryManager, UserManager userManager) {
        this.changesetCommentManager = changesetCommentManager;
        this.crossRepLuceneIndex = crossRepLuceneIndex;
        this.repositoryManager = repositoryManager;
        this.userManager = userManager;
    }

    @Override
    public boolean isApplicable(ActivityItemSearchParams params) {
        return AppConfig.isCrucible() && params.useFEData();
    }

    protected CoalescingList getMoreActivityItems(ActivityItemSearchParams params, Principal user, ActivitySearchMonitor activitySearchMonitor) throws Exception {
        Logs.APP_LOG.debug((Object)("getMoreActivityItems - " + params));
        final ChangesetCommentActivityItemList items = new ChangesetCommentActivityItemList();
        if (params.useFEData()) {
            Object queryBuilder;
            if (params.isRepConstrained()) {
                queryBuilder = ((ChangesetQueryBuilder)((ChangesetQueryBuilder)ChangesetQueryBuilder.newBuilder(params.getRepFilter()).changesetCommentsOnly()).onBranch(params.getBranch())).onAnyPath(params.getPaths());
            } else {
                RepositoryConstraints constraints = params.getCrossRepConstraints();
                if (constraints == null) {
                    constraints = new RepositoryConstraints();
                }
                for (RepositoryHandle handle : this.repositoryManager.getHandles()) {
                    if (handle.isRunning() && this.userManager.hasPermissionToAccess(user, handle)) continue;
                    constraints.excludeRepository(handle.getName());
                }
                queryBuilder = ((ChangesetQueryBuilder.QueryBuilder)ChangesetQueryBuilder.newCrossRepoBuilder().changesetCommentsOnly()).withRepoConstraints(constraints);
            }
            Query query = ((ChangesetQueryBuilder)((ChangesetQueryBuilder)((ChangesetQueryBuilder)queryBuilder).inDateRange(params.getMinDate(), params.getMaxDate())).commentsByUser(params.getUserFilter())).build();
            this.findChangesetComments(user, query, null, params.getMaxItems(), new ChangesetCommentActivityItemCollector(){

                @Override
                public void collect(ChangesetCommentActivityItem activityItem) {
                    items.add(activityItem);
                }
            });
        }
        return items;
    }

    private void findChangesetComments(Principal user, final Query q2, final Filter f2, final int maxItems, final ChangesetCommentActivityItemCollector collector) throws DbException {
        Logs.APP_LOG.debug((Object)("Changeset comment query = " + q2));
        this.crossRepLuceneIndex.getConnection().withIndexSearcher(CrossRepLuceneIndexes.METADATA, new LuceneConnection.IndexSearcherAction<Void>(){

            @Override
            public Void perform(IndexSearcher indexSearcher) throws IOException, DbException {
                TopDocs hits = indexSearcher.search(q2, f2, maxItems);
                for (ScoreDoc hit : hits.scoreDocs) {
                    String commentId = ChangesetCommentDocInfo.commentIdfromSearchHit(indexSearcher, hit);
                    ChangesetComment comment = ChangesetCommentActivityItemProvider.this.changesetCommentManager.getComment(commentId);
                    if (comment == null || comment.isDeleted() || comment.isDraft()) continue;
                    collector.collect(new ChangesetCommentActivityItem(comment));
                }
                return null;
            }
        });
    }

    @Override
    public int getQueryOrder() {
        return 0;
    }

    private static interface ChangesetCommentActivityItemCollector {
        public void collect(ChangesetCommentActivityItem var1);
    }
}

