/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.activity.changeset;

import com.atlassian.crucible.activity.changeset.ChangesetCommentActivityItem;
import com.atlassian.crucible.activity.review.CoalescingList;
import com.atlassian.fisheye.activity.ActivityItem;
import com.cenqua.fisheye.util.SortedList;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class ChangesetCommentActivityItemList
implements CoalescingList<ChangesetCommentActivityItem> {
    private SortedList<ChangesetCommentActivityItem> items = new SortedList<ChangesetCommentActivityItem>(new Comparator<ChangesetCommentActivityItem>(){

        @Override
        public int compare(ChangesetCommentActivityItem o1, ChangesetCommentActivityItem o2) {
            return o1.getDate().compareTo(o2.getDate());
        }
    });

    @Override
    public void add(ChangesetCommentActivityItem newItem) {
        if (this.items.isEmpty()) {
            this.items.add(newItem);
        } else {
            ChangesetCommentActivityItem mostRecent = this.items.get(this.items.size() - 1);
            if (mostRecent.getCsid().equals(newItem.getCsid()) && mostRecent.getRepoName().equals(newItem.getRepoName()) && this.isInTimewindow(mostRecent, newItem)) {
                mostRecent.addComment(newItem.getComment());
            } else {
                this.items.add(newItem);
            }
        }
    }

    private boolean isInTimewindow(ChangesetCommentActivityItem current, ChangesetCommentActivityItem candidate) {
        long startOfWindow = current.getOldestDate().getTime() - 3600000L;
        long endOfWindow = current.getNewestDate().getTime() + 3600000L;
        long t2 = candidate.getDate().getTime();
        return t2 >= startOfWindow && t2 <= endOfWindow;
    }

    @Override
    public List<ChangesetCommentActivityItem> getItems(int n2) {
        return new ArrayList<ChangesetCommentActivityItem>(this.items.subList(0, Math.min(n2, this.items.size())));
    }

    public List<ActivityItem> getActivityItems(int n2) {
        return new ArrayList<ActivityItem>(this.items.subList(0, Math.min(n2, this.items.size())));
    }

    @Override
    public int size() {
        return this.items.size();
    }
}

