/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.activity.changeset;

import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fisheye.activity.BaseActivityItem;
import com.atlassian.fisheye.model.ChangesetComment;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class ChangesetCommentActivityItem
extends BaseActivityItem {
    private Date date;
    private String csid;
    private String repoName;
    private List<ChangesetComment> comments = new ArrayList<ChangesetComment>();

    public ChangesetCommentActivityItem(ChangesetComment comment) {
        this.addComment(comment);
    }

    public void addComment(ChangesetComment comment) {
        this.comments.add(comment);
        if (this.csid == null) {
            this.csid = comment.getCsid();
            this.repoName = comment.getRepository();
            this.date = comment.getUpdatedDate();
        }
    }

    @Override
    public Date getDate() {
        return this.date;
    }

    public Date getOldestDate() {
        Date d2 = null;
        for (ChangesetComment c2 : this.comments) {
            if (d2 != null && !c2.getUpdatedDate().before(d2)) continue;
            d2 = c2.getUpdatedDate();
        }
        return d2;
    }

    public Date getNewestDate() {
        Date d2 = null;
        for (ChangesetComment c2 : this.comments) {
            if (d2 != null && !c2.getUpdatedDate().after(d2)) continue;
            d2 = c2.getUpdatedDate();
        }
        return d2;
    }

    @Override
    public String getType() {
        return "changeset-comment";
    }

    @Override
    public String getOpaqueId() {
        return this.getType() + ":" + this.getComment().getPermaId();
    }

    public ChangesetComment getComment() {
        if (this.comments.size() > 0) {
            return this.comments.get(0);
        }
        return null;
    }

    public String getCsid() {
        return this.csid;
    }

    public String getRepoName() {
        return this.repoName;
    }

    public List<ChangesetComment> getComments() {
        return this.comments;
    }

    public boolean isAllSameUser() {
        FecruUser u2 = null;
        for (ChangesetComment c2 : this.comments) {
            if (u2 == null) {
                u2 = c2.getUser();
                continue;
            }
            if (u2.equals(c2.getUser())) continue;
            return false;
        }
        return true;
    }

    public Set<FecruUser> getAuthors() {
        LinkedHashSet<FecruUser> users = new LinkedHashSet<FecruUser>();
        for (ChangesetComment c2 : this.comments) {
            users.add(c2.getUser());
        }
        return users;
    }

    public int getNoOfAuthors() {
        return this.getAuthors().size();
    }
}

