/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.actions.time;

import com.atlassian.crucible.actions.ReviewBaseAction;
import com.atlassian.crucible.actions.SimpleAjaxResponse;
import com.cenqua.fisheye.util.DateHelper;

public class UpdateTimeTrackingAjaxAction
extends ReviewBaseAction
implements SimpleAjaxResponse {
    private static long MAX_MINUTES = 175200L;
    private String timeText;
    private Long timeSpentMinutes;
    private String errorMsg;
    private boolean worked = false;

    public String execute() throws Exception {
        this.timeSpentMinutes = DateHelper.getDurationMinutes(this.timeText);
        if (this.timeSpentMinutes == null) {
            this.errorMsg = "Invalid time duration (only hours (h) and minutes (m) are supported).";
            return "error";
        }
        if (this.timeSpentMinutes > MAX_MINUTES) {
            this.errorMsg = String.format("Time submitted (%dm) is greater than maximum allowed (%dm)", this.timeSpentMinutes, MAX_MINUTES);
            return "error";
        }
        if (this.getReview().getState().isClosedMetaState()) {
            this.errorMsg = "Cannot log time against a closed review.";
            return "error";
        }
        try {
            this.beginTx();
            this.getReviewDO().getParticipant().setTimeSpent(this.timeSpentMinutes * 60L * 1000L);
            this.commitTx();
        }
        finally {
            this.rollbackTxIfNotCommited();
        }
        this.worked = true;
        return "success";
    }

    public void setTimeText(String timeText) {
        this.timeText = timeText;
    }

    @Override
    public String getPayload() {
        return DateHelper.formatDurationMinutes(this.timeSpentMinutes);
    }

    @Override
    public int getValue() {
        return 0;
    }

    @Override
    public String getErrorMsg() {
        return this.errorMsg;
    }

    @Override
    public boolean isWorked() {
        return this.worked;
    }
}

