/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.actions.time;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.CredentialsRequiredException;
import com.atlassian.crucible.actions.jira.JiraBaseAjaxAction;
import com.atlassian.crucible.spi.services.NotPermittedException;
import com.atlassian.fecru.applinks.CredentialsRequiredMessage;
import com.atlassian.fisheye.jira.JiraIssue;
import com.atlassian.fisheye.jira.RemoteJiraException;
import com.atlassian.xwork.RequireSecurityToken;
import com.cenqua.fisheye.util.DateHelper;
import com.google.common.base.Strings;
import java.util.Calendar;

public class UpdateTimeInJiraAjaxAction
extends JiraBaseAjaxAction {
    private String timeSpent;
    private String timeSubmitted;
    private String timeToSubmit;
    private String comment;
    private boolean updateEstimate;
    private String newEstimate;
    private String issueKey;
    private static final String CREDENTIALS_REQUIRED_MESSAGE = "You don't have an active authenticated session on the JIRA server.";

    @RequireSecurityToken(value=false)
    public String doDefault() throws Exception {
        if (this.getReviewDO().getParticipant() == null) {
            this.errorMsg = "User is not a participant in the review, and may not submit time to JIRA";
            return "error";
        }
        if (this.getReviewDO().getJiraIssueKey() == null) {
            this.errorMsg = "Review is not linked to a JIRA issue";
            return "error";
        }
        this.issueKey = this.getReviewDO().getJiraIssueKey();
        long timeSpentMins = this.nullSafe(this.getReviewDO().getParticipant().getTimeSpent()) / 60000L;
        long timeSubmittedMins = this.nullSafe(this.getReviewDO().getParticipant().getTimeSubmitted()) / 60000L;
        if (timeSubmittedMins > 0L) {
            this.timeSubmitted = DateHelper.formatDurationMinutes(timeSubmittedMins);
        }
        this.timeToSubmit = DateHelper.formatDurationMinutes(Math.max(timeSpentMins - timeSubmittedMins, 0L));
        this.worked = true;
        return "success";
    }

    public String execute() throws Exception {
        String issueKey = this.getReviewDO().getJiraIssueKey();
        if (Strings.isNullOrEmpty((String)issueKey)) {
            return this.error(String.format("Review %s does not have a linked JIRA issue", this.getReviewDO().getReview().getPermaId()));
        }
        if (Strings.isNullOrEmpty((String)this.timeToSubmit)) {
            return this.error("Please enter the amount of time to submit");
        }
        Long mins = DateHelper.getDurationMinutes(this.timeToSubmit);
        if (this.nullSafe(mins) <= 0L) {
            return this.error(String.format("\"%s\" can not be submitted, please enter a positive duration. For example: 45m", this.timeToSubmit));
        }
        JiraIssue issue = this.getIssue(issueKey);
        if (issue != null) {
            return this.handleIssueFound(issue);
        }
        this.worked = this.credentialsRequiredMessages.isEmpty();
        return "error";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String handleIssueFound(JiraIssue issue) {
        try {
            issue.logWork(this.timeToSubmit, Calendar.getInstance(), this.comment, this.updateEstimate, this.newEstimate);
            long timeSubmittedMs = this.nullSafe(this.getReviewDO().getParticipant().getTimeSubmitted());
            timeSubmittedMs += DateHelper.getDurationMilliseconds(this.timeToSubmit).longValue();
            try {
                this.beginTx();
                this.getReviewDO().getParticipant().setTimeSubmitted(timeSubmittedMs);
                this.timeSubmitted = DateHelper.formatDurationMilliseconds(timeSubmittedMs);
                this.commitTx();
            }
            finally {
                this.rollbackTxIfNotCommited();
            }
            this.worked = true;
            return "success";
        }
        catch (NotPermittedException npe) {
            return this.error("You don't have permission to log work on this issue: " + npe.getMessage());
        }
        catch (CredentialsRequiredException cre) {
            ApplicationLink appLink = issue != null ? issue.getJiraServer().getApplicationLink() : null;
            this.credentialsRequiredMessages.add(new CredentialsRequiredMessage(appLink, cre.getMessage(), cre.getAuthorisationURI()));
            return this.error(CREDENTIALS_REQUIRED_MESSAGE);
        }
        catch (RemoteJiraException rje) {
            return this.error("JIRA failed to log your work: " + rje.getMessage());
        }
    }

    public String getIssueKey() {
        return this.issueKey;
    }

    public void setIssueKey(String issueKey) {
        this.issueKey = issueKey;
    }

    private String error(String message) {
        this.errorMsg = message;
        this.worked = false;
        return "error";
    }

    private long nullSafe(Long n2) {
        return n2 == null ? 0L : n2;
    }

    public String getIssueUrl() {
        return this.getReviewDO().getJiraIssueUrl();
    }

    public String getTimeSpent() {
        return this.timeSpent;
    }

    public void setTimeSpent(String timeSpent) {
        this.timeSpent = timeSpent;
    }

    public String getTimeSubmitted() {
        return this.timeSubmitted;
    }

    public void setTimeSubmitted(String timeSubmitted) {
        this.timeSubmitted = timeSubmitted;
    }

    public String getTimeToSubmit() {
        return this.timeToSubmit;
    }

    public void setTimeToSubmit(String timeToSubmit) {
        this.timeToSubmit = timeToSubmit;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setUpdateEstimate(boolean updateEstimate) {
        this.updateEstimate = updateEstimate;
    }

    public void setNewEstimate(String newEstimate) {
        this.newEstimate = newEstimate;
    }
}

