/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.actions.snippet;

import com.atlassian.crucible.actions.ReviewBaseAction;
import com.atlassian.xwork.RequireSecurityToken;
import com.cenqua.crucible.model.managers.SnippetManager;
import com.cenqua.crucible.model.managers.UserActionManager;
import com.cenqua.crucible.tags.ReviewUtil;
import com.cenqua.fisheye.AppConfig;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Resource;

public class PrintSnippetAction
extends ReviewBaseAction {
    @Resource
    private SnippetManager snippetManager;

    @RequireSecurityToken(value=false)
    public String execute() throws Exception {
        if (!ReviewUtil.canDoReviewAction(UserActionManager.ACTION_VIEW, this.getReview())) {
            return "error";
        }
        if (!this.getReview().isSnippet()) {
            throw new UnsupportedOperationException("Sorry, can't print a regular review");
        }
        return "success";
    }

    public String getSnippetSyntax() {
        return this.snippetManager.getSnippetRevision(this.getReview()).getSnippetSyntax();
    }

    public Map<String, String> getSyntaxes() {
        TreeMap<String, String> syntaxes = new TreeMap<String, String>();
        syntaxes.putAll(AppConfig.getsConfig().getSyntaxDefinitions().getSyntaxTypes());
        return syntaxes;
    }
}

