/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.actions.snippet;

import com.atlassian.crucible.actions.BaseAction;
import com.atlassian.fecru.user.FecruUser;
import com.atlassian.xwork.RequireSecurityToken;
import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.managers.SnippetManager;
import com.cenqua.crucible.model.managers.UserActionManager;
import com.cenqua.crucible.revision.managers.ContentManager;
import com.cenqua.crucible.tags.ProjectUtil;
import com.cenqua.crucible.tags.ReviewUtil;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.config1.ConfigDocument;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.DbException;
import com.google.common.base.Strings;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Resource;

public class CreateSnippetAction
extends BaseAction {
    private String uploadText;
    private String uploadContentType;
    private String title;
    private Project project;
    private Review review;
    private String extension;
    @Resource
    private ContentManager contentManager;
    @Resource
    private SnippetManager snippetManager;
    private Project defaultProject;

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setProjectKey(String projectKey) {
        this.project = this.projectManager.getProjectByKey(projectKey);
    }

    @Override
    public Project getProject() {
        if (this.project == null) {
            this.project = super.getProject();
        }
        return this.project;
    }

    public String getUploadText() {
        return this.uploadText;
    }

    public void setUploadText(String uploadText) {
        this.uploadText = uploadText;
    }

    public String getUploadContentType() {
        if (!Strings.isNullOrEmpty((String)this.uploadContentType)) {
            return this.uploadContentType;
        }
        return "text/plain";
    }

    public void setUploadContentType(String uploadContentType) {
        this.uploadContentType = uploadContentType;
    }

    public String getPermaId() {
        return this.review == null ? "" : this.review.getPermaId();
    }

    public Map<String, String> getSyntaxes() {
        TreeMap<String, String> syntaxes = new TreeMap<String, String>();
        syntaxes.putAll(AppConfig.getsConfig().getSyntaxDefinitions().getSyntaxTypes());
        return syntaxes;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public String getExtension() {
        return this.extension;
    }

    @RequireSecurityToken(value=false)
    public String execute() throws Exception {
        Object sawSnippetRewrite = this.getRequest().getAttribute("snippet-rewrite-pass");
        if (sawSnippetRewrite == null) {
            return "redirectToCreate";
        }
        if (this.getCurrentUser() == null) {
            return "loginRequired";
        }
        try {
            this.beginTx();
            if (this.getProjectsCanDoActionIn(UserActionManager.Action.ACTION_CREATE).isEmpty()) {
                this.addActionError("You do not have permission to create snippets in any project.");
            }
        }
        finally {
            this.commitTx();
        }
        return "input";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createSnippet() throws Exception {
        if (this.checkErrors()) {
            return "input";
        }
        FecruUser user = this.getCurrentUser();
        if (user == null) {
            return "loginRequired";
        }
        try {
            this.beginTx();
            Project project = this.getProject();
            this.review = this.createReview(project);
            String filename = project.getProjKey() + "-snippet-" + System.currentTimeMillis();
            this.review = this.snippetManager.addFileToSnippet(this.review, filename, this.getUploadText(), this.getUploadContentType(), this.contentManager, this.extension);
            this.commitTx();
            String string = "success";
            return string;
        }
        finally {
            this.rollbackTxIfNotCommited();
        }
    }

    private boolean checkErrors() {
        Project project;
        boolean hasError = false;
        String uploadText = this.getUploadText();
        if (Strings.isNullOrEmpty((String)uploadText) || Strings.isNullOrEmpty((String)uploadText.trim())) {
            this.addActionError("Snippet content must not be empty");
            hasError = true;
        }
        if ((project = this.getProject()) == null) {
            this.addActionError("You must choose a project");
            hasError = true;
        } else if (!ReviewUtil.principalCanDoProjectAction(this.getPrincipal(), UserActionManager.ACTION_CREATE, project)) {
            this.addActionError("You do not have permission to create a snippet in the project " + project.getName());
            hasError = true;
        }
        return hasError;
    }

    public Project getDefaultSnippetProject() {
        if (this.defaultProject == null) {
            ConfigDocument.Config c2;
            Integer defaultId = this.getUserPreferences().getSnippetProjectId();
            if (defaultId == null && (c2 = AppConfig.getsConfig().getConfig()).isSetSnippet() && c2.getSnippet().isSetDefaultProjectId()) {
                defaultId = c2.getSnippet().getDefaultProjectId();
            }
            if (defaultId != null) {
                this.defaultProject = ProjectUtil.getProjectById(defaultId);
            }
        }
        return this.defaultProject;
    }

    private Review createReview(Project project) throws DbException {
        Review review = this.reviewManager.createSnippetReviewWithDefaults(this.projectManager, project, "", this.getCurrentUser());
        review.setAuthor(this.getCurrentUser());
        review.setCreator(this.getCurrentUser());
        review.setDefaultSource("UPLOAD:");
        String type = null;
        for (Map.Entry<String, String> entry : this.getSyntaxes().entrySet()) {
            if (!entry.getValue().equals(this.extension)) continue;
            type = entry.getKey();
            break;
        }
        review.setName(this.snippetManager.constructSnippetName(this.title, this.extension, type, this.uploadText));
        Logs.APP_LOG.debug((Object)("Created snippet " + review.getPermaId()));
        return review;
    }
}

