/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.actions.search.comment;

import com.atlassian.crucible.configuration.metrics.FieldDefinition;
import com.atlassian.crucible.configuration.metrics.MetricsConfig;
import com.atlassian.crucible.configuration.metrics.MetricsManager;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.managers.ReviewManager;
import com.cenqua.crucible.reports.Period;
import com.cenqua.fisheye.Path;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CommentSearchData {
    private Integer projectId;
    private String text;
    private boolean defects;
    private boolean comments;
    private String[] state;
    private String authorName;
    private Period period = new Period();
    private boolean notDeleted = true;
    private Integer maxResults;
    private OrderByClause orderBy;
    private List<MetricsInfo> metricInfos = new ArrayList<MetricsInfo>();
    private Map<Integer, MetricDO> metricsById = new HashMap<Integer, MetricDO>();
    private Review owningReview;
    private String permaId;
    private Path path;
    private String repoName;
    private IntSet reviewsIds;
    private final ReviewManager reviewManager;

    public IntSet getReviewsIds() {
        return this.reviewsIds;
    }

    public void setReviewsIds(IntSet reviewIds) {
        this.reviewsIds = reviewIds;
    }

    public String getRepoName() {
        return this.repoName;
    }

    public void setRepoName(String repoName) {
        this.repoName = repoName;
    }

    public Path getPath() {
        return this.path;
    }

    public void setPath(Path path) {
        this.path = path;
    }

    public CommentSearchData(ReviewManager reviewManager) {
        this.reviewManager = reviewManager;
        this.makeMetrics();
    }

    private void makeMetrics() {
        MetricsConfig mc = MetricsManager.INSTANCE.getConfig(MetricsManager.INSTANCE.getLatestVersion());
        if (mc != null && mc.isValid()) {
            int i2 = 0;
            MetricsInfo info = null;
            for (FieldDefinition fd : mc.getCommentFields().values()) {
                if (info != null) {
                    this.metricInfos.add(info);
                    info = null;
                }
                for (Map.Entry<String, Object> entry : fd.getNamedEntries()) {
                    if (!fd.isExclusiveSet()) continue;
                    String metricName = fd.getName();
                    String metricLabel = fd.getLabel();
                    String fieldName = entry.getKey();
                    Integer fieldId = (Integer)entry.getValue();
                    MetricDO mdo = new MetricDO(i2, metricName, metricLabel, fieldName, fieldId);
                    mdo.setSelected(false);
                    if (info == null) {
                        info = new MetricsInfo(mdo.getMetricName(), mdo.getMetricLabel());
                    }
                    info.addMetric(mdo);
                    this.metricsById.put(mdo.getId(), mdo);
                    ++i2;
                }
            }
            this.metricInfos.add(info);
        }
    }

    public Integer getProjectId() {
        return this.projectId;
    }

    public void setProjectId(Integer projectId) {
        this.projectId = projectId;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public boolean isDefects() {
        return this.defects;
    }

    public void setDefects(boolean defects) {
        this.defects = defects;
    }

    public boolean isComments() {
        return this.comments;
    }

    public void setComments(boolean comments) {
        this.comments = comments;
    }

    public String[] getState() {
        return this.state;
    }

    public void setState(String[] state) {
        this.state = state;
    }

    public String getAuthorName() {
        return this.authorName;
    }

    public void setAuthorName(String authorName) {
        this.authorName = authorName;
    }

    public Collection<MetricDO> getMetrics() {
        return this.metricsById.values();
    }

    public Collection<MetricsInfo> getMetricInfos() {
        return this.metricInfos;
    }

    public void setMetric(Integer id, boolean value) {
        MetricDO mdo = this.metricsById.get(id);
        if (mdo != null) {
            mdo.setSelected(value);
        }
    }

    public void setMetric(Integer[] metric) {
        if (metric != null) {
            for (Integer id : metric) {
                MetricDO mdo = this.metricsById.get(id);
                if (mdo == null) continue;
                mdo.setSelected(true);
            }
        }
    }

    public Period getPeriod() {
        return this.period;
    }

    public void setPeriod(Period period) {
        this.period = period;
    }

    public boolean isNotDeleted() {
        return this.notDeleted;
    }

    public Review getReview() {
        return this.owningReview;
    }

    public void setReview(Review review) {
        this.owningReview = review;
    }

    public String getPermaId() {
        return this.permaId;
    }

    public void setPermaId(String permaId) {
        this.permaId = permaId;
    }

    public Integer getMaxResults() {
        return this.maxResults;
    }

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    public OrderByClause getOrderBy() {
        return this.orderBy;
    }

    public void setOrderBy(OrderByClause orderBy) {
        this.orderBy = orderBy;
    }

    public static class OrderByClause {
        private String fieldName;
        private boolean desc;

        public OrderByClause(String fieldName, boolean desc) {
            this.fieldName = fieldName;
            this.desc = desc;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public boolean isDesc() {
            return this.desc;
        }
    }

    public static class MetricDO {
        private final Integer id;
        private final String metricName;
        private final String metricLabel;
        private final String fieldName;
        private final Integer fieldId;
        private boolean selected = false;

        public MetricDO(Integer id, String metricName, String metricLabel, String fieldName, Integer fieldId) {
            this.id = id;
            this.metricName = metricName;
            this.metricLabel = metricLabel;
            this.fieldName = fieldName;
            this.fieldId = fieldId;
        }

        public Integer getId() {
            return this.id;
        }

        public String getMetricName() {
            return this.metricName;
        }

        public String getMetricLabel() {
            return this.metricLabel;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public Integer getFieldId() {
            return this.fieldId;
        }

        public boolean isSelected() {
            return this.selected;
        }

        public void setSelected(boolean selected) {
            this.selected = selected;
        }
    }

    public static class MetricsInfo {
        private final String name;
        private final String label;
        private final List<MetricDO> metrics = new ArrayList<MetricDO>();

        public MetricsInfo(String name, String label) {
            this.name = name;
            this.label = label;
        }

        public String getName() {
            return this.name;
        }

        public String getLabel() {
            return this.label;
        }

        public List<MetricDO> getMetrics() {
            return this.metrics;
        }

        public void addMetric(MetricDO metric) {
            this.metrics.add(metric);
        }
    }
}

