/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.actions.search.comment;

import com.atlassian.crucible.actions.PagedSearch;
import com.atlassian.crucible.actions.search.comment.CommentSearchData;
import com.atlassian.fecru.security.CurrentUserPermissions;
import com.atlassian.fecru.user.FecruUser;
import com.atlassian.xwork.ParameterSafe;
import com.atlassian.xwork.RequireSecurityToken;
import com.cenqua.crucible.model.Comment;
import com.cenqua.crucible.model.State;
import com.cenqua.crucible.model.managers.CommentManager;
import com.cenqua.crucible.model.managers.ReviewManager;
import com.cenqua.crucible.model.managers.StateManager;
import com.cenqua.crucible.model.managers.UnreadManager;
import com.cenqua.crucible.reports.commentsDefects.DefectReportDO;
import com.cenqua.crucible.util.HqlUtil;
import com.cenqua.crucible.view.CommentDO;
import com.cenqua.crucible.view.StateDO;
import com.cenqua.fisheye.web.paging.TotalCountAwarePagingCalculator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public class CommentSearchAction
extends PagedSearch {
    private List<CommentDO> results;
    private List<Comment> comments;
    private String[] selectedStates;
    private CommentSearchData searchData;
    private Long numDefects;
    private Long numMajor;
    private List<DefectReportDO> defectReport;
    private UnreadManager unreadManager;
    private ReviewManager reviewManager;
    @Autowired
    private CommentManager commentManager;
    @Autowired
    private CurrentUserPermissions currentUserPermissions;

    @Autowired
    public void setUnreadManager(UnreadManager unreadManager) {
        this.unreadManager = unreadManager;
    }

    @Override
    @Autowired
    public void setReviewManager(ReviewManager reviewManager) {
        this.reviewManager = reviewManager;
        this.searchData = new CommentSearchData(reviewManager);
    }

    public String[] getSelectedStates() {
        return this.selectedStates;
    }

    public void setSelectedStates(String[] selectedStates) {
        this.selectedStates = selectedStates;
    }

    public List<CommentDO> getCommentDOs() {
        if (this.results == null) {
            List<Comment> comments = this.getComments().subList(this.getStart(), this.getEnd());
            FecruUser user = this.getCurrentUser();
            this.results = new LinkedList<CommentDO>();
            for (Comment comment : comments) {
                this.results.add(new CommentDO(this.unreadManager, comment, user, this.getPrincipal(), this.currentUserPermissions));
            }
        }
        return this.results;
    }

    private List<Comment> getComments() {
        if (this.comments == null) {
            this.comments = new LinkedList<Comment>();
            this.comments.addAll(this.commentManager.searchComments(this.getPrincipal(), this.getSearch(), "comment"));
        }
        return this.comments;
    }

    public Collection<StateDO> getStates() {
        List<State> states = StateManager.INSTANCE.getStates();
        LinkedList<StateDO> wrappedStates = new LinkedList<StateDO>();
        for (State state : states) {
            wrappedStates.add(new StateDO(state, this.selectedStates));
        }
        return wrappedStates;
    }

    @ParameterSafe
    public CommentSearchData getSearch() {
        return this.searchData;
    }

    public void setSearch(CommentSearchData searchData) {
        this.searchData = searchData;
    }

    public long getCountDefectsInFilter() {
        if (this.numDefects == null) {
            if (this.getSearch().isComments() && !this.getSearch().isDefects()) {
                return 0L;
            }
            CommentSearchData sd = this.copySearchForCounts();
            sd.setDefects(true);
            List<Comment> l2 = this.commentManager.searchComments(this.getPrincipal(), sd, "count(distinct comment.id)");
            this.numDefects = HqlUtil.getCountFromSet(l2);
        }
        return this.numDefects;
    }

    public List<DefectReportDO> getDefectClassificationReport() {
        if (this.defectReport == null) {
            this.defectReport = new ArrayList<DefectReportDO>();
            if (this.getSearch().isComments() && !this.getSearch().isDefects()) {
                return this.defectReport;
            }
            CommentSearchData sd = this.copySearchForCounts();
            sd.setDefects(true);
            Collection<CommentSearchData.MetricDO> mdos = this.getSearch().getMetrics();
            if (mdos != null) {
                for (CommentSearchData.MetricDO mdo : mdos) {
                    sd.setMetric(mdo.getId(), true);
                    List<Comment> l2 = this.commentManager.searchComments(this.getPrincipal(), sd, "count(distinct comment.id)");
                    this.defectReport.add(new DefectReportDO(mdo.getMetricName(), mdo.getFieldName(), HqlUtil.getCountFromSet(l2)));
                    sd.setMetric(mdo.getId(), false);
                }
            }
        }
        return this.defectReport;
    }

    public long getCountMajorDefectsInFilter() {
        if (this.numMajor == null) {
            if (this.getSearch().isComments() && !this.getSearch().isDefects()) {
                return 0L;
            }
            CommentSearchData sd = this.copySearchForCounts();
            sd.setDefects(true);
            CommentSearchData.MetricsInfo info = null;
            for (CommentSearchData.MetricsInfo mi : this.getSearch().getMetricInfos()) {
                if (!mi.getName().equals("rank")) continue;
                info = mi;
                break;
            }
            if (info != null) {
                for (CommentSearchData.MetricDO mdo : info.getMetrics()) {
                    if (mdo.getFieldName().equals("Major")) {
                        sd.setMetric(mdo.getId(), true);
                    }
                    if (mdo.getFieldName().equals("Major") || !mdo.isSelected()) continue;
                    return 0L;
                }
            }
            List<Comment> l2 = this.commentManager.searchComments(this.getPrincipal(), sd, "count(distinct comment.id)");
            this.numMajor = HqlUtil.getCountFromSet(l2);
        }
        return this.numMajor;
    }

    public long getCountOtherDefectsInFilter() {
        return this.getCountDefectsInFilter() - this.getCountMajorDefectsInFilter();
    }

    private CommentSearchData copySearchForCounts() {
        CommentSearchData sd = new CommentSearchData(this.reviewManager);
        sd.setAuthorName(this.getSearch().getAuthorName());
        sd.setProjectId(this.getSearch().getProjectId());
        sd.setState(this.getSearch().getState());
        sd.setText(this.getSearch().getText());
        sd.setPeriod(this.getSearch().getPeriod());
        sd.setPermaId(this.getSearch().getPermaId());
        ArrayList<Integer> mdos = new ArrayList<Integer>();
        for (CommentSearchData.MetricDO mdo : this.getSearch().getMetrics()) {
            if (!mdo.isSelected()) continue;
            mdos.add(mdo.getId());
        }
        sd.setMetric(mdos.toArray(new Integer[mdos.size()]));
        return sd;
    }

    @Override
    public TotalCountAwarePagingCalculator constructPagingCalculator(int page) {
        return TotalCountAwarePagingCalculator.getPagingCalculator(page, this.getComments().size(), 50);
    }

    @RequireSecurityToken(value=false)
    public String execute() throws Exception {
        return super.execute();
    }
}

