/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.actions.search.ajax;

import com.atlassian.crucible.actions.ReviewBaseAction;
import com.atlassian.crucible.actions.search.ajax.AjaxAutocompleter;
import com.atlassian.crucible.activity.review.ReviewCommentActivityItem;
import com.atlassian.crucible.activity.review.ReviewCompletionActivityItem;
import com.atlassian.crucible.activity.review.ReviewStateChangeActivityItem;
import com.atlassian.fecru.user.EffectiveUserProvider;
import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fisheye.activity.ActivityItem;
import com.atlassian.fisheye.activity.ActivityItemList;
import com.atlassian.fisheye.activity.ActivityItemManager;
import com.atlassian.fisheye.activity.ActivityItemSearchParams;
import com.atlassian.fisheye.activity.ActivitySearchMonitor;
import com.atlassian.fisheye.search.SearchSortOrder;
import com.atlassian.xwork.RequireSecurityToken;
import com.cenqua.crucible.model.CrucibleRevision;
import com.cenqua.crucible.model.FileRevisionExtraInfo;
import com.cenqua.crucible.model.SuggestedReviewer;
import com.cenqua.crucible.model.SuggestedReviewerConfig;
import com.cenqua.crucible.model.managers.SuggestedReviewerManager;
import com.cenqua.crucible.revision.source.RepositorySource;
import com.cenqua.crucible.revision.source.Source;
import com.cenqua.crucible.tags.ReviewUtil;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.config.RepositoryManager;
import com.cenqua.fisheye.config.SpringContext;
import com.cenqua.fisheye.csindex.ChangesetStatsCalculator;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.web.filters.TotalityFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.springframework.beans.factory.annotation.Autowired;

public class SuggestReviewersAjaxAction
extends ReviewBaseAction
implements AjaxAutocompleter<SuggestedReviewer> {
    @Autowired
    private RepositoryManager repositoryManager;
    @Autowired
    private EffectiveUserProvider effectiveUserProvider;
    @Autowired
    private SuggestedReviewerManager suggestedReviewerManager;
    private String errorMsg = "";
    private boolean worked = true;
    private int totalLOC;
    private int totalCommits;
    private Map<FecruUser, SuggestedReviewer> suggestedReviewers = new HashMap<FecruUser, SuggestedReviewer>();
    private static final long TIMEOUT = 3000L;

    private SuggestedReviewerConfig getConfig() {
        return this.getProject().getSuggestedReviewerConfig();
    }

    public boolean isShowLOCData() {
        for (SuggestedReviewer reviewer : this.suggestedReviewers.values()) {
            if (reviewer.getLoc() <= 0) continue;
            return true;
        }
        return false;
    }

    public boolean isShowContribution() {
        return this.totalLOC > 0 || this.totalCommits > 0;
    }

    @Override
    public String getErrorMsg() {
        return this.errorMsg;
    }

    @Override
    public boolean isWorked() {
        return this.worked;
    }

    @Override
    public void setQ(String q2) {
    }

    @Override
    public void setLimit(int limit) {
    }

    @Override
    public Collection<SuggestedReviewer> getMatches() throws Exception {
        int max = this.getConfig().getSuggestMax();
        if (this.suggestedReviewers.size() < max) {
            max = this.suggestedReviewers.size();
        }
        ArrayList<SuggestedReviewer> suggestedList = new ArrayList<SuggestedReviewer>(this.suggestedReviewers.values());
        Collections.sort(suggestedList, new SuggestedReviewerManager.SuggestedReviewerComparator(this.totalLOC, this.totalCommits, this.getConfig().getSuggestLOCWeight(), this.getConfig().getSuggestOpenWeight(), this.getConfig().getSuggestLOCWeight()));
        return suggestedList.subList(0, max);
    }

    @RequireSecurityToken(value=false)
    public String execute() throws Exception {
        this.suggestedReviewers = new HashMap<FecruUser, SuggestedReviewer>();
        HashMap<String, Source> availableSources = new HashMap<String, Source>();
        HashSet<Path> paths = new HashSet<Path>();
        long t0 = System.currentTimeMillis();
        for (FileRevisionExtraInfo frx : this.getReview().getFrxs()) {
            if (System.currentTimeMillis() - t0 > 3000L) {
                Logs.APP_LOG.debug((Object)"Suggestion taking longer than 3 seconds, ignoring the rest of the files.");
                break;
            }
            String sourceName = frx.getFileRevision().getSourceName();
            Object source = (Source)availableSources.get(sourceName);
            if (source == null) {
                source = this.sourceFactory.getSource(sourceName, this.effectiveUserProvider.getEffectivePrincipal());
                availableSources.put(sourceName, (Source)source);
            }
            if (source instanceof RepositorySource) {
                paths.add(frx.getFePath().getParent());
                CrucibleRevision cruRev = frx.getFromRevision();
                if (cruRev == null) {
                    cruRev = frx.getFileRevision();
                }
                this.suggestedReviewers = this.suggestedReviewerManager.addToSuggestedReviewers(this.suggestedReviewers, cruRev, this.getReview(), (RepositorySource)source);
                this.totalLOC += ((RepositorySource)source).getFeFileRevision(cruRev.getRevInfoKey()).getLineCount();
                continue;
            }
            Logs.APP_LOG.debug((Object)"Suggest Reviewers blame is not available for the current source.");
        }
        this.totalCommits = 0;
        for (Path path : paths) {
            if (System.currentTimeMillis() - t0 > 3000L) {
                Logs.APP_LOG.debug((Object)"Suggestion taking longer than 3 seconds, ignoring the rest of the paths.");
                break;
            }
            List<ChangesetStatsCalculator.VolumeData> committers = this.getActiveCommitters(this.getRepoName(), path, AppConfig.getUserTimeZone(this.getCurrentUser().getUsername()));
            for (ChangesetStatsCalculator.VolumeData vd : committers) {
                FecruUser user;
                if (vd.getUser() == null || (user = this.userManager.getUser(vd.getUser().getUsername())) == null || this.getReview().isModerated() && this.getReview().getModerator().equals(user) || this.getReview().getAuthor().equals(user) || this.getReview().getReviewers().contains(user) || !ReviewUtil.isAllowedParticipant(this.getReview(), user)) continue;
                SuggestedReviewer suggested = this.suggestedReviewers.get(user);
                if (suggested == null) {
                    suggested = new SuggestedReviewer(user);
                    suggested.addPath(path, -1, 0, vd.getNumCommits());
                }
                suggested.setNumberOfCommits(suggested.getNumberOfCommits() + vd.getNumCommits());
                this.suggestedReviewers.put(user, suggested);
                this.totalCommits += vd.getNumCommits();
            }
        }
        if (this.suggestedReviewers.size() == 0) {
            ActivityItemSearchParams.Builder builder = ActivityItemSearchParams.builder();
            builder.timeZone(AppConfig.getUserTimeZone(this.getCurrentUser().getUsername())).searchDirection(SearchSortOrder.TOWARDS_PAST).maxItems(30).project(this.getProject().getId()).includeCrucible().includeUserInDownStream();
            ActivityItemSearchParams params = builder.build();
            ActivityItemManager activityItemManager = this.getActivityManager(params);
            ActivityItemList itemList = activityItemManager.findActivityItems(params, TotalityFilter.getCurrentPrincipal(), new ActivitySearchMonitor());
            for (ActivityItem item : itemList.getItems()) {
                SuggestedReviewer suggested;
                if (System.currentTimeMillis() - t0 > 3000L) {
                    Logs.APP_LOG.debug((Object)"Suggestion taking longer than 3 seconds, ignoring the rest of the crucible activity.");
                    break;
                }
                FecruUser user = null;
                if (item instanceof ReviewStateChangeActivityItem) {
                    user = ((ReviewStateChangeActivityItem)item).getUser();
                } else if (item instanceof ReviewCompletionActivityItem) {
                    user = ((ReviewCompletionActivityItem)item).getReview().getAuthor();
                } else if (item instanceof ReviewCommentActivityItem) {
                    user = ((ReviewCommentActivityItem)item).getComment().getUser();
                }
                if (user == null || this.getReview().isModerated() && this.getReview().getModerator().equals(user) || this.getReview().getAuthor().equals(user) || this.getReview().getReviewers().contains(user) || !ReviewUtil.isAllowedParticipant(this.getReview(), user) || (suggested = this.suggestedReviewers.get(user)) != null) continue;
                suggested = new SuggestedReviewer(user);
                this.suggestedReviewers.put(user, suggested);
            }
        }
        this.suggestedReviewerManager.setReviewCount(this.suggestedReviewers);
        return "success";
    }

    private ActivityItemManager getActivityManager(ActivityItemSearchParams params) {
        return (ActivityItemManager)SpringContext.getComponent(params.isDownStream() ? "starDownStreamActivityItemManager" : "defaultActivityItemManager");
    }

    private List<ChangesetStatsCalculator.VolumeData> getActiveCommitters(String repname, Path path, TimeZone tz) throws Exception {
        RepositoryHandle rh = this.repositoryManager.getRepository(repname);
        return ChangesetStatsCalculator.calculateMostActiveCommitters(rh.acquireEngine(), path, tz, -90, 9);
    }
}

