/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.actions.search.ajax;

import com.atlassian.crucible.actions.ReviewBaseAction;
import com.atlassian.crucible.actions.search.ajax.AjaxAutocompleter;
import com.atlassian.fecru.page.Page;
import com.atlassian.fecru.page.PageRequest;
import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fisheye.user.permissions.GlobalPermissionManager;
import com.atlassian.fisheye.user.permissions.GlobalPermissionType;
import com.atlassian.xwork.RequireSecurityToken;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.user.UserManager;
import com.cenqua.fisheye.user.UserSearchCriteria;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.annotation.Resource;

public class ReviewerFinderAjaxAction
extends ReviewBaseAction
implements AjaxAutocompleter<ReviewerData> {
    private String q;
    private int limit = 25;
    @Resource
    GlobalPermissionManager globalPermissionManager;
    private List<ReviewerData> matchedUsersAndGroups = new ArrayList<ReviewerData>();

    @Override
    public void setQ(String q2) {
        this.q = q2;
    }

    @Override
    public void setLimit(int limit) {
        this.limit = limit;
    }

    @Override
    public Collection<ReviewerData> getMatches() {
        if (this.matchedUsersAndGroups.size() > this.limit) {
            return this.matchedUsersAndGroups.subList(0, this.limit);
        }
        return this.matchedUsersAndGroups;
    }

    @RequireSecurityToken(value=false)
    public String execute() throws Exception {
        this.matchedUsersAndGroups = this.getAllowedActiveReviewers(this.q);
        return "success";
    }

    @Override
    public String getErrorMsg() {
        return "";
    }

    @Override
    public boolean isWorked() {
        return true;
    }

    private List<ReviewerData> getAllowedActiveReviewers(String prefix) throws DbException {
        ArrayList<ReviewerData> allowed = new ArrayList<ReviewerData>();
        if (this.getReview() != null) {
            allowed.addAll((Collection<ReviewerData>)ImmutableList.copyOf((Iterable)Iterables.transform(this.filter(this.getReview().getProject().getAllowedReviewers(), prefix, true), ReviewerData::new)));
        }
        if (allowed.isEmpty()) {
            allowed.addAll(this.getActiveUsersAndCurrentReviewers(prefix));
        }
        Collections.sort(allowed);
        return allowed;
    }

    private Set<ReviewerData> getActiveUsersAndCurrentReviewers(String prefix) throws DbException {
        Page<FecruUser> matchingUsers = this.userManager.searchUsers(UserSearchCriteria.create().named(prefix).withPermissions(GlobalPermissionType.CRUCIBLE_USER), PageRequest.create((Integer)0, (Integer)this.limit));
        Set<ReviewerData> activeUsersAndCurrentReviewers = StreamSupport.stream(matchingUsers.getValues().spliterator(), false).map(ReviewerData::new).collect(Collectors.toSet());
        if (this.getReview() != null) {
            activeUsersAndCurrentReviewers.addAll((Collection<ReviewerData>)ImmutableList.copyOf((Iterable)Iterables.transform(this.filter(this.getReview().getReviewers(), prefix, false), ReviewerData::new)));
        }
        return activeUsersAndCurrentReviewers;
    }

    private Set<FecruUser> filter(Set<FecruUser> users, String prefix, boolean checkIsActive) {
        return Sets.filter(users, user -> {
            String normalizedPrefix = UserManager.USERNAME_NORMALIZATION.apply(prefix);
            return !(!UserManager.USERNAME_NORMALIZATION.apply(user.getUsername()).contains(normalizedPrefix) && !UserManager.USERNAME_NORMALIZATION.apply(user.getDisplayName()).contains(normalizedPrefix) && !UserManager.USERNAME_NORMALIZATION.apply(user.getEmail()).contains(normalizedPrefix) || checkIsActive && !this.globalPermissionManager.hasPermission(user.getUsername(), GlobalPermissionType.CRUCIBLE_USER));
        });
    }

    public static class ReviewerData
    implements Comparable<ReviewerData> {
        private final FecruUser user;

        ReviewerData(FecruUser user) {
            this.user = user;
        }

        public FecruUser getUser() {
            return this.user;
        }

        @Override
        public int compareTo(@Nonnull ReviewerData other) {
            return FecruUser.DISPLAYNAME_COMPARATOR.compare(this.user, other.user);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.user});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            ReviewerData other = (ReviewerData)obj;
            return Objects.equal((Object)this.user, (Object)other.user);
        }
    }
}

