/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.actions.search.ajax;

import com.atlassian.crucible.actions.BaseAction;
import com.atlassian.crucible.actions.search.ajax.AjaxAutocompleter;
import com.atlassian.crucible.spi.data.ReviewData;
import com.atlassian.fecru.security.CurrentUserPermissions;
import com.atlassian.xwork.RequireSecurityToken;
import com.cenqua.crucible.model.Review;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public class ReviewFinderAjaxAction
extends BaseAction
implements AjaxAutocompleter<Review> {
    private boolean disableLockedReviews;
    private String query;
    private int limit = 10;
    private Collection<Review> matchedReviews;
    @Autowired
    protected CurrentUserPermissions currentUserPermissions;

    public boolean isDisableLockedReviews() {
        return this.disableLockedReviews;
    }

    public void setDisableLockedReviews(boolean disableLockedReviews) {
        this.disableLockedReviews = disableLockedReviews;
    }

    @Override
    public void setQ(String q2) {
        this.query = q2;
    }

    @Override
    public void setLimit(int limit) {
        this.limit = limit;
    }

    @Override
    public Collection<Review> getMatches() {
        return this.matchedReviews;
    }

    @RequireSecurityToken(value=false)
    public String execute() {
        this.matchedReviews = new ArrayList<Review>();
        List reviewDatas = this.searchService.searchReviewForTerm(this.query, Integer.valueOf(0), Integer.valueOf(this.limit), null);
        for (ReviewData reviewData : reviewDatas) {
            this.matchedReviews.add(this.reviewManager.getReviewByPermaId(reviewData.getPermaId().getId()));
        }
        return "success";
    }

    @Override
    public String getErrorMsg() {
        return "";
    }

    @Override
    public boolean isWorked() {
        return true;
    }

    public CurrentUserPermissions getCurrentUserPermissions() {
        return this.currentUserPermissions;
    }
}

