/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.actions.search.ajax;

import com.atlassian.crucible.actions.search.ajax.BaseAutocompleteAjaxAction;
import com.atlassian.fecru.search.common.api.SearchScope;
import com.atlassian.fecru.search.quicknav.ProjectSearchResult;
import com.atlassian.fecru.search.quicknav.ProjectSearcher;
import com.atlassian.xwork.RequireSecurityToken;
import com.cenqua.crucible.model.managers.UserActionManager;
import com.cenqua.fisheye.logging.Logs;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public class ProjectFinderAjaxAction
extends BaseAutocompleteAjaxAction<ProjectSearchResult> {
    private int limit = 10;
    private List<ProjectSearchResult> matches = Collections.emptyList();
    private UserActionManager.Action action = UserActionManager.Action.ACTION_VIEW;
    @Autowired
    private ProjectSearcher searcher;
    private String query;

    @RequireSecurityToken(value=false)
    public String execute() throws Exception {
        this.matches = ImmutableList.copyOf(this.searcher.search(this.query, this.action, SearchScope.builder().withTo(this.limit).build()));
        return "success";
    }

    @Override
    public void setQ(String q2) {
        this.query = q2;
    }

    @Override
    public void setLimit(int limit) {
        this.limit = limit;
    }

    public void setActionName(String actionName) {
        UserActionManager.Action newAction = UserActionManager.Action.getByName(actionName);
        if (newAction != null) {
            this.action = newAction;
        } else {
            Logs.APP_LOG.warn((Object)String.format("Could not create Action with name: %s", actionName));
        }
    }

    @Override
    public Collection<ProjectSearchResult> getMatches() throws Exception {
        if (this.limit < this.matches.size()) {
            return this.matches.subList(0, this.limit);
        }
        return this.matches;
    }
}

