/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.actions.search.ajax;

import com.atlassian.crucible.actions.BaseAction;
import com.atlassian.crucible.actions.search.ajax.AjaxAutocompleter;
import com.atlassian.xwork.RequireSecurityToken;
import com.cenqua.crucible.revision.source.Source;
import com.cenqua.crucible.util.SourceUtils;
import com.cenqua.fisheye.util.SortedList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;

public class CrucibleSourceFinderAjaxAction
extends BaseAction
implements AjaxAutocompleter {
    private Pattern pattern;
    private int limit = 10;
    private Collection<Source> matchedSources = new ArrayList<Source>();
    private String editMode;
    private List<Source> matches = null;

    public static String getSourceType(Source source) {
        return SourceUtils.getSourceType(source);
    }

    @RequireSecurityToken(value=false)
    public String execute() throws Exception {
        for (Source source : this.sourceFactory.getSources(this.getPrincipal())) {
            if (!this.sourceMatches(source)) continue;
            this.matchedSources.add(source);
        }
        return "success";
    }

    private boolean sourceMatches(Source source) {
        return this.pattern.matcher(source.getName()).find();
    }

    @Override
    public void setQ(String q2) {
        this.pattern = Pattern.compile("\\b" + Pattern.quote(q2) + ".*", 2);
    }

    @Override
    public void setLimit(int limit) {
        this.limit = limit;
    }

    public Collection<Source> getMatches() throws Exception {
        if (this.matches == null) {
            this.matches = new SortedList<Source>(this.matchedSources, Source.COMPARATOR);
            if (this.limit < this.matches.size()) {
                this.matches = this.matches.subList(0, this.limit);
            }
        }
        return this.matches;
    }

    @Override
    public String getErrorMsg() {
        return "";
    }

    @Override
    public boolean isWorked() {
        return true;
    }

    public String getEditMode() {
        return this.editMode;
    }

    public void setEditMode(String editMode) {
        this.editMode = editMode;
    }

    public boolean isNoMatches() throws Exception {
        return this.getMatches().isEmpty();
    }
}

