/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.actions.project;

import com.atlassian.crucible.actions.project.ReviewAgeBucketSegment;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.managers.StateManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ReviewAgeBucket {
    private final int maxAge;
    private int totalCount = 0;
    private final String description;
    private final Map<StateManager.States, Integer> counts = new HashMap<StateManager.States, Integer>();

    public ReviewAgeBucket(int maxAge, String description) {
        this.maxAge = maxAge;
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public int getMaxAge() {
        return this.maxAge;
    }

    public boolean isNoReviews() {
        return this.totalCount == 0;
    }

    public StateManager.States addReview(Review r2) {
        Integer n2;
        StateManager.States s2 = r2.getState().getStateType();
        if (r2.getCountActiveReviewers() == 0 && s2.equals((Object)StateManager.States.REVIEW_STATE)) {
            s2 = StateManager.States.SUMMARIZE_STATE;
        }
        if ((n2 = this.counts.get((Object)s2)) == null) {
            n2 = 1;
            this.counts.put(s2, n2);
        } else {
            this.counts.put(s2, n2 + 1);
        }
        ++this.totalCount;
        return s2;
    }

    private int getCount(StateManager.States state) {
        Integer c2 = this.counts.get((Object)state);
        if (c2 == null) {
            return 0;
        }
        return c2;
    }

    public int getTotalCount() {
        return this.totalCount;
    }

    private int getDraftCount() {
        return this.getCount(StateManager.States.DRAFT_STATE);
    }

    public int getToReviewCount() {
        return this.getCount(StateManager.States.REVIEW_STATE);
    }

    public int getToSummariseCount() {
        return this.getCount(StateManager.States.SUMMARIZE_STATE);
    }

    public List<ReviewAgeBucketSegment> getSegments() {
        ArrayList<ReviewAgeBucketSegment> segs = new ArrayList<ReviewAgeBucketSegment>();
        segs.add(new ReviewAgeBucketSegment(this.getDraftCount(), "Draft"));
        segs.add(new ReviewAgeBucketSegment(this.getToReviewCount(), "Review"));
        segs.add(new ReviewAgeBucketSegment(this.getToSummariseCount(), "Summarize"));
        return segs;
    }
}

