/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.actions.project;

import com.atlassian.crucible.actions.chart.BaseSparklineCalculator;
import com.atlassian.crucible.actions.chart.CommentsPerReviewSparklineCalculator;
import com.atlassian.crucible.actions.chart.DaysToCompleteSparklineCalculator;
import com.atlassian.crucible.actions.chart.FilesPerReviewSparklineCalculator;
import com.atlassian.crucible.actions.chart.SparkLineCalculator;
import com.atlassian.crucible.actions.project.BaseProjectAction;
import com.atlassian.crucible.actions.project.ProjectDashboardPagedSearch;
import com.atlassian.crucible.actions.project.ReviewAgeBuckets;
import com.atlassian.crucible.actions.project.ReviewStartCount;
import com.atlassian.crucible.actions.project.StatItem;
import com.atlassian.xwork.RequireSecurityToken;
import com.cenqua.crucible.model.managers.PermissionManager;
import com.cenqua.crucible.model.managers.UserActionManager;
import com.cenqua.crucible.reports.SparkLineResultCache;
import com.cenqua.crucible.view.CommentReportDO;
import com.cenqua.crucible.view.ReviewReportDO;
import com.cenqua.crucible.view.reviewfilters.FilterLink;
import com.cenqua.crucible.view.reviewfilters.ReviewFilterState;
import com.cenqua.crucible.view.reviewfilters.ReviewFilters;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.config.SpringContext;
import com.cenqua.fisheye.util.DateHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;

public class ProjectDashboardAction
extends BaseProjectAction {
    private ReviewAgeBuckets reviewAgeBuckets = null;
    private CommentReportDO crDO;
    private ReviewReportDO rrDO;
    private ProjectDashboardPagedSearch pagedSearch;
    private ReviewFilterState filterState;
    private List<ReviewStartCount> reviewStartCounts;
    private List<StatItem> statItems;
    private SparkLineResultCache sparklineResultCache;
    private int page = 1;
    @Resource
    private RootConfig rootConfig;
    @Resource
    private PermissionManager permissionManager;

    public String getSort() {
        return this.getFilterState().getSort();
    }

    public void setSort(String sort) {
        this.getFilterState().setSort(sort);
    }

    public String getOrder() {
        return this.getFilterState().getOrder();
    }

    public void setOrder(String order) {
        this.getFilterState().setOrder(order);
    }

    @RequireSecurityToken(value=false)
    public String execute() {
        this.getFilterState().setFilterFromSession();
        if (this.getProject() == null) {
            return "error";
        }
        boolean canViewProject = this.permissionManager.canPrincipalDoAction(this.getProject().getPermissionScheme(), this.getPrincipal(), this.getCurrentUser(), UserActionManager.ACTION_VIEW, null);
        if (!canViewProject) {
            return "error";
        }
        return "success";
    }

    public CommentReportDO getCommentReportDO() {
        if (this.crDO == null) {
            this.crDO = new CommentReportDO();
            this.crDO.setProject(this.getProject());
        }
        return this.crDO;
    }

    public ReviewReportDO getReviewReportDO() {
        if (this.rrDO == null) {
            this.rrDO = new ReviewReportDO();
            this.rrDO.setProject(this.getProject());
            this.rrDO.setStateName("Review");
        }
        return this.rrDO;
    }

    public ReviewAgeBuckets getAgeBuckets() {
        if (this.reviewAgeBuckets == null) {
            this.reviewAgeBuckets = new ReviewAgeBuckets(this.getProject(), this.reviewManager);
        }
        return this.reviewAgeBuckets;
    }

    public ProjectDashboardPagedSearch getPagedSearch() {
        if (this.pagedSearch == null) {
            this.pagedSearch = new ProjectDashboardPagedSearch(this.getFilterState(), this.getFilterState().countFilteredReviews(this.getFilterState().getFilter()), this.page);
            SpringContext.autowireObject((Object)this.pagedSearch);
            this.pagedSearch.setPage(Math.min(this.page, this.pagedSearch.getNumberOfPages()));
            this.pagedSearch.setServletRequest(this.getRequest());
            this.setAttribute("this", (Object)this);
        }
        return this.pagedSearch;
    }

    public void setPage(int page) {
        this.page = page;
    }

    @Override
    public void setProjectKey(String projectKey) {
        super.setProjectKey(projectKey);
        this.getFilterState().setProject(this.getProject());
    }

    public String getFilter() {
        return this.getFilterState().getFilter().id;
    }

    public void setFilter(String filter) {
        this.getFilterState().setFilter(filter);
    }

    public ReviewFilterState getFilterState() {
        if (this.filterState == null) {
            this.filterState = new ReviewFilterState(this.getCurrentUser(), ReviewFilters.FilterKey.ALL_OPEN_REVIEWS, "ProjectDashboardAction");
        }
        return this.filterState;
    }

    public List<FilterLink> getFilterLinks() {
        ReviewFilters reviewFilters = new ReviewFilters(this.getProject());
        return Arrays.asList(new FilterLink(reviewFilters.getFilterDefByKey(ReviewFilters.FilterKey.ALL_DRAFT_REVIEWS), this.getFilterState()), new FilterLink(reviewFilters.getFilterDefByKey(ReviewFilters.FilterKey.ALL_OPEN_REVIEWS), this.getFilterState()), new FilterLink(reviewFilters.getFilterDefByKey(ReviewFilters.FilterKey.ALL_CLOSED_REVIEWS), this.getFilterState()), new FilterLink(reviewFilters.getFilterDefByKey(ReviewFilters.FilterKey.ALL_REVIEWS), this.getFilterState()));
    }

    public List<ReviewStartCount> getReviewStartCounts() {
        if (this.reviewStartCounts == null) {
            this.reviewStartCounts = new ArrayList<ReviewStartCount>();
            Calendar cal = DateHelper.getStartOfTodayAsCalendar(AppConfig.getsConfig().getTimezone());
            Date startOfToday = cal.getTime();
            this.reviewStartCounts.add(new ReviewStartCount(this.reviewManager, startOfToday, new Date(), "today", this.getProject()));
            cal.add(6, -7);
            Date startOfWeek = cal.getTime();
            this.reviewStartCounts.add(new ReviewStartCount(this.reviewManager, startOfWeek, startOfToday, "previous week", this.getProject()));
            cal = DateHelper.getStartOfTodayAsCalendar(this.rootConfig.getTimezone());
            cal.add(2, -1);
            Date startOfMonth = cal.getTime();
            this.reviewStartCounts.add(new ReviewStartCount(this.reviewManager, startOfMonth, startOfWeek, "previous month", this.getProject()));
        }
        return this.reviewStartCounts;
    }

    public List<StatItem> getStatItems() {
        if (this.statItems == null) {
            this.statItems = new ArrayList<StatItem>();
            double[] sparkSummaries = this.getSparkSummaries();
            this.statItems.add(new StatItem("Comments", "per review", sparkSummaries[0], "commentsperreviewsparkimg"));
            this.statItems.add(new StatItem("Days", "to complete", sparkSummaries[1], "daystocompletesparkimg"));
            this.statItems.add(new StatItem("Open", "reviews", this.getFilterState().countFilteredReviews(ReviewFilters.FilterKey.ALL_OPEN_REVIEWS), "openreviewssparkimg"));
            this.statItems.add(new StatItem("Files", "per review", sparkSummaries[2], "filesperreviewsparkimg"));
        }
        return this.statItems;
    }

    private double[] getSparkSummaries() {
        Calendar cal = DateHelper.getStartOfTodayAsCalendar(AppConfig.getsConfig().getTimezone());
        cal.add(6, 1);
        Date to = cal.getTime();
        cal.add(2, -1);
        Date from = cal.getTime();
        List<BaseSparklineCalculator> processors = Arrays.asList(new CommentsPerReviewSparklineCalculator(from, to, this.commentManager), new DaysToCompleteSparklineCalculator(from, to), new FilesPerReviewSparklineCalculator(from, to));
        if (!this.sparklineResultCache.contains(this.getProject(), from, to, processors.get(0))) {
            this.sparklineResultCache.precalculate(this.getProject(), from, to, processors);
        }
        double[] result = new double[processors.size()];
        int i2 = 0;
        for (SparkLineCalculator sparkLineCalculator : processors) {
            result[i2++] = this.sparklineResultCache.get(this.getProject(), from, to, sparkLineCalculator).getSummary();
        }
        return result;
    }

    public void setSparklineResultCache(SparkLineResultCache sparklineResultCache) {
        this.sparklineResultCache = sparklineResultCache;
    }

    public String getReviewsStartedImageParams() {
        StringBuilder sb = new StringBuilder();
        String sep = "?";
        for (ReviewStartCount c2 : this.getReviewStartCounts()) {
            sb.append(sep).append("value=").append(c2.getCount());
            sep = "&";
        }
        return sb.toString();
    }

    public boolean isSomeReviewsStarted() {
        for (ReviewStartCount c2 : this.getReviewStartCounts()) {
            if (c2.getCount() <= 0) continue;
            return true;
        }
        return false;
    }

    public String getFilterParams() {
        return this.getFilterState().getFilterParams();
    }

    public String getFilterName() {
        return this.getFilterState().getFilterName();
    }
}

