/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.actions.profile;

import com.atlassian.crucible.spi.TxCallback;
import com.atlassian.fecru.user.EffectiveUserProvider;
import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fecru.user.UserProfile;
import com.atlassian.fisheye.spi.TxTemplate;
import com.atlassian.xwork.RequireSecurityToken;
import com.cenqua.fisheye.web.profile.actions.AbstractProfileAction;
import javax.annotation.Resource;
import org.springframework.transaction.TransactionStatus;

public class EditCruciblePrefsAction
extends AbstractProfileAction {
    @Resource
    private TxTemplate txTemplate;
    @Resource
    private EffectiveUserProvider effectiveUserProvider;
    private Integer notifyStateChange;
    private Integer notifyComment;
    private Integer notifyReply;
    private Integer notifyGeneral;
    private Integer notifyComplete;
    private Integer notifyUncomplete;
    private boolean uncompleteOnDefect;
    private boolean uncompleteOnRevisionAdded;
    private boolean notifyMyActions;
    private boolean autoMarkFilesRead;
    private String email;

    public Integer getNotifyStateChange() {
        return this.notifyStateChange;
    }

    public void setNotifyStateChange(Integer notifyStateChange) {
        this.notifyStateChange = notifyStateChange;
    }

    public Integer getNotifyUncomplete() {
        return this.notifyUncomplete;
    }

    public void setNotifyUncomplete(Integer notifyUncomplete) {
        this.notifyUncomplete = notifyUncomplete;
    }

    public boolean isUncompleteOnDefect() {
        return this.uncompleteOnDefect;
    }

    public void setUncompleteOnDefect(boolean uncompleteOnDefect) {
        this.uncompleteOnDefect = uncompleteOnDefect;
    }

    public boolean isUncompleteOnRevisionAdded() {
        return this.uncompleteOnRevisionAdded;
    }

    public void setUncompleteOnRevisionAdded(boolean uncompleteOnRevisionAdded) {
        this.uncompleteOnRevisionAdded = uncompleteOnRevisionAdded;
    }

    public Integer getNotifyComment() {
        return this.notifyComment;
    }

    public void setNotifyComment(Integer notifyComment) {
        this.notifyComment = notifyComment;
    }

    public Integer getNotifyReply() {
        return this.notifyReply;
    }

    public void setNotifyReply(Integer notifyReply) {
        this.notifyReply = notifyReply;
    }

    public Integer getNotifyGeneral() {
        return this.notifyGeneral;
    }

    public void setNotifyGeneral(Integer notifyGeneral) {
        this.notifyGeneral = notifyGeneral;
    }

    public Integer getNotifyComplete() {
        return this.notifyComplete;
    }

    public void setNotifyComplete(Integer notifyComplete) {
        this.notifyComplete = notifyComplete;
    }

    public boolean isNotifyMyActions() {
        return this.notifyMyActions;
    }

    public void setNotifyMyActions(boolean notifyMyActions) {
        this.notifyMyActions = notifyMyActions;
    }

    public boolean isAutoMarkFilesRead() {
        return this.autoMarkFilesRead;
    }

    public void setAutoMarkFilesRead(boolean autoMarkFilesRead) {
        this.autoMarkFilesRead = autoMarkFilesRead;
    }

    public String getEmail() {
        return this.email;
    }

    public String execute() throws Exception {
        return this.txTemplate.execute(new TxCallback<String>(){

            @Override
            public String doInTransaction(TransactionStatus status) throws Exception {
                FecruUser user = EditCruciblePrefsAction.this.getCurrentUser();
                if (user != null) {
                    EditCruciblePrefsAction.this.email = user.getEmail();
                    EditCruciblePrefsAction.this.configChangePasswordEnabled(user.getUsername());
                    UserProfile profile = EditCruciblePrefsAction.this.userProfileManager.getProfile(user.getUsername());
                    profile.setCommentEmailNotification(EditCruciblePrefsAction.this.notifyComment);
                    profile.setReplyEmailNotification(EditCruciblePrefsAction.this.notifyReply);
                    profile.setCompleteEmailNotification(EditCruciblePrefsAction.this.notifyComplete);
                    profile.setGeneralEmailNotification(EditCruciblePrefsAction.this.notifyGeneral);
                    profile.setStateChangeEmailNotification(EditCruciblePrefsAction.this.notifyStateChange);
                    profile.setAutoUncompleteEmailNotification(EditCruciblePrefsAction.this.notifyUncomplete);
                    profile.setUncompleteOnDefect(EditCruciblePrefsAction.this.uncompleteOnDefect);
                    profile.setUncompleteOnRevisionAdded(EditCruciblePrefsAction.this.uncompleteOnRevisionAdded);
                    profile.setDontSendMeMyNotifications(!EditCruciblePrefsAction.this.notifyMyActions);
                    profile.setAutoMarkFilesRead(EditCruciblePrefsAction.this.autoMarkFilesRead);
                    EditCruciblePrefsAction.this.userProfileManager.setProfile(user.getUsername(), profile);
                    return "success";
                }
                EditCruciblePrefsAction.this.addActionError("Couldn't load user details");
                return "error";
            }
        });
    }

    @RequireSecurityToken(value=false)
    public String doDefault() throws Exception {
        FecruUser user = this.getCurrentUser();
        if (user != null) {
            this.email = user.getEmail();
            this.configChangePasswordEnabled(user.getUsername());
            UserProfile profile = this.userProfileManager.getProfile(user.getUsername());
            this.notifyComment = profile.getCommentEmailNotification();
            this.notifyReply = profile.getReplyEmailNotification();
            this.notifyComplete = profile.getCompleteEmailNotification();
            this.notifyGeneral = profile.getGeneralEmailNotification();
            this.notifyStateChange = profile.getStateChangeEmailNotification();
            this.notifyUncomplete = profile.getAutoUncompleteEmailNotification();
            this.uncompleteOnDefect = profile.getUncompleteOnDefect();
            this.uncompleteOnRevisionAdded = profile.getUncompleteOnRevisionAdded();
            this.notifyMyActions = !profile.getDontSendMeMyNotifications();
            this.autoMarkFilesRead = profile.isAutoMarkFilesRead();
            this.profile = profile;
            return "success";
        }
        this.addActionError("Couldn't load user details");
        return "error";
    }

    private FecruUser getCurrentUser() {
        return this.effectiveUserProvider.getEffectiveUser();
    }
}

