/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.actions.jira;

import com.atlassian.crucible.actions.jira.BaseCommentIssueAjaxAction;
import com.atlassian.fisheye.jira.JiraIssue;
import com.cenqua.crucible.model.Comment;
import com.cenqua.fisheye.logging.Logs;
import com.google.common.base.Strings;

public class ResolveCommentIssueAjaxAction
extends BaseCommentIssueAjaxAction {
    Comment comment;
    private JiraIssue jiraIssue;

    public String getStatus() {
        String status = null;
        if (this.jiraIssue != null) {
            status = this.jiraIssue.getStatus().getName();
        }
        return status;
    }

    public String getKey() {
        return this.comment == null ? "error" : this.comment.getJiraIssueKey();
    }

    public String execute() throws Exception {
        if (!this.isAllowed()) {
            String msg = "Subtask not resolved - only review participants can resolve subtasks from comments.";
            this.setErrorMsg(msg);
            Logs.APP_LOG.debug((Object)msg);
            return "error";
        }
        this.comment = this.commentManager.getById(this.getCommentId());
        if (this.comment == null) {
            return "error";
        }
        if (Strings.isNullOrEmpty((String)this.comment.getJiraIssueKey())) {
            String msg = "Subtask not resolved - comment " + this.comment.getPermaId() + " is not linked to a JIRA.";
            this.setErrorMsg(msg);
            Logs.APP_LOG.debug((Object)msg);
            return "error";
        }
        try {
            JiraIssue result = this.jiraIssueService.getJiraIssueAggregateExceptions(this.comment.getJiraIssueKey(), this.getQueryContext());
            this.jiraIssue = this.resolveSubtask(result);
            return "success";
        }
        catch (Exception e2) {
            String message = "Error resolving subtask: " + e2.getMessage();
            Logs.APP_LOG.warn((Object)message, (Throwable)e2);
            return this.error(message);
        }
    }
}

