/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.actions.jira;

import com.atlassian.crucible.actions.AjaxResponse;
import com.atlassian.crucible.actions.ReviewBaseAction;
import com.atlassian.fisheye.jira.JiraIssue;
import com.atlassian.fisheye.jira.RemoteJiraException;
import com.cenqua.crucible.model.Comment;
import com.cenqua.crucible.model.ReviewParticipant;
import com.cenqua.fisheye.logging.Logs;
import com.google.common.base.Strings;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;

public class ResolveAllReviewSubtasksAjaxAction
extends ReviewBaseAction
implements AjaxResponse {
    private int resolved;
    private String errorMsg;

    public String execute() throws Exception {
        if (!this.isAllowed()) {
            this.errorMsg = "No subtasks resolved - only review participants can resolve subtasks from comments.";
            return "error";
        }
        this.resolved = 0;
        ArrayList<String> errors = new ArrayList<String>();
        for (Comment comment : this.getCommentsWithUnresolvedSubtasks()) {
            try {
                JiraIssue result = this.jiraIssueService.getJiraIssueAggregateExceptions(comment.getJiraIssueKey(), this.getQueryContext());
                this.resolveSubtask(result);
                ++this.resolved;
            }
            catch (RemoteJiraException e2) {
                String message = String.format("Error resolving subtask %s: %s", comment.getJiraIssueKey(), e2.getMessage());
                Logs.APP_LOG.warn((Object)message);
                errors.add(message);
            }
        }
        if (this.isErrorConnectingToJiraServer() || !errors.isEmpty()) {
            this.errorMsg = String.format("Error resolving all subtasks for review %s. Individual subtask problems: [%s]", this.getReview().getPermaId(), StringUtils.join(errors, (String)", "));
            return "error";
        }
        return "success";
    }

    private boolean isAllowed() {
        for (ReviewParticipant p2 : this.getReview().getParticipants()) {
            if (!p2.getUser().equals(this.getCurrentUser())) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getErrorMsg() {
        return this.errorMsg;
    }

    @Override
    public boolean isWorked() {
        return Strings.isNullOrEmpty((String)this.errorMsg);
    }

    public int getResolved() {
        return this.resolved;
    }
}

