/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.actions.jira;

import com.atlassian.applinks.api.CredentialsRequiredException;
import com.atlassian.crucible.actions.jira.BaseCommentIssueAjaxAction;
import com.atlassian.crucible.configuration.metrics.FieldDefinition;
import com.atlassian.fisheye.jira.JiraIssue;
import com.atlassian.fisheye.jira.RemoteJiraException;
import com.cenqua.crucible.model.Comment;
import com.cenqua.crucible.model.CustomField;
import com.cenqua.crucible.model.FRXComment;
import com.cenqua.crucible.model.InlineComment;
import com.cenqua.crucible.model.InlineCommentRevisionDetail;
import com.cenqua.crucible.model.Principal;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.logging.Logs;
import java.io.IOException;
import java.util.Comparator;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;

public class LinkCommentIssueAjaxAction
extends BaseCommentIssueAjaxAction {
    private static final Comparator<Map.Entry<FieldDefinition, CustomField>> CUSTOM_FIELD_ENTRY_COMPARATOR = new Comparator<Map.Entry<FieldDefinition, CustomField>>(){

        @Override
        public int compare(Map.Entry<FieldDefinition, CustomField> e0, Map.Entry<FieldDefinition, CustomField> e1) {
            return e0.getKey().getLabel().compareTo(e1.getKey().getLabel());
        }
    };
    private Comment comment;
    private JiraIssue jiraIssue;
    private String summary;
    private String assignee;

    public String getKey() {
        return this.comment == null ? "error" : this.comment.getJiraIssueKey();
    }

    public String getStatus() {
        return this.jiraIssue == null ? null : this.jiraIssue.getStatus().getName();
    }

    public String execute() throws Exception {
        block12: {
            if (!this.isAllowed()) {
                return this.error("Subtask not created - only review participants can create subtasks from comments.");
            }
            if (StringUtils.isEmpty((String)this.getReview().getJiraIssueKey())) {
                return this.error("Subtask not created - parent review " + this.getReview().getPermaId() + " is not linked to a JIRA.");
            }
            if (StringUtils.isEmpty((String)this.summary)) {
                return this.error("Subtask not created - issue summary must not be blank.");
            }
            this.comment = this.commentManager.getById(this.getCommentId());
            if (this.comment == null) {
                return this.error("Subtask not created - couldn't find comment for id '" + this.getCommentId() + "'");
            }
            if (StringUtils.isEmpty((String)this.comment.getJiraIssueKey())) {
                try {
                    this.jiraIssue = this.createSubtaskForComment(this.getPrincipal(), this.getReview().getJiraIssueKey(), this.comment);
                    this.beginTx();
                    try {
                        this.comment.setJiraIssueKey(this.jiraIssue.getKey());
                        this.commitTx();
                        this.setUrl(this.jiraIssue.getJiraServer().getApplicationLink().getDisplayUrl().toASCIIString());
                        break block12;
                    }
                    finally {
                        this.rollbackTxIfNotCommited();
                    }
                }
                catch (Exception e2) {
                    String message = "Error creating subtask in JIRA: " + e2.getMessage();
                    Logs.APP_LOG.warn((Object)message, (Throwable)e2);
                    return this.error(message);
                }
            }
            try {
                JiraIssue jiraIssue = this.jiraIssueService.getJiraIssueAggregateExceptions(this.comment.getJiraIssueKey(), this.getQueryContext());
                this.setUrl(jiraIssue.getJiraServer().getApplicationLink().getDisplayUrl().toASCIIString());
            }
            catch (RemoteJiraException e3) {
                String message = String.format("Cannot find subtask %s in JIRA: %s", this.comment.getJiraIssueKey(), e3.getMessage());
                Logs.APP_LOG.warn((Object)message);
                return this.error(message);
            }
        }
        return "success";
    }

    private JiraIssue createSubtaskForComment(Principal principal, String parentKey, Comment comment) throws CredentialsRequiredException, IOException, RemoteJiraException {
        String subtaskDescription = this.formatSubtaskDescription(comment, principal);
        JiraIssue result = this.jiraIssueService.getJiraIssueAggregateExceptions(parentKey, this.getQueryContext());
        return result.createSubtask(StringUtils.defaultIfEmpty((String)this.getAssignee(), (String)""), this.getSummary(), subtaskDescription);
    }

    private String formatSubtaskDescription(Comment comment, Principal principal) {
        String type = comment.isDefectRaised() ? "defect" : "comment";
        String url = AppConfig.getsConfig().getSiteURL() + "/cru/" + this.getReview().getPermaId() + "#c" + comment.getId();
        String authorIfNotLoggedInUser = principal.getUserName().equals(comment.getUser().getUsername()) ? "" : comment.getUser().getDisplayName() + "'s ";
        StringBuilder customFields = new StringBuilder();
        for (Map.Entry entry : this.getSortedCustomFieldSet(comment)) {
            customFields.append(((FieldDefinition)entry.getKey()).getLabel()).append(": ").append(((CustomField)entry.getValue()).getHrValue()).append("\n");
        }
        if (customFields.length() > 0) {
            customFields.append("\n");
        }
        String commentLocation = "";
        if (comment.isRevision()) {
            InlineComment inlineComment = comment.getInlineComment();
            if (inlineComment != null) {
                String lineRange = null;
                for (InlineCommentRevisionDetail detail : inlineComment.getDetails()) {
                    if (lineRange == null) {
                        lineRange = detail.getLineRange();
                        continue;
                    }
                    if (lineRange.equals(detail.getLineRange())) continue;
                    lineRange = null;
                    break;
                }
                if (lineRange != null) {
                    String plural = lineRange.contains("-") ? "lines" : "line";
                    commentLocation = String.format(" on %s %s %s", inlineComment.getFrx().getFileRevision().getFileName(), plural, lineRange);
                } else {
                    commentLocation = " on " + inlineComment.getFrx().getFileRevision().getFileName();
                }
            } else {
                FRXComment frxComment = comment.getFrxComment();
                if (frxComment != null) {
                    commentLocation = " on " + frxComment.getFrx().getFileRevision().getFileName();
                }
            }
        }
        return String.format("%sCreated by %s from %sCrucible %s%s %s :\n\n%s", customFields.toString(), principal.getDisplayName(), authorIfNotLoggedInUser, type, commentLocation, url, comment.getMessage());
    }

    private SortedSet<Map.Entry<FieldDefinition, CustomField>> getSortedCustomFieldSet(Comment comment) {
        TreeSet<Map.Entry<FieldDefinition, CustomField>> fields = new TreeSet<Map.Entry<FieldDefinition, CustomField>>(CUSTOM_FIELD_ENTRY_COMPARATOR);
        for (Map.Entry<FieldDefinition, CustomField> e2 : comment.getAllMappedFieldSet()) {
            if (e2.getValue() == null) continue;
            fields.add(e2);
        }
        return fields;
    }

    public String getSummary() {
        return this.summary;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public String getAssignee() {
        return this.assignee;
    }

    public void setAssignee(String assignee) {
        this.assignee = assignee;
    }
}

