/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.actions.jira;

import com.atlassian.applinks.api.CredentialsRequiredException;
import com.atlassian.crucible.actions.RemoteRequestAjaxResponse;
import com.atlassian.crucible.actions.ReviewBaseAction;
import com.atlassian.fecru.applinks.CredentialsRequiredMessage;
import com.atlassian.fisheye.jira.JiraExceptionMessage;
import com.atlassian.fisheye.jira.JiraIssue;
import com.atlassian.fisheye.jira.JiraIssueUtil;
import com.atlassian.fisheye.jira.JiraServer;
import com.atlassian.fisheye.jira.OauthRequestsIgnoredException;
import com.atlassian.fisheye.jira.issue.RemoteExceptionHandler;
import java.util.ArrayList;
import java.util.List;

public class JiraBaseAjaxAction
extends ReviewBaseAction
implements RemoteRequestAjaxResponse {
    protected List<CredentialsRequiredMessage> credentialsRequiredMessages = new ArrayList<CredentialsRequiredMessage>();
    protected List<JiraExceptionMessage> jiraExceptions = new ArrayList<JiraExceptionMessage>();
    protected String errorMsg;
    protected boolean worked;
    private JiraIssue jiraIssue;

    protected JiraIssue getIssue(String issueKey) {
        if (this.jiraIssue == null) {
            RemoteExceptionHandler exceptionHandler = new RemoteExceptionHandler(){

                @Override
                public void acceptCredentialsRequired(JiraServer jiraServer, CredentialsRequiredException cre) {
                    JiraBaseAjaxAction.this.credentialsRequiredMessages.add(JiraIssueUtil.buildCredentialsRequired(jiraServer, cre, false));
                }

                @Override
                public void acceptException(JiraServer jiraServer, Exception e2) {
                    JiraBaseAjaxAction.this.jiraExceptions.add(JiraIssueUtil.buildJiraException(jiraServer, e2, false));
                }
            };
            this.jiraIssue = this.jiraIssueService.getJiraIssue(issueKey, this.getQueryContext(), exceptionHandler);
        }
        return this.jiraIssue;
    }

    @Override
    public List<CredentialsRequiredMessage> getCredentialsRequired() {
        return this.credentialsRequiredMessages;
    }

    @Override
    public List<JiraExceptionMessage> getJiraExceptions() {
        return this.jiraExceptions;
    }

    @Override
    public boolean isOauthIgnored() {
        return this.getException() instanceof OauthRequestsIgnoredException;
    }

    @Override
    public Exception getException() {
        return this.jiraExceptions.isEmpty() ? null : this.jiraExceptions.get(0).getOriginalException();
    }

    @Override
    public String getErrorMsg() {
        return this.errorMsg;
    }

    @Override
    public boolean isWorked() {
        return this.worked;
    }
}

