/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.actions.jira;

import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkService;
import com.atlassian.crucible.actions.AjaxResponse;
import com.atlassian.crucible.actions.BaseAction;
import com.atlassian.fecru.user.FecruUser;
import com.cenqua.crucible.model.UserAppLink;
import com.cenqua.crucible.model.managers.UserAppLinkManager;
import com.cenqua.fisheye.logging.Logs;
import javax.annotation.Resource;

public class IgnoreLinkedApplicationAjaxAction
extends BaseAction
implements AjaxResponse {
    @Resource
    private UserAppLinkManager userAppLinkManager;
    @Resource
    private ApplicationLinkService applicationLinkService;
    private String appLinkId;
    private boolean worked = true;
    private String errorMsg;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String execute() throws Exception {
        ApplicationId id;
        FecruUser user = this.effectiveUserProvider.getEffectiveUser();
        if (user == null) {
            return "success";
        }
        try {
            id = new ApplicationId(this.appLinkId);
        }
        catch (IllegalArgumentException e2) {
            return this.error("Invalid appLinkId parameter: " + e2.getMessage());
        }
        ApplicationLink applicationLink = this.applicationLinkService.getApplicationLink(id);
        if (applicationLink == null) {
            return this.error("No application link with id " + id + " exists.");
        }
        try {
            this.beginTx();
            this.userAppLinkManager.getOrCreateUserAppLink(user, applicationLink).setIgnore(true);
            this.commitTx();
        }
        finally {
            this.rollbackTxIfNotCommited();
        }
        return "success";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String clearAll() throws Exception {
        FecruUser user = this.effectiveUserProvider.getEffectiveUser();
        if (user == null) {
            return this.error("Can't clear ignore flags for anonymous user.");
        }
        for (UserAppLink link : this.userAppLinkManager.getUserAppLinks(user)) {
            try {
                this.beginTx();
                link.setIgnore(false);
                this.commitTx();
            }
            finally {
                this.rollbackTxIfNotCommited();
            }
        }
        return "success";
    }

    public void setAppLinkId(String appLinkId) {
        this.appLinkId = appLinkId;
    }

    public String getAppLinkId() {
        return this.appLinkId;
    }

    public void setWorked(boolean worked) {
        this.worked = worked;
    }

    @Override
    public boolean isWorked() {
        return this.worked;
    }

    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }

    @Override
    public String getErrorMsg() {
        return this.errorMsg;
    }

    protected String error(String message) {
        this.setErrorMsg(message);
        this.setWorked(false);
        Logs.APP_LOG.debug((Object)message);
        return "error";
    }
}

