/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.actions.jira;

import com.atlassian.applinks.api.CredentialsRequiredException;
import com.atlassian.crucible.actions.jira.BaseCommentIssueAjaxAction;
import com.atlassian.fisheye.jira.JiraIssue;
import com.atlassian.fisheye.jira.JiraServer;
import com.atlassian.fisheye.jira.issue.RemoteExceptionHandler;
import com.atlassian.xwork.RequireSecurityToken;
import com.cenqua.crucible.model.Comment;
import com.cenqua.crucible.model.FRXComment;
import com.cenqua.crucible.model.FileRevisionExtraInfo;
import com.cenqua.crucible.model.InlineComment;
import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.model.managers.PermissionManager;
import com.cenqua.crucible.model.managers.UserActionManager;
import com.cenqua.fisheye.logging.Logs;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;

public class CommentIssueStatusAjaxAction
extends BaseCommentIssueAjaxAction {
    Map<Comment, JiraIssue> commentStatuses;
    Set<Comment> comments = new HashSet<Comment>();
    List<Integer> commentIds = new ArrayList<Integer>();
    @Resource
    private PermissionManager permissionManager;

    public Map<Comment, JiraIssue> getCommentStatuses() {
        return this.commentStatuses;
    }

    public void setCommentIds(Integer[] vals) {
        this.commentIds.addAll(Arrays.asList(vals));
    }

    private Set<Comment> getAllCommentsWithJiraIssues() {
        HashSet<Comment> commentsWithJiras = new HashSet<Comment>();
        for (Comment comment : this.getReview().getComments()) {
            if (!CommentIssueStatusAjaxAction.hasJiraIssue(comment)) continue;
            commentsWithJiras.add(comment);
        }
        for (FileRevisionExtraInfo frx : this.getReview().getFrxs()) {
            Comment comment;
            for (FRXComment frxComment : frx.getFrxComments()) {
                comment = frxComment.getComment();
                if (!CommentIssueStatusAjaxAction.hasJiraIssue(comment)) continue;
                commentsWithJiras.add(comment);
            }
            for (InlineComment ic : frx.getInlineComments()) {
                comment = ic.getComment();
                if (!CommentIssueStatusAjaxAction.hasJiraIssue(comment)) continue;
                commentsWithJiras.add(comment);
            }
        }
        return commentsWithJiras;
    }

    private static boolean hasJiraIssue(Comment c2) {
        return !c2.isDraft() && !c2.isDeleted() && !Strings.isNullOrEmpty((String)c2.getJiraIssueKey());
    }

    @Override
    public boolean isAllowed() {
        return this.permissionManager.canPrincipalDoAction(this.getProject().getPermissionScheme(), this.getPrincipal(), this.getCurrentUser(), UserActionManager.ACTION_VIEW, this.getReview());
    }

    @RequireSecurityToken(value=false)
    public String execute() throws Exception {
        this.commentStatuses = new HashMap<Comment, JiraIssue>();
        if (!this.isAllowed()) {
            String msg = "You must be allowed to view this review to view this subtask's status";
            this.setErrorMsg(msg);
            Logs.APP_LOG.debug((Object)msg);
            return "error";
        }
        if (this.commentIds.isEmpty()) {
            this.comments = this.getAllCommentsWithJiraIssues();
        } else {
            for (Integer commentId : this.commentIds) {
                Comment comment = this.commentManager.getById(commentId);
                if (comment == null) {
                    return "error";
                }
                this.comments.add(comment);
            }
        }
        Project cp = this.getReview().getProject();
        for (Comment comment : this.comments) {
            String jiraIssueKey = comment.getJiraIssueKey();
            if (Strings.isNullOrEmpty((String)jiraIssueKey)) {
                Logs.APP_LOG.debug((Object)(comment.getPermaId() + " is not linked to a JIRA."));
                continue;
            }
            this.commentStatuses.put(comment, null);
            JiraIssue jiraIssue = this.jiraIssueService.getJiraIssue(jiraIssueKey, this.getQueryContext(), new RemoteExceptionHandler(){

                @Override
                public void acceptCredentialsRequired(JiraServer jiraServer, CredentialsRequiredException cre) {
                }

                @Override
                public void acceptException(JiraServer jiraServer, Exception e2) {
                }
            });
            this.commentStatuses.put(comment, jiraIssue);
        }
        return "success";
    }
}

