/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.actions.jira;

import com.atlassian.crucible.actions.jira.BaseCommentIssueAjaxAction;
import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fisheye.jira.JiraIssue;
import com.atlassian.fisheye.jira.RemoteJiraException;
import com.atlassian.xwork.RequireSecurityToken;
import com.cenqua.crucible.model.Comment;
import com.cenqua.crucible.model.Principal;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class AssignableUsersForSubtaskAjaxAction
extends BaseCommentIssueAjaxAction {
    private Map<String, String> assignableUsers = new LinkedHashMap<String, String>();
    private boolean sharedUserBase;

    @RequireSecurityToken(value=false)
    public String execute() throws Exception {
        JiraIssue issue;
        if (!this.isAllowed()) {
            return this.error("Only review participants can query assignable users.");
        }
        if (StringUtils.isEmpty((String)this.getReview().getJiraIssueKey())) {
            return this.error("Review does not have a linked JIRA, can't calculate assignable users.");
        }
        try {
            issue = this.jiraIssueService.getJiraIssueAggregateExceptions(this.getReview().getJiraIssueKey(), this.getQueryContext());
        }
        catch (RemoteJiraException e2) {
            return this.error(e2.getMessage());
        }
        if (issue.getJiraServer().isAllowUnassigned()) {
            this.assignableUsers.put("", "Unassigned");
        }
        if (issue.getAssignee() != null) {
            this.assignableUsers.put(issue.getAssignee().getUsername(), issue.getAssignee().getDisplayName());
        }
        if (issue.getReporter() != null) {
            this.assignableUsers.put(issue.getReporter().getUsername(), issue.getReporter().getDisplayName());
        }
        this.sharedUserBase = issue.getJiraServer().isSharedUserBase();
        if (this.sharedUserBase) {
            Comment comment = this.commentManager.getById(this.getCommentId());
            FecruUser reviewAuthor = comment.getReview().getAuthor();
            this.assignableUsers.put(reviewAuthor.getUsername(), reviewAuthor.getDisplayName());
            FecruUser reviewModerator = comment.getReview().getModerator();
            if (reviewModerator != null) {
                this.assignableUsers.put(reviewModerator.getUsername(), reviewModerator.getDisplayName());
            }
            this.assignableUsers.put(comment.getUser().getUsername(), comment.getUser().getDisplayName());
            Principal p2 = this.effectiveUserProvider.getEffectivePrincipal();
            this.assignableUsers.put(p2.getUserName(), p2.getDisplayName());
        }
        return "success";
    }

    public Map<String, String> getAssignableUsers() {
        return this.assignableUsers;
    }

    public boolean isSharedUserBase() {
        return this.sharedUserBase;
    }
}

