/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.actions.create.ajax;

import com.atlassian.crucible.actions.create.EditRevisionsAction;
import com.atlassian.crucible.actions.search.ajax.AjaxAutocompleter;
import com.atlassian.fecru.user.FecruUser;
import com.atlassian.xwork.RequireSecurityToken;
import com.cenqua.fisheye.util.SortedList;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class EditConstraintsAjaxAction
extends EditRevisionsAction
implements AjaxAutocompleter<ConstraintsMatch> {
    private Pattern pattern;
    private int limit = 10;
    private Collection<ConstraintsMatch> matches = new ArrayList<ConstraintsMatch>();
    private static final Function<String, ConstraintsMatch> BRANCH_TO_CONSTRAINTS_MATCH = new Function<String, ConstraintsMatch>(){

        public ConstraintsMatch apply(String branch) {
            return new ConstraintsMatch(branch);
        }
    };

    @Override
    @RequireSecurityToken(value=false)
    public String execute() throws Exception {
        if ("branches".equals(this.command)) {
            this.matches = this.matchBranches();
        } else if ("users".equals(this.command)) {
            this.matches = this.matchUsers();
        } else {
            return "error";
        }
        return "success";
    }

    private Collection<ConstraintsMatch> matchBranches() {
        Iterable filteredBranches = Iterables.filter(this.getAvailableBranches(), (Predicate)new Predicate<String>(){

            public boolean apply(String input) {
                return EditConstraintsAjaxAction.this.matches(input);
            }
        });
        return Lists.newArrayList((Iterable)Iterables.transform((Iterable)Iterables.limit((Iterable)filteredBranches, (int)this.limit), BRANCH_TO_CONSTRAINTS_MATCH));
    }

    private Collection<ConstraintsMatch> matchUsers() throws Exception {
        Set<FecruUser> availableUsers = this.getAvailableUsers();
        return Stream.concat(availableUsers.stream(), availableUsers.contains(this.getCurrentUser()) ? Stream.empty() : Stream.of(this.getCurrentUser())).filter(user -> this.matches(user.getUsername()) || this.matches(user.getDisplayName())).limit(this.limit).map(ConstraintsMatch::new).collect(Collectors.toList());
    }

    private boolean matches(String s2) {
        return this.pattern.matcher(s2).find();
    }

    @Override
    public void setQ(String q2) {
        this.pattern = Pattern.compile("\\b" + Pattern.quote(q2) + ".*", 2);
    }

    @Override
    public void setLimit(int limit) {
        this.limit = limit;
    }

    @Override
    public Collection<ConstraintsMatch> getMatches() throws Exception {
        SortedList<ConstraintsMatch> matches = new SortedList<ConstraintsMatch>(this.matches, ConstraintsMatch.COMPARATOR);
        if (this.limit < matches.size()) {
            return matches.subList(0, this.limit);
        }
        return matches;
    }

    @Override
    public String getErrorMsg() {
        return "";
    }

    @Override
    public boolean isWorked() {
        return true;
    }

    @Override
    public String getEditMode() {
        return "constraints";
    }

    public static class ConstraintsMatch {
        public static final Comparator<ConstraintsMatch> COMPARATOR = new Comparator<ConstraintsMatch>(){

            @Override
            public int compare(ConstraintsMatch o1, ConstraintsMatch o2) {
                return o1.primary.compareTo(o2.primary);
            }
        };
        String primary;
        String secondary;
        String id;

        ConstraintsMatch(String primary, String secondary, String id) {
            this.primary = primary;
            this.secondary = secondary;
            this.id = id;
        }

        public ConstraintsMatch(String primary) {
            this(primary, null, primary);
        }

        public ConstraintsMatch(FecruUser user) {
            this(user.getDisplayName(), user.getUsername(), user.getUsername());
        }

        public String getPrimary() {
            return this.primary;
        }

        public String getSecondary() {
            return this.secondary;
        }

        public String getId() {
            return this.id;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.primary, this.secondary, this.id});
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!obj.getClass().equals(this.getClass())) {
                return false;
            }
            ConstraintsMatch that = (ConstraintsMatch)obj;
            return Objects.equal((Object)this.primary, (Object)that.primary) && Objects.equal((Object)this.secondary, (Object)that.secondary) && Objects.equal((Object)this.id, (Object)that.id);
        }

        public String toString() {
            return "ConstraintsMatch{primary='" + this.primary + '\'' + ", secondary='" + this.secondary + '\'' + ", id='" + this.id + '\'' + '}';
        }
    }
}

