/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.actions.create;

import com.atlassian.crucible.actions.AjaxResponse;
import com.atlassian.crucible.actions.ReviewBaseAction;
import com.atlassian.crucible.explorers.FileHistoryExplorer;
import com.atlassian.xwork.RequireSecurityToken;
import com.cenqua.crucible.model.CrucibleRevision;
import com.cenqua.crucible.revision.managers.ContentManager;
import com.cenqua.crucible.revision.source.Source;
import com.cenqua.crucible.view.RevInfoDO;
import com.cenqua.fisheye.Path;

public class LoadFullHistoryDropdownAjaxAction
extends ReviewBaseAction
implements AjaxResponse {
    private Integer latestRevId;
    private RevInfoDO revInfoDO;
    private String errorMsg = "";
    private boolean worked = true;

    public void setLatestRevId(Integer latestRevId) {
        this.latestRevId = latestRevId;
    }

    public Integer getLatestRevId() {
        return this.latestRevId;
    }

    @Override
    public String getErrorMsg() {
        return this.errorMsg;
    }

    @Override
    public boolean isWorked() {
        return this.worked;
    }

    public RevInfoDO getRevInfoDO() {
        return this.revInfoDO;
    }

    @RequireSecurityToken(value=false)
    public String execute() throws Exception {
        ContentManager contentManager = this.getContentManager();
        CrucibleRevision latestRevision = contentManager.getLazyCrucibleRevisionById(this.latestRevId);
        Path path = latestRevision.getFePath();
        Source source = this.sourceFactory.getSource(latestRevision.getSourceName(), this.getPrincipal());
        FileHistoryExplorer fhe = source.getFileHistoryExplorer(latestRevision.getRevInfoKey(), null);
        this.revInfoDO = new RevInfoDO(this.getReview(), source, path, this.latestRevId, fhe, contentManager);
        return "success";
    }
}

