/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.actions.create;

import com.atlassian.crucible.actions.jira.JiraBaseAjaxAction;
import com.atlassian.crucible.event.ReviewUpdatedEventImpl;
import com.atlassian.crucible.spi.data.ReviewData;
import com.atlassian.crucible.spi.impl.SPIUtils;
import com.atlassian.fisheye.jira.JiraIssue;
import com.cenqua.crucible.model.Review;
import com.cenqua.fisheye.logging.Logs;
import javax.annotation.Resource;

public class LinkReviewToJiraAjaxAction
extends JiraBaseAjaxAction {
    private JiraIssue issue;
    private String jiraIssueKey;
    private boolean autoLink = false;
    private boolean found = false;
    private boolean linked = false;
    private boolean unlinkJira = false;
    private boolean canLogWork;
    @Resource
    private SPIUtils spiUtils;

    public String getJiraIssueKey() {
        return this.jiraIssueKey;
    }

    public void setJiraIssueKey(String jiraIssueKey) {
        this.jiraIssueKey = jiraIssueKey;
    }

    public String getJiraIssueUrl() {
        return this.issue == null ? null : this.issue.getDisplayUrl();
    }

    public JiraIssue getIssue() {
        return this.issue;
    }

    public void setAutoLink(boolean autoLink) {
        this.autoLink = autoLink;
    }

    public boolean isFound() {
        return this.found;
    }

    public boolean isLinked() {
        return this.linked;
    }

    public boolean isUnlinkJira() {
        return this.unlinkJira;
    }

    public void setUnlinkJira(boolean unlinkJira) {
        this.unlinkJira = unlinkJira;
    }

    public String execute() throws Exception {
        if (this.unlinkJira) {
            return this.unlinkJiraKey();
        }
        return this.linkJiraKey();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String unlinkJiraKey() {
        Review review = this.getReview();
        try {
            this.beginTx();
            if (this.getCurrentUser() == null) {
                String string = "loginRequired";
                return string;
            }
            if (this.hasJiraLinkPermission()) {
                ReviewData oldReviewData = this.spiUtils.createReviewData(review);
                review.setJiraIssueKey(null);
                this.commitTx();
                this.eventPublisher.publish((Object)new ReviewUpdatedEventImpl(review.getPermId(), this.getCurrentUserData(), oldReviewData));
            } else {
                Logs.APP_LOG.warn((Object)String.format("User %s attempted to unlink review %s from a JIRA issue, but is not a reviewer on %s.", this.getCurrentUser().getUsername(), review.getPermaId(), review.getPermaId()));
            }
        }
        catch (Exception e2) {
            this.errorMsg = String.format("Error unlinking review %s from a JIRA issue: %s", review.getPermaId(), e2.getMessage());
            Logs.APP_LOG.warn((Object)this.errorMsg);
            this.worked = false;
            String string = "error";
            return string;
        }
        finally {
            this.rollbackTxIfNotCommited();
        }
        this.found = true;
        this.worked = true;
        return "success";
    }

    private String linkJiraKey() {
        try {
            this.beginTx();
            if (this.getCurrentUser() == null) {
                String string = "loginRequired";
                return string;
            }
            Review review = this.getReview();
            if (this.hasJiraLinkPermission()) {
                this.issue = this.getIssue(this.jiraIssueKey);
                if (this.issue == null) {
                    this.worked = !this.credentialsRequiredMessages.isEmpty();
                    String string = "remoteerror";
                    return string;
                }
                this.found = true;
                if (this.autoLink) {
                    ReviewData oldReviewData = this.spiUtils.createReviewData(review);
                    review.setJiraIssueKey(this.jiraIssueKey);
                    this.commitTx();
                    this.eventPublisher.publish((Object)new ReviewUpdatedEventImpl(review.getPermId(), this.getCurrentUserData(), oldReviewData));
                    this.linked = true;
                }
                this.canLogWork = this.issue.canLogWork();
            } else {
                String permaId = review.getPermaId();
                Logs.APP_LOG.warn((Object)String.format("User %s attempted to link review %s to Jira issue %s, but is not a reviewer on %s.", this.getCurrentUser().getUsername(), permaId, this.jiraIssueKey, permaId));
            }
        }
        finally {
            this.rollbackTxIfNotCommited();
        }
        this.worked = true;
        return "success";
    }

    public boolean isCanLogWork() {
        return this.canLogWork;
    }
}

