/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.actions.create;

import com.atlassian.crucible.actions.AjaxResponse;
import com.atlassian.crucible.actions.ReviewBaseAction;
import com.atlassian.crucible.spi.TxCallback;
import com.cenqua.crucible.model.PermaIdFormatException;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.managers.LogManager;
import com.cenqua.crucible.model.managers.ReviewMutableProperties;
import com.cenqua.crucible.model.managers.UserActionManager;
import org.springframework.transaction.TransactionStatus;

public class LinkReviewAction
extends ReviewBaseAction
implements AjaxResponse {
    private String parentReviewId;
    private String errorMsg;
    private boolean worked;
    private boolean unlinkParent;

    public void setParentReviewId(String parentReviewId) {
        this.parentReviewId = parentReviewId;
    }

    public String execute() throws Exception {
        if (this.getReview().getState().isClosedMetaState()) {
            this.errorMsg = "Cannot edit details of a closed review.";
            this.worked = false;
            return "ajaxError";
        }
        if (!this.isFileModifiable()) {
            UserActionManager userActionManager = UserActionManager.getInstance();
            this.errorMsg = userActionManager.getAction(UserActionManager.ACTION_MOD_FILES).getPermissionViolationMsg();
            this.worked = false;
            return "ajaxError";
        }
        return this.txTemplate.execute(new TxCallback<String>(){

            @Override
            public String doInTransaction(TransactionStatus status) {
                try {
                    if (!(LinkReviewAction.this.worked = LinkReviewAction.this.linkReview())) {
                        return "ajaxError";
                    }
                }
                catch (PermaIdFormatException e2) {
                    LinkReviewAction.this.errorMsg = "Review Id " + LinkReviewAction.this.parentReviewId + " is invalid";
                    LinkReviewAction.this.worked = false;
                    return "ajaxError";
                }
                return "success";
            }
        });
    }

    private boolean linkReview() throws PermaIdFormatException {
        if (this.unlinkParent) {
            this.getReview().setParentReview(null);
        } else {
            Review parent = this.reviewManager.getReviewByPermaId(this.parentReviewId);
            if (parent != null) {
                this.errorMsg = this.checkParentValid(this.getReview(), parent);
                if (this.errorMsg != null) {
                    return false;
                }
                LogManager.logReviewPropertyChanged(ReviewMutableProperties.PARENT_REVIEW, this.getReview(), this.getCurrentUser(), this.getReview().getParentReview() != null ? this.getReview().getParentReview().getPermaId() : null, this.parentReviewId);
                this.getReview().setParentReview(parent);
            } else {
                this.errorMsg = "review " + this.parentReviewId + " doesn't exist";
                return false;
            }
        }
        return true;
    }

    private String checkParentValid(Review child, Review parent) {
        if (child.getId().equals(parent.getId())) {
            return "Cannot link a review to itself.";
        }
        if (parent.isDescendantOf(child)) {
            return parent.getPermaId() + " is a child of " + child.getPermaId() + " and so cannot be set as a parent.";
        }
        return null;
    }

    @Override
    public String getErrorMsg() {
        return this.errorMsg;
    }

    @Override
    public boolean isWorked() {
        return this.worked;
    }

    public void setUnlinkParent(boolean unlinkParent) {
        this.unlinkParent = unlinkParent;
    }
}

