/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.actions.create;

import com.atlassian.crucible.actions.ReviewBaseAction;
import com.atlassian.fecru.user.FecruUser;
import com.atlassian.xwork.RequireSecurityToken;
import com.cenqua.crucible.model.managers.LogManager;
import com.cenqua.crucible.model.managers.ReviewManager;
import com.cenqua.crucible.notification.NotificationManager;
import com.cenqua.crucible.tags.ReviewUtil;
import java.util.Set;
import javax.annotation.Resource;

public class JoinReviewAction
extends ReviewBaseAction {
    @Resource(name="notificationManager")
    private NotificationManager notificationManager;
    @Resource
    private ReviewManager reviewManager;

    public String getContextPath() {
        return this.getRequest().getContextPath();
    }

    public void setNotificationManager(NotificationManager notificationManager) {
        this.notificationManager = notificationManager;
    }

    @RequireSecurityToken(value=false)
    public String execute() throws Exception {
        try {
            this.beginTx();
            if (this.getCurrentUser() == null) {
                this.commitTx();
                String string = "loginRequired";
                return string;
            }
            if (!ReviewUtil.isShowJoinReview(this.getReview(), this.getCurrentUser())) {
                this.commitTx();
                this.addActionError("Authorization error, contact " + this.getReview().getModeratorEquivUser().getDisplayName() + " to join this review.");
                String string = "error";
                return string;
            }
            Set<FecruUser> reviewers = this.getReview().getActiveReviewers();
            if (!reviewers.contains(this.getCurrentUser())) {
                this.reviewManager.addReviewer(this.getReview(), this.getCurrentUser());
                LogManager.logReviewReviewerAdd(this.getReview(), this.getCurrentUser(), this.getCurrentUser(), this.getReview().getState().isReviewState());
                if (this.getReview().getState().isReviewState()) {
                    this.notificationManager.noteGeneralMsg(this.getReview(), this.getCurrentUser(), this.getCurrentUser(), "You have been added as a reviewer in review " + this.getPermaId());
                }
            }
            this.commitTx();
            String string = "success";
            return string;
        }
        finally {
            this.rollbackTxIfNotCommited();
        }
    }
}

