/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.actions.create;

import com.atlassian.crucible.actions.ReviewBaseAction;
import com.atlassian.xwork.RequireSecurityToken;
import com.cenqua.crucible.model.Patch;
import com.cenqua.crucible.view.PatchListDO;
import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.List;

public class IterablePatchesAjaxAction
extends ReviewBaseAction {
    private Integer patchId;
    private PatchListDO result;

    public PatchListDO getResult() {
        if (this.result == null) {
            final Patch patchToAdd = this.patchManager.getPatchById(this.patchId);
            if (!patchToAdd.isAnchored()) {
                this.result = new PatchListDO(Collections.emptyList(), this.effectiveUserProvider.getEffectivePrincipal(), this.sourceFactory);
            }
            final String anchorSource = patchToAdd.getAnchorSource();
            ImmutableList applicablePatches = ImmutableList.copyOf((Iterable)Iterables.filter(this.getPatches(), (Predicate)new Predicate<Patch>(){

                public boolean apply(Patch patch) {
                    return patch.isAvailableForAdding() && patch.isAnchored() && !Objects.equal((Object)patch.getId(), (Object)patchToAdd.getId()) && anchorSource.equals(patch.getAnchorSource());
                }
            }));
            this.result = new PatchListDO((List<Patch>)applicablePatches, this.effectiveUserProvider.getEffectivePrincipal(), this.sourceFactory);
        }
        return this.result;
    }

    @RequireSecurityToken(value=false)
    public String execute() throws Exception {
        return super.execute();
    }

    public boolean isFound() {
        return !this.getResult().getAll().isEmpty();
    }

    public Integer getPatchId() {
        return this.patchId;
    }

    public void setPatchId(Integer patchId) {
        this.patchId = patchId;
    }
}

