/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.actions.create;

import com.atlassian.crucible.actions.create.EditRevisionsAction;
import com.atlassian.crucible.spi.services.ChangeSetContentTooLargeException;
import com.atlassian.crucible.spi.services.ContentTooLargeException;
import com.atlassian.fecru.review.ReviewLockManager;
import com.atlassian.xwork.RequireSecurityToken;
import com.cenqua.crucible.CrucibleSysProps;
import com.cenqua.crucible.model.CrucibleRevision;
import com.cenqua.crucible.model.managers.LogManager;
import com.cenqua.crucible.revision.source.RepositorySource;
import com.cenqua.crucible.revision.source.Source;
import com.cenqua.crucible.revision.source.SourceException;
import com.cenqua.crucible.util.ReviewCreationHelper;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.search.SearchManager;
import com.cenqua.fisheye.search.SearchResults;
import com.cenqua.fisheye.search.SimpleSearchParameters;
import com.cenqua.fisheye.search.query.FishQuery;
import com.cenqua.fisheye.web.SearchResultsExplorer;
import com.cenqua.fisheye.web.UrlHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.Callable;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;

public class EditSearchAction
extends EditRevisionsAction {
    @Autowired
    private ReviewLockManager reviewLockManager;
    private String search;

    public String getSearch() {
        return this.search;
    }

    public void setSearch(String search) {
        this.search = search;
    }

    @Override
    public String getEditMode() {
        return "search";
    }

    @Override
    protected String doView() {
        String result = super.doView();
        if ("successRedirect".equals(result)) {
            return result;
        }
        Source s2 = this.getSource();
        if (!(s2 instanceof RepositorySource)) {
            return result;
        }
        if (!this.isRepositoryAvailable()) {
            return result;
        }
        Path lpath = this.getPathInfo().getLocalPath();
        HttpServletRequest req = this.getRequest();
        req.setAttribute("repname", (Object)s2.getName());
        try {
            if (s2.isFile(lpath)) {
                lpath = lpath.getParent();
            }
            if (!s2.isDir(lpath)) {
                lpath = Path.ROOT;
            }
            this.doSearch(lpath, req);
        }
        catch (Exception e2) {
            this.addActionError(e2.getMessage());
        }
        return result;
    }

    @Override
    @RequireSecurityToken(value=false)
    public String execute() throws Exception {
        Source s2 = this.getSource();
        if (s2 == null) {
            this.addActionError("No repository has been selected.");
        }
        return this.doView();
    }

    public String doAddSearch() throws Exception {
        final Source s2 = this.getSource();
        if (s2 == null) {
            this.addActionError("No repository has been selected.");
        } else if (s2.isSearchCapable()) {
            try {
                this.reviewLockManager.withReviewLock(this.getReview(), new Callable<Void>(){

                    @Override
                    public Void call() throws SourceException {
                        EditSearchAction.this.beginTx();
                        EditSearchAction.this.getReview().checkRoomForMoreContentExists();
                        LogManager.logReviewSearchAdded(EditSearchAction.this.getReview(), EditSearchAction.this.getCurrentUser(), EditSearchAction.this.search);
                        Collection revs = EditSearchAction.this.searchForRevisions(EditSearchAction.this.search);
                        ReviewCreationHelper reviewCreationHelper = EditSearchAction.this.getCreateHelper();
                        if (reviewCreationHelper != null) {
                            reviewCreationHelper.addRevisions(EditSearchAction.this.getCurrentUser(), revs, EditSearchAction.this.attachMethod, EditSearchAction.this.fromRevision, ReviewCreationHelper.MetadataFilter.NONE);
                        } else {
                            EditSearchAction.this.addActionError("The repository " + s2.getName() + " is not available. The revisions could not be added to the review.");
                        }
                        EditSearchAction.this.commitTx();
                        return null;
                    }
                });
            }
            catch (ContentTooLargeException e2) {
                this.commitTx();
                this.addActionErrorHtml(e2.getMessageHtml());
                Logs.APP_LOG.debug((Object)"", (Throwable)e2);
            }
            finally {
                this.rollbackTxIfNotCommited();
            }
        }
        return this.doView();
    }

    private void doSearch(Path path, HttpServletRequest req) throws DbException {
        FishQuery query;
        ArrayList<String> errors = new ArrayList<String>(1);
        req.setAttribute("errors", errors);
        if (!this.isRepositoryAvailable()) {
            Logs.APP_LOG.warn((Object)("error doing search: Repository not available. " + this.getSource().getReason()));
            errors.add("Repository not available");
            errors.add(this.getSource().getReason());
            return;
        }
        Path searchPath = path;
        String searchAllDirsStr = req.getParameter("searchAllDirs");
        if (searchAllDirsStr != null && "true".equals(searchAllDirsStr)) {
            searchPath = Path.ROOT;
        }
        String ql = req.getParameter("ql");
        UrlHelper searchUrl = new UrlHelper();
        searchUrl.setUrl(String.format("%s/cru/%s/edit-search/%s/%s", req.getContextPath(), this.getReview().getPermaId(), this.getSource().getName(), path.getPath()));
        if (ql != null) {
            req.setAttribute("qlStr", (Object)ql);
            req.setAttribute("isAdvanced", (Object)"true");
            searchUrl.getParams().put("ql", ql);
            query = ql.trim().length() > 0 ? FishQuery.parse(ql, errors) : null;
        } else {
            SimpleSearchParameters params = new SimpleSearchParameters(req);
            query = params.parseUserData(searchPath, searchUrl);
            if (query != null) {
                req.setAttribute("qlStr", (Object)query.makeQueryString());
            }
        }
        if (query != null) {
            if (query.getFromPath() == null) {
                query.setFromPath(searchPath);
            }
            try {
                SearchManager searcher = this.getSource().getSearchManager();
                boolean refresh = req.getParameter("refresh") != null;
                SearchResults collator = searcher.runQuery(query, refresh);
                SearchResultsExplorer results = new SearchResultsExplorer(collator);
                results.init(req, searchUrl);
                req.setAttribute("results", (Object)results);
            }
            catch (Exception e2) {
                Logs.APP_LOG.warn((Object)"error doing search", (Throwable)e2);
                errors.add("General search term error:" + e2.getMessage());
            }
        }
        req.setAttribute("path", (Object)path);
        req.setAttribute("fpath", (Object)new Path(new Path(this.getSource().getName()), path.getPath()));
        req.setAttribute("authors", this.getSource().findAuthors(path));
    }

    private Collection<CrucibleRevision> searchForRevisions(String eyeQL) throws ChangeSetContentTooLargeException {
        SearchManager searcher = this.getSource().getSearchManager();
        ArrayList<String> errors = new ArrayList<String>();
        FishQuery query = FishQuery.parse(eyeQL, errors);
        if (!errors.isEmpty()) {
            for (String error : errors) {
                this.addActionError(error);
            }
            return Collections.emptyList();
        }
        try {
            SearchResults results = searcher.runQuery(query, false);
            int limit = CrucibleSysProps.REVIEW_CONTENT_SIZE_LIMIT;
            if (results.size() > limit) {
                throw new ChangeSetContentTooLargeException(limit);
            }
            ArrayList<CrucibleRevision> revisions = new ArrayList<CrucibleRevision>(results.size());
            SearchResults.RevisionResultsIterator it = results.iterateRevisions(0);
            while (it.hasNext()) {
                FileRevision dfr = (FileRevision)it.next();
                CrucibleRevision rev = this.contentManager.getCrucibleRevision(this.getSource(), dfr.getPath().getPath(), dfr.getRevision());
                if (rev != null) {
                    revisions.add(rev);
                    continue;
                }
                this.addActionError("Couldn't find revision " + dfr.getPath().getPath() + " " + dfr.getRevision() + " in " + this.getSource().getDisplayName());
            }
            return revisions;
        }
        catch (ChangeSetContentTooLargeException e2) {
            throw e2;
        }
        catch (Exception e3) {
            this.addActionError("Error executing search '" + eyeQL + "': " + e3);
            return Collections.emptyList();
        }
    }
}

