/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.actions.create;

import com.atlassian.crucible.actions.AjaxResponse;
import com.atlassian.crucible.actions.ViewFRXAction;
import com.atlassian.crucible.explorers.ChangeSetPair;
import com.atlassian.crucible.explorers.CrucibleChangeSet;
import com.atlassian.crucible.explorers.CrucibleChangeSetsHelper;
import com.atlassian.crucible.spi.PermId;
import com.atlassian.crucible.spi.services.ChangeSetContentTooLargeException;
import com.atlassian.crucible.spi.services.ContentTooLargeException;
import com.atlassian.crucible.spi.services.ReviewContentTooLargeException;
import com.atlassian.crucible.spi.services.ReviewService;
import com.atlassian.fecru.review.ReviewLockManager;
import com.atlassian.fisheye.spi.TxTemplate;
import com.cenqua.crucible.model.CrucibleRevision;
import com.cenqua.crucible.model.FRXRevision;
import com.cenqua.crucible.model.FileRevisionExtraInfo;
import com.cenqua.crucible.model.Patch;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.managers.FRXManager;
import com.cenqua.crucible.model.managers.FRXRevisionManager;
import com.cenqua.crucible.model.managers.FileRevisionManager;
import com.cenqua.crucible.model.managers.LogManager;
import com.cenqua.crucible.model.managers.PatchManager;
import com.cenqua.crucible.model.managers.UserActionManager;
import com.cenqua.crucible.revision.ChangesetReviewState;
import com.cenqua.crucible.revision.managers.ContentManager;
import com.cenqua.crucible.revision.source.PatchSource;
import com.cenqua.crucible.revision.source.Source;
import com.cenqua.crucible.revision.source.SourceException;
import com.cenqua.crucible.tags.ReviewUtil;
import com.cenqua.crucible.util.PatchReviewCreationHelper;
import com.cenqua.crucible.util.ReviewCreationHelper;
import com.cenqua.crucible.view.FRXDO;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.DbException;
import com.google.common.base.Strings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.hibernate.exception.GenericJDBCException;
import org.springframework.beans.factory.annotation.Autowired;

public class EditRevisionsAjaxAction
extends ViewFRXAction
implements AjaxResponse {
    public static final String COMMAND_ADD = "add";
    public static final String COMMAND_REMOVE_REVISIONS = "removeRevisions";
    public static final String COMMAND_REMOVE = "remove";
    public static final String COMMAND_REMOVE_ALL = "removeAll";
    private ReviewCreationHelper createHelper;
    private String command;
    private String sourceName;
    private CrucibleRevision[] crucibleRevisions;
    private String errorMsg = "";
    private boolean worked = true;
    private boolean noEscape = false;
    private List<CrucibleRevision> addedItems;
    private List<CrucibleRevision> removedItems;
    private List<CrucibleRevision> unremovedItems;
    private List<String> messages;
    private Review.AttachMethod attachMethod;
    private String fromRevision;
    private Integer frxId;
    private FileRevisionExtraInfo frx;
    private FRXDO frxDO;
    private String csid;
    private boolean operationPerformed = false;
    private boolean reloadReview = false;
    @Resource
    private ContentManager contentManager;
    @Resource
    private PatchManager patchManager;
    @Autowired
    private CrucibleChangeSetsHelper crucibleChangeSetsHelper;
    @Autowired
    private ReviewService reviewService;
    @Autowired
    private ReviewLockManager reviewLockManager;
    @Autowired
    private TxTemplate txTemplate;

    public Integer getFrxId() {
        return this.frxId;
    }

    private FileRevisionExtraInfo getFrx() {
        if (this.frx == null) {
            this.frx = FRXManager.getById(this.frxId);
        }
        return this.frx;
    }

    private void resetFrx() {
        this.frx = FRXManager.getById(this.frxId);
    }

    @Override
    public FRXDO getFrxDO() {
        if (this.frxDO == null && this.getFrx() != null) {
            this.frxDO = this.makeFRXDO(this.getFrx(), true);
            if (this.frxDO != null) {
                FRXRevision from;
                FRXRevisionManager frxRevisionManager = new FRXRevisionManager();
                FRXRevision fRXRevision = from = this.getFromRev() == null ? null : frxRevisionManager.getById(this.getFromRev());
                if (from != null) {
                    this.frxDO.setFromFrxRevision(from);
                    this.frxDO.resetDiff();
                }
                if (this.isShowAnnotation()) {
                    this.frxDO.setFromFrxRevision(null);
                }
                this.frxDO.setDiffContext(this.getU());
                this.frxDO.setIgnore_BL(this.isIgnore_BL());
                this.frxDO.setIgnore_b(this.isIgnore_b());
                this.frxDO.setIgnore_w(this.isIgnore_w());
            }
        }
        return this.frxDO;
    }

    public void setFrxId(Integer frxId) {
        this.frxId = frxId;
    }

    public String getAttachMethod() {
        return this.attachMethod.name();
    }

    public void setAttachMethod(String attachMethod) {
        this.attachMethod = Review.AttachMethod.valueOf(attachMethod);
    }

    public String getFromRevision() {
        return this.fromRevision;
    }

    public void setFromRevision(String fromRevision) {
        this.fromRevision = fromRevision;
    }

    private ReviewCreationHelper getCreateHelper() throws SourceException {
        if (this.createHelper == null) {
            Source s2 = this.createSource();
            this.createHelper = s2.createReviewCreationHelper(this.getReview());
        }
        return this.createHelper;
    }

    private Source createSource() {
        return this.sourceFactory.getSource(this.sourceName, this.effectiveUserProvider.getEffectivePrincipal());
    }

    private void setErrorMessage(String msg) {
        this.errorMsg = msg;
        this.worked = false;
    }

    @Override
    public String getErrorMsg() {
        return this.errorMsg;
    }

    @Override
    public boolean isWorked() {
        return this.worked;
    }

    public boolean isNoEscape() {
        return this.noEscape;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public void setCsid(String csid) {
        this.csid = csid;
    }

    public void setSourceName(String sourceName) {
        this.sourceName = sourceName;
    }

    public void setRevid(int[] revids) {
        this.crucibleRevisions = new CrucibleRevision[revids.length];
        int i2 = 0;
        for (int id : revids) {
            CrucibleRevision cruRev = FileRevisionManager.getById(id);
            if (i2 != 0 && !this.sourceName.equals(cruRev.getSourceName())) {
                throw new IllegalArgumentException("EditRevisionsAjaxAction cannot be used with revisions from different sources - " + this.sourceName + " vs " + cruRev.getSourceName());
            }
            this.sourceName = cruRev.getSourceName();
            this.crucibleRevisions[i2++] = cruRev;
        }
    }

    public List<CrucibleRevision> getAddedItems() {
        return this.addedItems;
    }

    public List<CrucibleRevision> getRemovedItems() {
        return this.removedItems;
    }

    public List<String> getMessages() {
        return this.messages;
    }

    @Override
    public String execute() {
        return this.reviewLockManager.withReviewLock(this.getReview(), () -> {
            if (this.getReview().getState().isClosedMetaState()) {
                this.setErrorMessage("Cannot edit revisions of a closed review.");
                return "error";
            }
            if (!this.isFileModifiable()) {
                UserActionManager userActionManager = UserActionManager.getInstance();
                this.setErrorMessage(userActionManager.getAction(UserActionManager.ACTION_MOD_FILES).getPermissionViolationMsg());
                return "error";
            }
            return this.txTemplate.execute(status -> {
                try {
                    if (this.getFrx() != null && (this.getFrx().getFrxRevisions() == null || this.getFrx().getFrxRevisions().size() == 0)) {
                        String errorMsg = "Cannot find any revisions in file with id \"" + this.frxId + "\"";
                        this.setErrorMessage(errorMsg);
                        Logs.APP_LOG.warn((Object)errorMsg);
                        return "error";
                    }
                    if (this.command == null) {
                        this.setErrorMessage("No revision was added or removed.");
                        return "error";
                    }
                    if (Strings.isNullOrEmpty((String)this.sourceName)) {
                        Logs.APP_LOG.info((Object)"no repository specified in request");
                        this.setErrorMessage("No revision was added or removed.");
                        return "error";
                    }
                    if (this.csid != null) {
                        boolean checkSize = this.command.equals(COMMAND_ADD);
                        this.crucibleRevisions = this.computeRevisions(this.sourceName, this.csid, checkSize);
                    }
                    if (this.attachMethod == Review.AttachMethod.DIFF_TO_PREVIOUS) {
                        this.attachMethod = Review.AttachMethod.ITERATION;
                    }
                    this.addedItems = new ArrayList<CrucibleRevision>();
                    this.removedItems = new ArrayList<CrucibleRevision>();
                    this.unremovedItems = new ArrayList<CrucibleRevision>();
                    this.messages = new ArrayList<String>();
                    ReviewCreationHelper ch = this.getCreateHelper();
                    if (this.sourceName.startsWith("PATCH:")) {
                        this.addRemovePatchRev(ch);
                    } else {
                        this.addRemoveRepoRev(ch, Strings.isNullOrEmpty((String)this.csid) ? ReviewCreationHelper.MetadataFilter.NONE : ReviewCreationHelper.MetadataFilter.ALL_AND_FAIL);
                    }
                    this.resetFrx();
                    if (this.hasOperationError()) {
                        for (String message : this.messages) {
                            this.setErrorMessage(this.getErrorMsg() + (!Strings.isNullOrEmpty((String)this.getErrorMsg()) ? Character.valueOf('\n') : "") + message);
                        }
                        return "input";
                    }
                    this.reloadReview = this.getFrx() != null && !this.getFrx().getCrucibleRevisions().containsAll(this.addedItems);
                    return "success";
                }
                catch (SourceException e2) {
                    status.setRollbackOnly();
                    this.setErrorMessage("No revision was added or removed. " + e2.getMessage());
                    Logs.APP_LOG.debug((Object)"Error adding/removing revisions:", (Throwable)e2);
                    return "error";
                }
                catch (GenericJDBCException e3) {
                    status.setRollbackOnly();
                    this.setErrorMessage("No revision was added or removed. " + e3.getMessage());
                    Logs.APP_LOG.debug((Object)"Error adding/removing revisions:", (Throwable)e3);
                    return "error";
                }
                catch (ContentTooLargeException e4) {
                    status.setRollbackOnly();
                    this.setErrorMessage(e4.getMessageHtml());
                    this.noEscape = true;
                    Logs.APP_LOG.debug((Object)"", (Throwable)e4);
                    return "input";
                }
            });
        });
    }

    private boolean hasOperationError() {
        return this.operationPerformed && this.addedItems.isEmpty() && this.removedItems.isEmpty();
    }

    private CrucibleRevision[] computeRevisions(String sourceName, String csid, boolean checkSize) throws DbException, SourceException, ChangeSetContentTooLargeException {
        List<CrucibleChangeSet> changeSets;
        this.crucibleChangeSetsHelper.clear();
        this.crucibleChangeSetsHelper.addCrucibleChangeSet(ChangeSetPair.newInstance(sourceName, csid));
        boolean failOnNoExistent = false;
        if (checkSize) {
            this.crucibleChangeSetsHelper.checkSize();
            changeSets = this.crucibleChangeSetsHelper.createChangeSets(false);
        } else {
            changeSets = this.crucibleChangeSetsHelper.createChangeSetsNoSizeCheck(false);
        }
        if (null != changeSets && !changeSets.isEmpty()) {
            if (changeSets.size() != 1) {
                Logs.APP_LOG.warn((Object)("Exactly one changeset expected for a single csid, but more found? csid:" + csid + ", #=" + changeSets.size()));
            }
            CrucibleChangeSet ccs = changeSets.get(0);
            List<CrucibleRevision> revs = ccs.getRevisions();
            return revs.toArray(new CrucibleRevision[revs.size()]);
        }
        return new CrucibleRevision[0];
    }

    private List<CrucibleRevision> getRevisions() {
        if (this.crucibleRevisions != null && this.crucibleRevisions.length > 0) {
            return Arrays.asList(this.crucibleRevisions);
        }
        return new ArrayList<CrucibleRevision>();
    }

    private void addRemoveRepoRev(ReviewCreationHelper ch, ReviewCreationHelper.MetadataFilter metadataFilter) throws SourceException, ReviewContentTooLargeException {
        switch (this.command) {
            case "add": {
                this.tryAddRevisions(ch, metadataFilter);
                break;
            }
            case "remove": {
                if (this.frxId != null) {
                    this.tryRemoveFrx(ch);
                    break;
                }
                this.tryRemoveRevisions(ch);
                break;
            }
            case "removeRevisions": {
                this.tryRemoveRevisions(ch);
                break;
            }
            case "removeAll": {
                this.tryRemoveAllRevisions(ch);
                break;
            }
            default: {
                Logs.APP_LOG.debug((Object)("unknown command '" + this.command + "'"));
            }
        }
        this.setOperationResults(ch);
    }

    public ChangesetReviewState getCsReviewState() {
        if (this.command.equals(COMMAND_ADD) && !this.hasOperationError()) {
            return ChangesetReviewState.FULL;
        }
        if ((this.command.equals(COMMAND_REMOVE) || this.command.equals(COMMAND_REMOVE_REVISIONS)) && !this.hasOperationError()) {
            if (this.unremovedItems.isEmpty()) {
                return ChangesetReviewState.NONE;
            }
            if (this.unremovedItems.size() != this.crucibleRevisions.length) {
                return ChangesetReviewState.PARTIAL;
            }
        }
        return null;
    }

    private void tryRemoveAllRevisions(ReviewCreationHelper ch) {
        if (this.getReview().getFrxs() != null && !this.getReview().getFrxs().isEmpty()) {
            this.operationPerformed = true;
            ch.removeAllRevisions(this.getCurrentUser());
        }
    }

    private void tryRemoveFrx(ReviewCreationHelper ch) {
        if (this.getFrx() != null) {
            this.operationPerformed = true;
            ch.removeFrx(this.getCurrentUser(), this.frxId);
        }
    }

    private void tryRemoveRevisions(ReviewCreationHelper ch) {
        ArrayList<CrucibleRevision> toRemove = new ArrayList<CrucibleRevision>();
        List<CrucibleRevision> existing = this.getReview().getRevisions();
        for (CrucibleRevision cruRevToRemove : this.getRevisions()) {
            if (!existing.contains(cruRevToRemove)) continue;
            toRemove.add(cruRevToRemove);
        }
        if (!toRemove.isEmpty()) {
            this.operationPerformed = true;
            ch.removeRevisions(this.getCurrentUser(), toRemove, !Strings.isNullOrEmpty((String)this.csid));
        }
    }

    private void tryAddRevisions(ReviewCreationHelper ch, ReviewCreationHelper.MetadataFilter metadataFilter) throws SourceException, ReviewContentTooLargeException {
        this.getReview().checkRoomForMoreContentExists();
        ArrayList<CrucibleRevision> revisionsToAdd = new ArrayList<CrucibleRevision>();
        Source s2 = this.createSource();
        for (CrucibleRevision revision : this.getRevisions()) {
            this.contentManager.checkRevisionDetailsSynchronously(revision, this.createSource());
            revisionsToAdd.add(this.contentManager.getCrucibleRevision(s2, revision.getRevInfoKey()));
        }
        if (!revisionsToAdd.isEmpty()) {
            this.operationPerformed = true;
            if (Strings.isNullOrEmpty((String)this.getReview().getName())) {
                this.setReviewName(((CrucibleRevision)revisionsToAdd.get(0)).getCommitMessage());
            }
            ch.addRevisions(this.getCurrentUser(), revisionsToAdd, this.attachMethod, this.fromRevision, metadataFilter);
        }
        if (ch.getAddedItems().isEmpty()) {
            this.operationPerformed = false;
        }
    }

    private void setReviewName(String name) {
        Review review = this.getReview();
        review.setName(ReviewUtil.extractReviewTitle(name));
        this.reviewService.tryAutomaticJiraLinking(new PermId(review.getPermaId()));
    }

    private void setOperationResults(ReviewCreationHelper ch) {
        this.addedItems.addAll(ch.getAddedItems());
        this.removedItems.addAll(ch.getRemovedItems());
        this.unremovedItems.addAll(ch.getUnremovedItems());
        this.messages.addAll(ch.getMessages());
    }

    private void addRemovePatchRev(ReviewCreationHelper ch) throws IOException, SourceException {
        boolean add = this.command.equals(COMMAND_ADD);
        if (add && Strings.isNullOrEmpty((String)this.getReview().getName()) && this.crucibleRevisions.length != 0) {
            CrucibleRevision fr = this.crucibleRevisions[0];
            Patch p2 = this.patchManager.findPatch(fr);
            this.setReviewName(p2.getUploadItem().getOriginalName());
        }
        for (CrucibleRevision revision : this.crucibleRevisions) {
            boolean removeRevisions;
            FileRevisionExtraInfo frx;
            if (add) {
                frx = PatchReviewCreationHelper.addPatchRevisionToReview(revision, this.getReview());
                if (frx == null) {
                    String noFrxMsg = String.format("Can't find file revision with id %s to add", revision);
                    Logs.APP_LOG.warn((Object)noFrxMsg);
                    this.messages.add(noFrxMsg);
                } else {
                    LogManager.logReviewFrxAdded(this.getReview(), this.getCurrentUser(), frx);
                    this.addedItems.add(revision);
                }
                this.operationPerformed = true;
                continue;
            }
            if (this.frxId != null) {
                frx = this.getFrx();
            } else {
                List<FileRevisionExtraInfo> frxs = FRXManager.getFRExtraInfos(revision);
                FileRevisionExtraInfo fileRevisionExtraInfo = frx = frxs.size() == 1 ? frxs.get(0) : null;
            }
            if (frx == null) {
                this.operationPerformed = true;
                String noFrxMsg = String.format("Can't find file revision with id %s to remove", revision);
                Logs.APP_LOG.warn((Object)noFrxMsg);
                this.messages.add(noFrxMsg);
                continue;
            }
            boolean bl = removeRevisions = this.command.equals(COMMAND_REMOVE_REVISIONS) || this.frxId == null;
            if (removeRevisions) {
                this.operationPerformed = true;
                try {
                    this.patchManager.removePatchRevision((PatchSource)this.createSource(), frx, revision);
                    this.removedItems.add(revision);
                }
                catch (IllegalStateException e2) {
                    this.messages.add(e2.getMessage());
                }
                continue;
            }
            if (!this.command.equals(COMMAND_REMOVE)) continue;
            this.operationPerformed = true;
            ch.removeFrx(this.getCurrentUser(), frx.getId());
        }
        if (this.operationPerformed) {
            this.setOperationResults(ch);
        }
    }

    public Collection getActionMessages() {
        ArrayList<String> messages = new ArrayList<String>();
        if (this.addedItems.size() == 1) {
            messages.add("Added " + this.addedItems.get(0).getFePath().getName() + ".");
        } else if (this.addedItems.size() > 1) {
            messages.add("Added " + this.addedItems.size() + " revisions.");
        }
        if (this.removedItems.size() == 1) {
            messages.add("Removed " + this.removedItems.get(0).getFePath().getName() + ".");
        } else if (this.removedItems.size() > 1) {
            messages.add("Removed " + this.removedItems.size() + " revisions.");
        }
        return messages;
    }

    public boolean getHasErrors() {
        return !this.getActionErrors().isEmpty();
    }

    @Override
    public boolean isReloadReview() {
        return this.reloadReview;
    }
}

