/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.actions.create;

import com.atlassian.crucible.actions.ConstraintExplorer;
import com.atlassian.crucible.actions.PathInfoBaseAction;
import com.atlassian.crucible.actions.StoreStickyPreferenceAjaxAction;
import com.atlassian.crucible.actions.create.RepoNameSelectHelper;
import com.atlassian.crucible.filters.CrucibleFilter;
import com.atlassian.crucible.spi.impl.SPIUtils;
import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fisheye.scm.CruciblePathInfo;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.notification.NotificationManager;
import com.cenqua.crucible.revision.managers.ContentManager;
import com.cenqua.crucible.revision.source.RepositorySource;
import com.cenqua.crucible.revision.source.Source;
import com.cenqua.crucible.revision.source.SourceException;
import com.cenqua.crucible.util.ReviewCreationHelper;
import com.cenqua.crucible.util.SourceUtils;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.config.RepositoryManager;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.model.CommitterDisplayDetails;
import com.cenqua.fisheye.model.manager.CommitterUserMappingManager;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.web.WaybackSpec;
import com.google.common.base.Strings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class EditRevisionsAction
extends PathInfoBaseAction
implements ConstraintExplorer {
    protected List<String> actionErrorsHtml = new ArrayList<String>();
    protected static final String SUCCESS_REDIRECT = "successRedirect";
    protected WaybackSpec wbSpec;
    private ReviewCreationHelper createHelper;
    protected String command;
    private String repoName;
    private Source source;
    protected Review.AttachMethod attachMethod;
    protected String fromRevision;
    @Resource
    protected ContentManager contentManager;
    @Autowired
    protected HttpServletRequest request;
    @Resource
    private NotificationManager notificationManager;
    @Resource
    private RepositoryManager repositoryManager;
    @Resource
    private SPIUtils spiUtils;
    @Resource
    protected CommitterUserMappingManager committerMappingManager;

    public List<String> getActionErrorsHtml() {
        return this.actionErrorsHtml;
    }

    public void addActionErrorHtml(String error) {
        this.actionErrorsHtml.add(error);
    }

    public String getErrorDescription() {
        return "error.unauthorized.change.description";
    }

    public String getError() {
        return "error.unauthorized.action";
    }

    public Review.AttachMethod getAttachMethod() {
        if (this.attachMethod != null) {
            return this.attachMethod;
        }
        Map stickyMap = (Map)this.request.getSession().getAttribute(StoreStickyPreferenceAjaxAction.SESSION_KEY);
        return stickyMap == null ? null : Review.AttachMethod.valueOf((String)stickyMap.get("attachMethod"));
    }

    public void setAttachMethod(String attachMethod) {
        this.attachMethod = Review.AttachMethod.valueOf(attachMethod);
    }

    public String getFromRevision() {
        if (this.fromRevision != null) {
            return this.fromRevision;
        }
        Map stickyMap = (Map)this.request.getSession().getAttribute(StoreStickyPreferenceAjaxAction.SESSION_KEY);
        return stickyMap == null ? null : (String)stickyMap.get("specificDiff");
    }

    public void setFromRevision(String fromRevision) {
        this.fromRevision = fromRevision;
    }

    protected ReviewCreationHelper getCreateHelper() {
        if (this.createHelper == null && this.getSource().isAvailable()) {
            try {
                this.createHelper = new ReviewCreationHelper(this.getSource(), this.getReview(), this.contentManager, this.notificationManager, this.spiUtils, this.commentManager, this.eventPublisher);
            }
            catch (SourceException e2) {
                Logs.APP_LOG.warn((Object)"Source Exception", (Throwable)e2);
            }
        }
        return this.createHelper;
    }

    public abstract String getEditMode();

    public void setCommand(String command) {
        this.command = command;
    }

    public String getCommand() {
        return this.command;
    }

    public void setRepoName(String repoName) {
        this.repoName = RepoNameSelectHelper.convertSentinelToNull(repoName);
    }

    @Override
    public WaybackSpec getWbSpec() {
        return this.wbSpec;
    }

    @Override
    public String getRepoName() {
        return RepoNameSelectHelper.convertNullToSentinel(this.repoName);
    }

    public boolean isRepositoryPipelined() {
        RepositoryHandle handle;
        String repoName = this.getRepoName();
        if (StringUtils.isNotBlank((String)repoName) && (handle = this.repositoryManager.getRepository(repoName)) != null) {
            return handle.isPipelined();
        }
        return false;
    }

    public boolean isUsingRepo() {
        return this.getSource() != null;
    }

    public Source getSource() {
        if (this.source == null) {
            String repName = this.getPathInfo().getSourceName();
            if (!StringUtils.isEmpty((String)repName)) {
                this.source = CrucibleFilter.getSource(repName);
            } else if (!StringUtils.isEmpty((String)this.getReview().getProject().getDefaultRepositoryName())) {
                this.source = CrucibleFilter.getSource(this.getReview().getProject().getDefaultRepositoryName());
            }
            if (this.source != null && !this.source.isAvailable()) {
                this.source = null;
            }
        }
        return this.source;
    }

    public String getSourceName() {
        return this.getSource() == null ? "" : this.getSource().getName();
    }

    public String getSourceType() {
        return SourceUtils.getSourceType(this.getSource());
    }

    public boolean isRepositoryAvailable() {
        return this.getSource() != null && this.getSource().isAvailable();
    }

    public Path getFullPath() {
        return this.getPathInfo().getFullPath();
    }

    @Override
    public Set<FecruUser> getAvailableUsers() throws DbException {
        if (this.isRepositoryAvailable()) {
            String sourceRepo = this.getReview().getDefaultSource();
            List<String> committerNames = this.getSource().findAuthors(this.getPathInfo().getLocalPath());
            return this.committerMappingManager.getUsersForCommittersInRep(sourceRepo, committerNames);
        }
        return Collections.emptySet();
    }

    public List<CommitterDisplayDetails> getAvailableCommitters() throws DbException {
        WaybackSpec wb;
        ArrayList<String> authors = new ArrayList<String>();
        if (this.isRepositoryAvailable()) {
            List<String> a2 = this.getSource().findAuthors(this.getPathInfo().getLocalPath());
            authors.addAll(a2);
        }
        if ((wb = this.getWbSpec()) != null && wb.getAuthor() != null && !authors.contains(wb.getAuthor())) {
            authors.add(0, wb.getAuthor());
        }
        return this.committerMappingManager.constructUserListFromCommitters(this.getRepoName(), authors);
    }

    @Override
    public List<String> getAvailableBranches() {
        WaybackSpec wb;
        ArrayList<String> branches = new ArrayList<String>();
        CruciblePathInfo pi = this.getPathInfo();
        if (this.isRepositoryAvailable()) {
            List<String> b2 = this.getSource().findBranches(pi.getLocalPath());
            branches.addAll(b2);
        }
        if ((wb = this.getWbSpec()) != null && wb.getBranch() != null && !branches.contains(wb.getBranch())) {
            branches.add(0, wb.getBranch());
        }
        return branches;
    }

    public String execute() throws Exception {
        return this.doView();
    }

    protected String doView() {
        if (!this.canModFiles()) {
            return "AccessError";
        }
        CruciblePathInfo pi = this.getPathInfo();
        this.wbSpec = WaybackSpec.fromCommandString(pi.getCommandString());
        if (this.wbSpec == null) {
            this.wbSpec = new WaybackSpec();
        }
        if (pi.isEmpty() && !Strings.isNullOrEmpty((String)this.getReview().getDefaultSource())) {
            String user;
            String repname = pi.getSourceName();
            if (repname == null) {
                repname = this.getReview().getDefaultSource();
            }
            if (this.committerMappingManager.getAllCommittersForUserInRep(repname, user = this.getReview().getAuthor().getUsername()).size() > 0) {
                this.wbSpec.setUser(user);
            }
            this.setActionPathInfo(this.wbSpec.getUrlCommand() + "/" + repname + "/" + pi.getLocalPath());
            return SUCCESS_REDIRECT;
        }
        if (this.handleWaybackJump()) {
            return SUCCESS_REDIRECT;
        }
        Source source = this.getSource();
        if (source instanceof RepositorySource) {
            try {
                if (this.handleSvnConflictingBranches(((RepositorySource)source).getRepoEngine())) {
                    return SUCCESS_REDIRECT;
                }
            }
            catch (DbException e2) {
                Logs.APP_LOG.error((Object)"Failed to handle svn branch redirect", (Throwable)e2);
            }
            catch (IOException e3) {
                Logs.APP_LOG.error((Object)"Failed to handle svn branch redirect", (Throwable)e3);
            }
        }
        this.setRepoName(this.getReview().getDefaultSource());
        return "success";
    }

    public List<String> getIdsToRemove() throws Exception {
        return new ArrayList<String>();
    }

    public String getDefaultFileManagementTab() {
        if (this.getSource() != null && this.getSource().isChangesetCapable()) {
            return "changelog";
        }
        return "browse";
    }

    public String getUserDisplayName() {
        if (this.wbSpec != null && !Strings.isNullOrEmpty((String)this.wbSpec.getUser()) && this.userManager.getUser(this.wbSpec.getUser()) != null) {
            return this.userManager.getUser(this.wbSpec.getUser()).getDisplayName();
        }
        return "";
    }
}

