/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.actions.create;

import com.atlassian.crucible.actions.AjaxResponse;
import com.atlassian.crucible.actions.ReviewBaseAction;
import com.atlassian.crucible.event.ReviewUpdatedEventImpl;
import com.atlassian.crucible.spi.data.ReviewData;
import com.atlassian.crucible.spi.impl.SPIUtils;
import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fisheye.jira.RemoteJiraException;
import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.ReviewParticipant;
import com.cenqua.crucible.model.managers.InviteManager;
import com.cenqua.crucible.model.managers.LogManager;
import com.cenqua.crucible.model.managers.ReviewMutableProperties;
import com.cenqua.crucible.model.managers.UserActionManager;
import com.cenqua.crucible.notification.NotificationManager;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.util.ISO8601DateHelper;
import com.cenqua.fisheye.util.StringUtil;
import com.google.common.base.Strings;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;

public class EditReviewDetailsAction
extends ReviewBaseAction
implements AjaxResponse {
    private String title;
    private Project project;
    private String description;
    private int author = -1;
    private int moderator = -1;
    private boolean allowJoin;
    private IntSet selectedReviewers = new IntOpenHashSet();
    private Set<String> inviteReviewers = new HashSet<String>();
    private String dueDateString;
    private Integer reminderDays;
    private String jiraIssueKey;
    private String command;
    private String errorMsg = "";
    private boolean worked = true;
    @Resource
    protected SPIUtils spiUtils;
    @Resource
    protected NotificationManager notificationManager;
    private String projectKey;

    public void setNotificationManager(NotificationManager notificationManager) {
        this.notificationManager = notificationManager;
    }

    @Override
    public boolean isWorked() {
        return this.worked;
    }

    @Override
    public String getErrorMsg() {
        return this.errorMsg;
    }

    protected void log(ReviewMutableProperties property, String oldValue, String newValue) {
        LogManager.logReviewPropertyChanged(property, this.getReview(), this.getCurrentUser(), oldValue, newValue);
    }

    public String getTitle() {
        return this.getReview().getName();
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setProjectKey(String projectKey) {
        this.projectKey = projectKey;
        this.project = this.projectManager.getProjectByKey(projectKey);
    }

    @Override
    public Project getProject() {
        return this.project;
    }

    public String getDescription() {
        return this.getReview().getDescription();
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public FecruUser getIterationAuthor() {
        return this.getReview().getAuthor();
    }

    public void setNewAuthor(int author) {
        this.author = author;
    }

    public FecruUser getIterationModerator() {
        return this.getReview().getModerator();
    }

    public void setNewModerator(int moderator) {
        this.moderator = moderator;
    }

    public void setReviewers(int[] vals) {
        for (int v2 : vals) {
            this.selectedReviewers.add(v2);
        }
    }

    public void setInvitees(String[] vals) {
        this.inviteReviewers.addAll(Arrays.asList(vals));
    }

    public boolean isAllowJoin() {
        return this.getReview().isAllowReviewerToJoin();
    }

    public void setAllowJoin(boolean allowJoin) {
        this.allowJoin = allowJoin;
    }

    public void setDueDateString(String dueDateString) throws ISO8601DateHelper.InvalidDateException {
        this.dueDateString = dueDateString;
    }

    public void setReminderDays(Integer reminderDays) {
        this.reminderDays = reminderDays;
    }

    public void setJiraIssueKey(String jiraIssueKey) {
        this.jiraIssueKey = jiraIssueKey;
    }

    public Set<String> getInviteReviewers() throws DbException {
        return this.getReview().getInvitees();
    }

    public String getCommand() {
        return this.command;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    private boolean changed(String newVal, String currentVal) {
        return !StringUtil.equalsWithNullsAsEmpty(newVal, currentVal);
    }

    private ReviewParticipant.ParticipantsRoles getTuple(Map<FecruUser, ReviewParticipant.ParticipantsRoles> newParticipants, FecruUser user, boolean reviewer, boolean author, boolean moderator) {
        return ReviewParticipant.addToExistingRoles(newParticipants.get(user), user, reviewer, author, moderator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String execute() throws Exception {
        Review review = this.getReview();
        if (review.getState().isClosedMetaState()) {
            this.errorMsg = "Cannot edit details of a closed review.";
            this.worked = false;
            return "ajaxError";
        }
        if (this.project == null) {
            this.errorMsg = "The project key " + this.projectKey + " does not refer to a valid project";
            this.worked = false;
            return "ajaxError";
        }
        if (!this.isFileModifiable()) {
            UserActionManager userActionManager = UserActionManager.getInstance();
            this.errorMsg = userActionManager.getAction(UserActionManager.ACTION_MOD_FILES).getPermissionViolationMsg();
            this.worked = false;
            return "ajaxError";
        }
        try {
            FecruUser newModerator;
            FecruUser newAuthor;
            this.beginTx();
            if (this.command == null) {
                this.commitTx();
                String userActionManager = "success";
                return userActionManager;
            }
            boolean updated = false;
            ReviewData oldReviewData = this.spiUtils.createReviewData(review);
            if (this.changed(this.title, review.getName())) {
                this.log(ReviewMutableProperties.TITLE, review.getName(), this.title);
                review.setName(this.title);
                updated = true;
            }
            if (this.changed(this.description, review.getDescription())) {
                this.log(ReviewMutableProperties.DESCRIPTION, review.getDescription(), this.description);
                review.setDescription(this.description);
                updated = true;
            }
            if (review.isAllowReviewerToJoin() != this.allowJoin) {
                this.log(ReviewMutableProperties.ALLOW_JOIN, Boolean.toString(review.isAllowReviewerToJoin()), Boolean.toString(this.allowJoin));
                review.setAllowReviewerToJoin(this.allowJoin);
                updated = true;
            }
            Date dueDate = Strings.isNullOrEmpty((String)this.dueDateString) ? null : ISO8601DateHelper.parseAsTimeZone(this.dueDateString, this.getTimeZoneForAction());
            Date oldDueDate = review.getDueDate();
            if (dueDate == null && oldDueDate != null || dueDate != null && !dueDate.equals(oldDueDate)) {
                this.log(ReviewMutableProperties.DUE_DATE, ISO8601DateHelper.toIsoDate(oldDueDate), ISO8601DateHelper.toIsoDate(dueDate));
                review.setDueDate(dueDate);
                updated = true;
            }
            Date reminderDate = this.reminderDays == null || dueDate == null ? null : ISO8601DateHelper.addWorkingDays(dueDate, -this.reminderDays.intValue(), this.getTimeZoneForAction());
            Date oldReminderDate = review.getReminderDate();
            if (reminderDate == null && oldReminderDate != null || reminderDate != null && !reminderDate.equals(oldReminderDate)) {
                this.log(ReviewMutableProperties.REMINDER_DATE, ISO8601DateHelper.toIsoDate(oldReminderDate), ISO8601DateHelper.toIsoDate(reminderDate));
                review.setReminderDate(reminderDate);
                updated = true;
            }
            if (this.hasJiraLinkPermission() && this.changed(this.jiraIssueKey, review.getJiraIssueKey())) {
                if (Strings.isNullOrEmpty((String)this.jiraIssueKey)) {
                    this.log(ReviewMutableProperties.JIRA_KEY, review.getJiraIssueKey(), "");
                    review.setJiraIssueKey(null);
                    updated = true;
                } else {
                    try {
                        if (this.jiraIssueService.getJiraIssueAggregateExceptions(this.jiraIssueKey, this.getQueryContext()) != null) {
                            review.setJiraIssueKey(this.jiraIssueKey);
                            this.log(ReviewMutableProperties.JIRA_KEY, review.getJiraIssueKey(), this.jiraIssueKey);
                            updated = true;
                        }
                    }
                    catch (RemoteJiraException e2) {
                        this.errorMsg = e2.getMessage();
                        this.worked = false;
                        String string = "ajaxError";
                        this.rollbackTxIfNotCommited();
                        return string;
                    }
                }
            }
            HashMap<FecruUser, ReviewParticipant.ParticipantsRoles> newParticipants = new HashMap<FecruUser, ReviewParticipant.ParticipantsRoles>();
            FecruUser authorToAdd = review.getAuthor();
            if (this.author >= 0 && (newAuthor = this.userManager.getLicensedUser(this.author)) != null && !review.isAuthor(newAuthor)) {
                if (review.getState().isReviewState()) {
                    this.notificationManager.noteGeneralMsg(review, this.getCurrentUser(), newAuthor, "You have been assigned author of review " + this.getPermaId());
                    this.notificationManager.noteGeneralMsg(review, this.getCurrentUser(), review.getAuthor(), "You have been replaced as author of review " + this.getPermaId() + " by " + newAuthor.getDisplayName());
                }
                this.log(ReviewMutableProperties.AUTHOR, review.getAuthor().getUsername(), newAuthor.getUsername());
                updated = true;
                authorToAdd = newAuthor;
            }
            if (authorToAdd != null) {
                newParticipants.put(authorToAdd, this.getTuple(newParticipants, authorToAdd, false, true, false));
            }
            FecruUser moderatorToAdd = review.getModerator();
            if (this.moderator >= 0 && (newModerator = this.userManager.getLicensedUser(this.moderator)) != null && !review.isModerator(newModerator)) {
                if (review.getState().isReviewState()) {
                    this.notificationManager.noteGeneralMsg(review, this.getCurrentUser(), newModerator, "You have been made moderator of review " + this.getPermaId());
                    this.notificationManager.noteGeneralMsg(review, this.getCurrentUser(), review.getModerator(), "You have been replaced as moderator of review " + this.getPermaId() + " by " + newModerator.getDisplayName());
                }
                this.log(ReviewMutableProperties.MODERATOR, review.getModerator().getUsername(), newModerator.getUsername());
                updated = true;
                moderatorToAdd = newModerator;
            }
            if (moderatorToAdd != null) {
                newParticipants.put(moderatorToAdd, this.getTuple(newParticipants, moderatorToAdd, false, false, true));
            }
            HashSet<FecruUser> reviewers = new HashSet<FecruUser>(review.getReviewers());
            for (FecruUser user : reviewers) {
                if (!this.selectedReviewers.contains((Object)user.getId())) {
                    updated = true;
                    LogManager.logReviewReviewerRemove(review, this.getCurrentUser(), user, review.getState().isReviewState());
                    if (!review.getState().isReviewState()) continue;
                    this.notificationManager.noteGeneralMsg(review, this.getCurrentUser(), user, "You have been removed as a reviewer in review " + this.getPermaId());
                    continue;
                }
                if (newParticipants.containsKey(user)) continue;
                newParticipants.put(user, new ReviewParticipant.ParticipantsRoles(user, true, false, false));
            }
            IntIterator intIterator = this.selectedReviewers.iterator();
            while (intIterator.hasNext()) {
                int reviewer = (Integer)intIterator.next();
                FecruUser user = this.userManager.getUserById(reviewer);
                if (reviewers.contains(user)) continue;
                if (this.projectManager.isAllowedReviewer(this.project, user)) {
                    if (!newParticipants.containsKey(user)) {
                        newParticipants.put(user, new ReviewParticipant.ParticipantsRoles(user, true, false, false));
                    }
                    updated = true;
                    LogManager.logReviewReviewerAdd(review, this.getCurrentUser(), user, review.getState().isReviewState());
                    if (!review.getState().isReviewState()) continue;
                    this.notificationManager.noteGeneralMsg(review, this.getCurrentUser(), user, "You have been added as a reviewer in " + this.getPermaId());
                    continue;
                }
                Logs.APP_LOG.warn((Object)String.format("User %s is not in the list of allowed reviewers for project %s and therefore cannot be added to review %s.", user.getUsername(), this.project.getProjKey(), this.getPermaId()));
            }
            review.setParticipants(newParticipants);
            HashSet<String> invitees = new HashSet<String>(review.getInvitees());
            for (String invitee : invitees) {
                if (this.inviteReviewers.contains(invitee)) continue;
                review.removeInviteReviewer(invitee);
                updated = true;
                InviteManager.sendUninviteEmail(invitee, review);
                LogManager.logReviewInvitationCancelled(review, this.getCurrentUser(), invitee);
            }
            for (String address : this.inviteReviewers) {
                if (invitees.contains(address)) continue;
                List<String> messages = InviteManager.inviteReviewer(address, review, this.getCurrentUser());
                updated = true;
                for (String message : messages) {
                    LogManager.logReviewReviewerInviteError(review, this.getCurrentUser(), message);
                }
                if (!messages.isEmpty()) continue;
                LogManager.logReviewInvitation(review, this.getCurrentUser(), address);
            }
            if (this.project != null && !this.project.equals(review.getProject())) {
                try {
                    this.projectManager.moveReviewToProject(review, this.project);
                    updated = true;
                }
                catch (DbException e3) {
                    this.errorMsg = "Problem moving review to new project: " + e3.getMessage();
                    this.worked = false;
                    String string = "ajaxError";
                    this.rollbackTxIfNotCommited();
                    return string;
                }
            }
            this.commitTx();
            if (updated) {
                this.eventPublisher.publish((Object)new ReviewUpdatedEventImpl(review.getPermId(), this.getCurrentUserData(), oldReviewData));
            }
            String string = this.command;
            return string;
        }
        finally {
            this.rollbackTxIfNotCommited();
        }
    }
}

