/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.actions.create;

import com.atlassian.crucible.actions.create.EditRevisionsAction;
import com.atlassian.crucible.explorers.ChangeSetDO;
import com.atlassian.crucible.explorers.ChangelogExplorer;
import com.atlassian.xwork.RequireSecurityToken;
import com.cenqua.crucible.model.managers.LogManager;
import com.cenqua.crucible.model.managers.ReviewMutableProperties;
import com.cenqua.crucible.revision.source.SourceException;
import com.cenqua.fisheye.config.RepositoryManager;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.google.common.base.Strings;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;

public class EditChangelogAction
extends EditRevisionsAction {
    @Resource
    private RepositoryManager repositoryManager;
    private RecentChangesDO recentChanges;
    private ChangelogExplorer explorer;
    private String fromid;
    private String toid;
    private boolean inc;
    private String jumptoid;
    private boolean jumpToChangeSetRepositoryIndexing;
    private boolean jumpToChangeSetExists;
    private boolean jumpToChangeSetPossiblyFiltered;

    @Override
    @RequireSecurityToken(value=false)
    public String execute() throws Exception {
        return this.doView();
    }

    @Override
    public String getEditMode() {
        return "changelog";
    }

    public void setFromid(String fromid) {
        this.fromid = fromid;
    }

    public void setToid(String toid) {
        this.toid = toid;
    }

    public String getJumptoid() {
        return this.jumptoid;
    }

    public void setJumptoid(String jumptoid) {
        this.jumptoid = jumptoid;
    }

    public ChangelogExplorer getExplorer() throws Exception {
        this.initChangesets();
        return this.explorer;
    }

    public RecentChangesDO getRecentChanges() throws Exception {
        this.initChangesets();
        return this.recentChanges;
    }

    public void setInc(boolean inc) {
        this.inc = inc;
    }

    private void initChangesets() throws DbException, SourceException {
        if (this.recentChanges == null && this.isRepositoryAvailable() && this.getSource().isChangesetCapable()) {
            this.explorer = this.getSource().getChangelogExplorer(this.getPathInfo().getLocalPath(), this.wbSpec, this.getReview());
            if (this.jumptoid != null) {
                this.toid = this.jumptoid;
                this.inc = true;
            }
            if (!Strings.isNullOrEmpty((String)this.wbSpec.getUser())) {
                this.explorer.setCommitters(this.committerMappingManager.getAllCommittersForUserInRep(this.getRepoName(), this.wbSpec.getUser()));
            }
            if (!Strings.isNullOrEmpty((String)this.fromid)) {
                this.explorer.setFromChangeSetId(this.fromid);
                this.explorer.setFromChangeSetIdInc(this.inc);
            } else if (!Strings.isNullOrEmpty((String)this.toid)) {
                this.explorer.setToChangeSetId(this.toid);
                this.explorer.setToChangeSetIdInc(this.inc);
            }
            this.explorer.computeData(10);
            List<ChangeSetDO> changesets = this.explorer.getChangesets();
            if (this.jumptoid != null) {
                RepositoryHandle repHandle;
                this.jumpToChangeSetExists = this.getSource().existsChangeSet(this.jumptoid);
                if (this.jumpToChangeSetExists) {
                    this.jumpToChangeSetPossiblyFiltered = !this.getWbSpec().isNoOp() && (changesets.size() == 0 || !changesets.get(0).getId().startsWith(this.jumptoid));
                }
                this.jumpToChangeSetRepositoryIndexing = (repHandle = this.repositoryManager.getRepository(this.getSourceName())) != null && !repHandle.getStatus().isInitialCrucibleIndexingComplete();
            }
            this.recentChanges = new RecentChangesDO(changesets);
        }
    }

    public boolean isJumpToChangeSetNonexistent() {
        return !this.jumpToChangeSetExists;
    }

    public boolean isJumpToChangeSetRepositoryIndexing() {
        return this.jumpToChangeSetRepositoryIndexing;
    }

    public boolean isJumpToChangeSetPossiblyFiltered() {
        return this.jumpToChangeSetPossiblyFiltered;
    }

    public String doSetRepo() throws Exception {
        if (!this.canModFiles()) {
            return "AccessError";
        }
        try {
            this.beginTx();
            if (!StringUtils.equals((String)this.getRepoName(), (String)this.getReview().getDefaultSource())) {
                LogManager.logReviewPropertyChanged(ReviewMutableProperties.REPOSITORY, this.getReview(), this.getCurrentUser(), this.getReview().getDefaultSource(), this.getEditMode());
                this.getReview().setDefaultSource(this.getRepoName());
            }
            this.command = "successRedirect";
            this.commitTx();
            String string = this.command;
            return string;
        }
        finally {
            this.rollbackTxIfNotCommited();
        }
    }

    public static class RecentChangesDO {
        private final List<ChangeSetDO> changesetInfos;

        public RecentChangesDO(List<ChangeSetDO> changesets) {
            this.changesetInfos = changesets;
        }

        public List<ChangeSetDO> getChangeSetInfos() {
            return this.changesetInfos;
        }
    }
}

