/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.actions.create;

import com.atlassian.crucible.actions.create.EditRevisionsAction;
import com.atlassian.fisheye.scm.DirTreeData;
import com.atlassian.fisheye.scm.FileExplorerInfo;
import com.atlassian.fisheye.scm.RepositoryExplorer;
import com.atlassian.xwork.RequireSecurityToken;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.web.WaybackSpec;
import java.util.ArrayList;
import java.util.List;

public class EditBrowseAction
extends EditRevisionsAction {
    private RepositoryExplorer explorer;
    private DirTreeData dirTree;

    @Override
    public String getEditMode() {
        return "browse";
    }

    public RepositoryExplorer getRepositoryExplorer() throws DbException {
        if (this.explorer == null && this.isRepositoryAvailable()) {
            Path lpath = this.getPathInfo().getLocalPath();
            WaybackSpec wb = this.getWbSpec();
            wb.setAuthor(null);
            wb.setBranch(null);
            wb.setTag(null);
            this.explorer = this.getSource().getRepositoryExplorer(lpath, wb, this.getUserPreferences());
        }
        return this.explorer;
    }

    public DirTreeData getDirTreeData() throws DbException {
        if (this.dirTree == null) {
            this.dirTree = this.getRepositoryExplorer().getDirTreeData(Path.ROOT, this.getPathInfo().getLocalPath(), true);
        }
        return this.dirTree;
    }

    @Override
    public List<String> getIdsToRemove() throws Exception {
        if (this.getRepositoryExplorer() == null) {
            return super.getIdsToRemove();
        }
        List<FileExplorerInfo> files = this.getRepositoryExplorer().getFiles();
        if (files == null) {
            return super.getIdsToRemove();
        }
        ArrayList<String> result = new ArrayList<String>();
        for (FileExplorerInfo file : files) {
            result.add(String.valueOf(file.getLatestRevisionCrucibleId()));
        }
        return result;
    }

    @Override
    @RequireSecurityToken(value=false)
    public String execute() throws Exception {
        return super.execute();
    }
}

