/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.actions.create;

import com.atlassian.crucible.actions.create.CreateReviewBaseAction;
import com.atlassian.crucible.event.ReviewCreateJiraAdded;
import com.atlassian.crucible.explorers.ChangeSetPair;
import com.atlassian.crucible.explorers.CrucibleChangeSet;
import com.atlassian.crucible.explorers.CrucibleChangeSetsHelper;
import com.atlassian.crucible.filters.CrucibleFilter;
import com.atlassian.crucible.spi.PermId;
import com.atlassian.crucible.spi.impl.SPIUtils;
import com.atlassian.crucible.spi.services.ChangeSetContentTooLargeException;
import com.atlassian.crucible.spi.services.ContentTooLargeException;
import com.atlassian.crucible.spi.services.ReviewContentTooLargeException;
import com.atlassian.crucible.spi.services.ReviewService;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.fecru.review.ReviewLockManager;
import com.atlassian.fecru.security.CurrentUserPermissions;
import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fisheye.jira.JiraIssueUtil;
import com.atlassian.fisheye.jira.JiraServerService;
import com.atlassian.fisheye.jira.issue.JiraIssueService;
import com.atlassian.fisheye.user.RecentlyVisitedManager;
import com.atlassian.fisheye.user.model.RecentlyVisitedItem;
import com.atlassian.fisheye.user.model.RecentlyVisitedProject;
import com.atlassian.fisheye.user.permissions.GlobalPermissionManager;
import com.atlassian.fisheye.user.permissions.GlobalPermissionType;
import com.atlassian.fugue.Option;
import com.atlassian.xwork.RequireSecurityToken;
import com.cenqua.crucible.model.CrucibleRevision;
import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.managers.CommentManager;
import com.cenqua.crucible.model.managers.PermissionManager;
import com.cenqua.crucible.notification.NotificationManager;
import com.cenqua.crucible.revision.managers.ContentManager;
import com.cenqua.crucible.revision.source.Source;
import com.cenqua.crucible.revision.source.SourceException;
import com.cenqua.crucible.tags.ReviewUtil;
import com.cenqua.crucible.util.ReviewCreationHelper;
import com.cenqua.fisheye.crossrepo.ChangesetCannedQueries;
import com.cenqua.fisheye.crossrepo.ChangesetSearcher;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.model.ContentRoot;
import com.cenqua.fisheye.model.manager.CommitterUserMappingManager;
import com.cenqua.fisheye.util.Pair;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import org.apache.commons.lang.mutable.MutableInt;
import org.apache.commons.lang.mutable.MutableLong;
import org.apache.commons.lang.mutable.MutableObject;
import org.springframework.beans.factory.annotation.Autowired;

public class CreateReviewFromChangesetAjaxAction
extends CreateReviewBaseAction {
    protected static final String DONE = "done";
    protected static final String SELECT_PROJECT = "selectProject";
    private boolean worked = true;
    private boolean noEscape = false;
    private String errorMsg = "";
    private Review review;
    private String requestedRepo;
    private String title;
    private String description;
    private String[] csid;
    private String[] revid;
    private String revpath;
    private Project project;
    private String crucibleProject;
    private static final Pattern CSID_PATTERN = Pattern.compile("^(//([^/]+)/)?(.+)$");
    private Review.AttachMethod attachMethod = Review.AttachMethod.ITERATION;
    private String fromRevision;
    private String task;
    private String method;
    private String result;
    private SimpleRevisionInfo firstChangeset;
    @Resource
    private ContentManager contentManager;
    @Resource
    private NotificationManager notificationManager;
    @Resource
    private SPIUtils spiUtils;
    @Resource
    private CommitterUserMappingManager committerMappingManager;
    @Resource
    private PermissionManager permissionManager;
    @Autowired
    private CommentManager commentManager;
    @Autowired
    private JiraIssueService jiraIssueService;
    @Autowired
    private JiraServerService jiraServerService;
    @Autowired
    private RecentlyVisitedManager recentlyVisitedManager;
    @Autowired
    private CrucibleChangeSetsHelper crucibleChangeSetsHelper;
    @Autowired
    private ReviewService reviewService;
    @Autowired
    private EventPublisher eventPublisher;
    @Autowired
    private ChangesetSearcher changesetSearcher;
    @Autowired
    private CurrentUserPermissions currentUserPermissions;
    @Autowired
    private GlobalPermissionManager globalPermissionManager;
    @Autowired
    private ReviewLockManager reviewLockManager;
    private List<String> issueKeys = Collections.emptyList();
    private String issueSummary;
    private String issueDescription;

    protected void setReviewLockManager(ReviewLockManager reviewLockManager) {
        this.reviewLockManager = reviewLockManager;
    }

    protected void setEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    public String getResult() {
        return this.result;
    }

    @Override
    public boolean isWorked() {
        return this.worked;
    }

    public boolean isNoEscape() {
        return this.noEscape;
    }

    @Override
    public String getErrorMsg() {
        return this.errorMsg;
    }

    public boolean isShowDialog() {
        return !this.result.equals(DONE);
    }

    public boolean isRedirect() {
        return !this.isShowDialog();
    }

    public String getTask() {
        return this.task;
    }

    public void setTask(String task) {
        this.task = task;
    }

    public String getFromRevision() {
        return this.fromRevision;
    }

    public void setFromRevision(String fromRevision) {
        this.fromRevision = fromRevision;
    }

    public String getAttachMethod() {
        return this.attachMethod.name();
    }

    public void setAttachMethod(String attachMethod) {
        this.attachMethod = Review.AttachMethod.valueOf(attachMethod);
    }

    public void setProjectId(int projectId) {
        this.project = this.projectManager.getProjectById(projectId);
    }

    public String getActionName() {
        return "create";
    }

    @Override
    public Project getProject() {
        return this.project;
    }

    public void setProjectKey(String projectKey) {
        this.project = this.projectManager.getProjectByKey(projectKey);
    }

    public String getProjectKey() {
        return this.project == null ? null : this.project.getProjKey();
    }

    public String getPermaId() {
        return this.review == null ? "" : this.review.getPermaId();
    }

    public Review getReview() {
        return this.review;
    }

    public void setRepo(String repo) {
        this.requestedRepo = repo;
    }

    public String getRepo() {
        return this.requestedRepo;
    }

    public void setCsid(String[] csid) {
        this.csid = csid;
    }

    public String[] getCsid() {
        return this.csid;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String[] getRevid() {
        return this.revid;
    }

    public void setRevid(String[] revid) {
        this.revid = revid;
    }

    public String getRevpath() {
        return this.revpath;
    }

    public void setRevpath(String revpath) {
        this.revpath = revpath;
    }

    public void setIssueKey(String[] issueKeys) {
        this.issueKeys = Arrays.asList(issueKeys);
    }

    public void setIssueSummary(String issueSummary) {
        this.issueSummary = issueSummary;
    }

    public void setIssueDescription(String issueDescription) {
        this.issueDescription = issueDescription;
    }

    public SimpleRevisionInfo getFirstChangeset() {
        return this.firstChangeset;
    }

    private void setFirstChangesetIfEmpty(ChangeSetPair changeSetPair) {
        if (null == this.firstChangeset) {
            this.firstChangeset = new SimpleRevisionInfo(changeSetPair.getCsid(), changeSetPair.getRepository());
        }
    }

    private String addToReview(String permaId, final List<CrucibleChangeSet> changeSets, final Pair<CrucibleRevision, CrucibleRevision> revisionPair) throws SourceException, ReviewContentTooLargeException {
        if (this.isInvalidToken()) {
            this.worked = true;
            this.errorMsg = "Invalid xsrf token";
            return "xsrfError";
        }
        String result = "suggest";
        this.review = this.reviewManager.getReviewByPermaId(permaId);
        if (this.review != null) {
            if (!this.currentUserPermissions.canModifyReview(this.review)) {
                this.errorMsg = "Review " + permaId + " cannot be added to";
                this.worked = false;
            } else {
                result = this.reviewLockManager.withReviewLock(this.review, new Callable<String>(){

                    @Override
                    public String call() throws Exception {
                        for (CrucibleChangeSet changeSet : changeSets) {
                            CreateReviewFromChangesetAjaxAction.this.filterAndAddChangeSetToReview(changeSets.size() == 1, changeSet);
                        }
                        CreateReviewFromChangesetAjaxAction.this.addRevisionPairToReview(CreateReviewFromChangesetAjaxAction.this.review, revisionPair);
                        return CreateReviewFromChangesetAjaxAction.DONE;
                    }
                });
            }
        } else {
            this.errorMsg = "Review " + permaId + " not found.";
            this.worked = false;
        }
        return result;
    }

    private String createNewReview(final List<CrucibleChangeSet> changeSets, final Pair<CrucibleRevision, CrucibleRevision> revisionPair) throws SourceException, ReviewContentTooLargeException {
        Option<String> earlyResult = this.guessReviewProject(changeSets);
        if (earlyResult.isDefined()) {
            this.commitTx();
            return (String)earlyResult.get();
        }
        if (!this.permissionManager.canPrincipalCreateIn(this.getPrincipal(), this.project)) {
            this.errorMsg = "You do not have permission to create reviews in project " + this.project.getName();
            this.worked = false;
            return SELECT_PROJECT;
        }
        if (this.checkIsConfirmCreateNeeded()) {
            this.preSelectedProject = this.project;
            return SELECT_PROJECT;
        }
        this.review = this.reviewManager.createReviewWithDefaults(this.projectManager, this.project, "", this.getCurrentUser());
        if (this.project.isModeratorEnabled() && !this.review.isModerated()) {
            this.review.setModerator(this.getCurrentUser());
        }
        this.review.setCreator(this.getCurrentUser());
        final MutableObject newestRepo = new MutableObject(null);
        final MutableLong dateOfNewestRepo = new MutableLong(0L);
        final MutableInt revisionsAdded = new MutableInt(0);
        this.reviewLockManager.withReviewLock(this.review, new Callable<Void>(){

            @Override
            public Void call() throws SourceException {
                for (CrucibleChangeSet changeSet : changeSets) {
                    revisionsAdded.add(CreateReviewFromChangesetAjaxAction.this.filterAndAddChangeSetToReview(changeSets.size() == 1, changeSet));
                    if (changeSet.getRevisions().size() <= 0 || dateOfNewestRepo.toLong() >= changeSet.getDate().getTime()) continue;
                    newestRepo.setValue((Object)changeSet.getRevisions().get(0).getSourceName());
                    dateOfNewestRepo.setValue(changeSet.getDate().getTime());
                }
                if (!revisionPair.isNull()) {
                    CreateReviewFromChangesetAjaxAction.this.addRevisionPairToReview(CreateReviewFromChangesetAjaxAction.this.review, revisionPair);
                    CrucibleRevision rev = (CrucibleRevision)revisionPair.getFirst();
                    if (dateOfNewestRepo.toLong() < rev.getCommitDate().getTime()) {
                        newestRepo.setValue((Object)rev.getSourceName());
                    }
                }
                return null;
            }
        });
        Collections.sort(changeSets, new NewestFirstComparator());
        CrucibleChangeSet newestChangeset = null;
        if (!changeSets.isEmpty()) {
            newestChangeset = changeSets.get(0);
        }
        CrucibleRevision newestRevision = null;
        if (!revisionPair.isNull()) {
            newestRevision = revisionPair.getFirst();
        }
        if (!Strings.isNullOrEmpty((String)this.requestedRepo)) {
            this.review.setDefaultSource(this.requestedRepo);
        } else {
            this.review.setDefaultSource(newestRepo.toString());
        }
        if (!Strings.isNullOrEmpty((String)this.title)) {
            this.review.setName(this.title);
        } else if (!Strings.isNullOrEmpty((String)this.issueSummary)) {
            this.review.setName((this.issueKeys.isEmpty() ? "" : this.issueKeys.get(0) + ": ") + this.issueSummary);
            this.eventPublisher.publish((Object)new ReviewCreateJiraAdded());
        } else if (newestChangeset != null && newestChangeset.getComment() != null) {
            this.review.setName(ReviewUtil.extractReviewTitle(newestChangeset.getComment()));
        } else if (newestRevision != null && newestRevision.getCommitMessage() != null) {
            this.review.setName(ReviewUtil.extractReviewTitle(newestRevision.getCommitMessage()));
        }
        StringBuilder objectives = new StringBuilder(Strings.nullToEmpty((String)this.review.getDescription()));
        if (!Strings.isNullOrEmpty((String)this.description)) {
            objectives.append(this.description);
        } else if (!Strings.isNullOrEmpty((String)this.issueDescription)) {
            objectives.append(this.issueDescription);
        } else {
            objectives.append(this.summariseDescriptions(changeSets, revisionPair));
        }
        this.review.setDescription(objectives.toString());
        FecruUser changesetAuthor = null;
        if (newestChangeset != null) {
            FecruUser committer = this.committerMappingManager.getUserForCommitter(newestChangeset.getSource().getName(), newestChangeset.getAuthor());
            if (committer == null) {
                Logs.APP_LOG.debug((Object)("No user mapped for committer '" + newestChangeset.getAuthor() + "' in repository '" + newestChangeset.getSource().getName() + "'"));
            } else if (!this.isCrucibleUser(committer)) {
                Logs.APP_LOG.debug((Object)("'" + committer + "' is not an active Crucible user"));
            } else {
                changesetAuthor = this.userManager.getUser(committer.getUsername());
            }
        }
        FecruUser reviewAuthor = changesetAuthor != null && this.isCrucibleUser(changesetAuthor) ? changesetAuthor : this.getCurrentUser();
        this.review.setAuthor(reviewAuthor);
        this.reviewService.tryAutomaticJiraLinking(new PermId(this.review.getPermaId()));
        this.commitTx();
        Logs.APP_LOG.debug((Object)("Created review " + this.review.getPermaId() + " (Changesets=" + changeSets.size() + ", Revisions=" + revisionsAdded + ")"));
        return DONE;
    }

    private boolean isCrucibleUser(FecruUser committer) {
        return this.globalPermissionManager.hasPermission(committer.getUsername(), GlobalPermissionType.CRUCIBLE_USER);
    }

    private Option<String> guessReviewProject(List<CrucibleChangeSet> changeSets) {
        if (this.project == null) {
            List<Project> allAllowedProjects = this.getProjectsCanCreateIn();
            if (allAllowedProjects.isEmpty()) {
                this.errorMsg = "You do not have permission to create reviews in any project.";
                this.worked = false;
                this.result = "error";
                return Option.option((Object)this.result);
            }
            if (allAllowedProjects.size() == 1) {
                this.project = allAllowedProjects.get(0);
            }
            if (this.project == null) {
                this.project = this.findRequestedProject(allAllowedProjects);
            }
            if (this.project == null) {
                List<Project> defaultRepoProjects = this.filterProjectsByRepo(allAllowedProjects);
                if (defaultRepoProjects.size() == 1) {
                    this.project = defaultRepoProjects.get(0);
                }
                List<Object> issueProjects = Collections.emptyList();
                if (this.project == null && (issueProjects = this.findProjectFromChangesets(allAllowedProjects, changeSets)).size() == 1) {
                    this.project = (Project)issueProjects.get(0);
                }
                if (this.project == null) {
                    ImmutableSortedSet.Builder candidateProjectBuiler = ImmutableSortedSet.orderedBy((Comparator)new Project.NameComparator());
                    if (defaultRepoProjects.isEmpty() && issueProjects.isEmpty()) {
                        candidateProjectBuiler.addAll(allAllowedProjects);
                    } else {
                        candidateProjectBuiler.addAll(defaultRepoProjects).addAll(issueProjects);
                    }
                    ImmutableSortedSet candidateProjects = candidateProjectBuiler.build();
                    this.preSelectedProject = this.project = (Project)candidateProjects.first();
                    if (candidateProjects.size() > 1) {
                        List recentProjects = this.recentlyVisitedManager.getHistory(RecentlyVisitedItem.Type.PROJECT, this.getPrincipal());
                        for (RecentlyVisitedProject p2 : recentProjects) {
                            if (!candidateProjects.contains(p2.getEntity())) continue;
                            this.project = this.preSelectedProject = p2.getEntity();
                            break;
                        }
                        return Option.option((Object)SELECT_PROJECT);
                    }
                }
            }
        }
        return Option.none();
    }

    private List<Project> findProjectFromChangesets(List<Project> projects, List<CrucibleChangeSet> changeSets) {
        Iterable issueKeysFromChangesets = Iterables.concat((Iterable)Iterables.transform(changeSets, changeSet -> JiraIssueUtil.getJiraKeysFromString(changeSet.getComment())));
        Iterable projectKeys = Iterables.transform((Iterable)Iterables.concat(this.issueKeys, (Iterable)issueKeysFromChangesets), JiraIssueUtil.ISSUE_KEY_TO_PROJECT_KEY);
        ImmutableSet.Builder candidates = ImmutableSet.builder();
        for (Option jiraProject : Iterables.filter((Iterable)projectKeys, (Predicate)Option.defined())) {
            Iterable<Project> linkedCrucibleProjects = this.jiraIssueService.findLinkedCrucibleProjects(projects, (String)jiraProject.get());
            candidates.addAll(linkedCrucibleProjects);
        }
        return ImmutableList.copyOf((Collection)candidates.build());
    }

    private Project findRequestedProject(List<Project> principlesProjects) {
        Project requested = null;
        if (this.crucibleProject != null && (requested = (Project)Iterables.find(principlesProjects, input -> input.getProjKey().equals(this.crucibleProject), null)) == null) {
            Logs.APP_LOG.debug((Object)("Requested review creation in non-existant or non-accessible project " + this.crucibleProject));
        }
        return requested;
    }

    private int filterAndAddChangeSetToReview(boolean failIfEmptyAfterFiltering, CrucibleChangeSet changeSet) throws SourceException, ReviewContentTooLargeException {
        Source s2;
        if (!changeSet.getRevisions().isEmpty() && (s2 = CrucibleFilter.getSource(changeSet.getRevisions().get(0).getSourceName())) != null) {
            ReviewCreationHelper rch = new ReviewCreationHelper(s2, this.review, this.contentManager, this.notificationManager, this.spiUtils, this.commentManager, this.eventPublisher);
            rch.addRevisions(this.getCurrentUser(), changeSet.getRevisions(), this.attachMethod, this.fromRevision, failIfEmptyAfterFiltering ? ReviewCreationHelper.MetadataFilter.ALL_AND_FAIL : ReviewCreationHelper.MetadataFilter.ALL);
            return rch.getAddedItems().size();
        }
        Logs.APP_LOG.warn((Object)String.format("Could not add ChangeSet %s to review %s -- the changeset is empty.", changeSet.getId(), this.review.getPermaId()));
        return 0;
    }

    private boolean addRevisionPairToReview(Review review, Pair<CrucibleRevision, CrucibleRevision> pair) throws SourceException, ReviewContentTooLargeException {
        Source s2;
        CrucibleRevision first = pair.getFirst();
        if (first != null && (s2 = CrucibleFilter.getSource(first.getSourceName())) != null) {
            CrucibleRevision second = pair.getSecond();
            String secondRev = second == null ? "" : second.getRevision();
            Review.AttachMethod attachMode = second == null ? Review.AttachMethod.WHOLE_FILE : Review.AttachMethod.SPECIFIC_DIFF;
            ReviewCreationHelper rch = new ReviewCreationHelper(s2, review, this.contentManager, this.notificationManager, this.spiUtils, this.commentManager, this.eventPublisher);
            rch.addRevisions(this.getCurrentUser(), Collections.singletonList(first), attachMode, secondRev, ReviewCreationHelper.MetadataFilter.NONE);
            return true;
        }
        return false;
    }

    private Pair<CrucibleRevision, CrucibleRevision> getRevisionPair() {
        Source s2;
        if (!Strings.isNullOrEmpty((String)this.requestedRepo) && !Strings.isNullOrEmpty((String)this.revpath) && this.revid != null && this.revid.length > 0 && this.revid.length <= 2 && (s2 = CrucibleFilter.getSource(this.requestedRepo)) != null) {
            CrucibleRevision cruRev2;
            if (!s2.isAvailable()) {
                this.addActionMessage("Repository " + this.requestedRepo + " is not available. Cannot add changeset to review.");
            }
            String rev1 = this.revid[0];
            CrucibleRevision cruRev1 = this.contentManager.getCrucibleRevision(s2, this.revpath, rev1);
            String rev2 = this.revid.length > 1 ? this.revid[1] : null;
            CrucibleRevision crucibleRevision = cruRev2 = Strings.isNullOrEmpty((String)rev2) ? null : this.contentManager.getCrucibleRevision(s2, this.revpath, rev2);
            if (cruRev1 != null) {
                return Pair.newInstance(cruRev1, cruRev2);
            }
        }
        return Pair.newInstance(null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequireSecurityToken(value=false)
    public String execute() throws SourceException {
        try {
            if (this.getCurrentUser() == null) {
                String string = "loginRequired";
                return string;
            }
            if (this.revid != null && this.revid.length > 2) {
                this.errorMsg = "You cannot add more than two revisions from here";
                this.worked = false;
                String string = "error";
                return string;
            }
            this.beginTx();
            List<CrucibleChangeSet> changeSets = this.createChangeSets();
            Pair<CrucibleRevision, CrucibleRevision> revisionPair = this.getRevisionPair();
            if (changeSets.isEmpty() && revisionPair.getFirst() == null) {
                this.commitTx();
                String string = this.result = "createBlankReview";
                return string;
            }
            String result = this.task != null && this.task.matches("([A-Z0-9\\-]+)-(\\d{1,9})") ? this.addToReview(this.task, changeSets, revisionPair) : this.createNewReview(changeSets, revisionPair);
            this.commitTx();
            this.result = result;
            String string = this.worked ? result : "error";
            return string;
        }
        catch (ContentTooLargeException e2) {
            this.errorMsg = e2.getMessageHtml();
            this.noEscape = true;
            this.worked = false;
            String string = "input";
            return string;
        }
        finally {
            this.rollbackTxIfNotCommited();
        }
    }

    private List<CrucibleChangeSet> createChangeSets() throws SourceException, ChangeSetContentTooLargeException {
        if (this.csid == null && this.issueKeys.isEmpty()) {
            return Collections.emptyList();
        }
        if (this.csid == null) {
            Logs.APP_LOG.debug((Object)("No changesets specified, doing a search for issues=" + this.issueKeys));
            List<ChangeSetPair> issueChangesets = this.changesetSearcher.getChangesetsForQuery(ChangesetCannedQueries.changesetsForIssueKeys(this.issueKeys));
            ImmutableList.Builder csIds = ImmutableList.builder();
            for (ChangeSetPair changeset : issueChangesets) {
                csIds.add((Object)changeset.toString());
            }
            this.csid = (String[])Iterables.toArray((Iterable)csIds.build(), String.class);
            Logs.APP_LOG.debug((Object)("Found " + this.csid.length + " changesets for review"));
        }
        this.crucibleChangeSetsHelper.clear();
        for (String id : this.csid) {
            Option<ChangeSetPair> csPair = this.parseCsid(id);
            if (!csPair.isDefined()) continue;
            this.crucibleChangeSetsHelper.addCrucibleChangeSet((ChangeSetPair)csPair.get());
            this.setFirstChangesetIfEmpty((ChangeSetPair)csPair.get());
        }
        this.crucibleChangeSetsHelper.checkSize();
        return this.crucibleChangeSetsHelper.createChangeSets(false);
    }

    private Option<ChangeSetPair> parseCsid(String id) {
        String cs;
        String currentRepo;
        Matcher m2 = CSID_PATTERN.matcher(id);
        if (!m2.matches()) {
            return Option.none();
        }
        if (m2.group(2) != null) {
            currentRepo = m2.group(2);
            cs = m2.group(3);
        } else {
            if (Strings.isNullOrEmpty((String)this.requestedRepo)) {
                return Option.none();
            }
            currentRepo = this.requestedRepo;
            cs = m2.group(3);
        }
        return Option.option((Object)ChangeSetPair.newInstance(currentRepo, cs));
    }

    private List<Project> filterProjectsByRepo(List<Project> projects) {
        Set<String> requestedRepos = this.extractRequestedRepositories();
        if (requestedRepos.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Project> filtered = new ArrayList<Project>();
        for (Project p2 : projects) {
            if (!requestedRepos.contains(p2.getDefaultRepositoryName())) continue;
            filtered.add(p2);
        }
        if (filtered.isEmpty()) {
            for (Project p2 : projects) {
                for (String repo : requestedRepos) {
                    List<ContentRoot> contentRootsForRep = p2.getAllContentRootsForRep(repo);
                    for (ContentRoot contentRoot : contentRootsForRep) {
                        if (!contentRoot.isWholeRepository()) continue;
                        filtered.add(p2);
                    }
                }
            }
        }
        Collections.sort(filtered, new Project.NameComparator());
        return filtered;
    }

    @VisibleForTesting
    Set<String> extractRequestedRepositories() {
        ImmutableSet.Builder requestedReposBuilder = ImmutableSet.builder();
        if (!Strings.isNullOrEmpty((String)this.requestedRepo)) {
            requestedReposBuilder.add((Object)this.requestedRepo);
        }
        if (this.csid != null) {
            for (String cs : this.csid) {
                this.parseCsid(cs).foreach(changeSetPair -> requestedReposBuilder.add((Object)changeSetPair.getRepository()));
            }
        }
        return requestedReposBuilder.build();
    }

    private String summariseDescriptions(List<CrucibleChangeSet> orderedChangesets, Pair<CrucibleRevision, CrucibleRevision> revisionPair) {
        if (orderedChangesets.isEmpty() && revisionPair.isNull()) {
            return "";
        }
        StringBuilder summary = orderedChangesets.size() > 1 ? new StringBuilder("Generated from changeset comments:\n") : new StringBuilder();
        String sep = "";
        for (CrucibleChangeSet cs : orderedChangesets) {
            String trimmedComment;
            summary.append(sep);
            summary.append("{").append("cs").append(":").append("id").append("=").append(cs.getId()).append("|").append("rep").append("=").append(cs.getSource().getName()).append("}");
            summary.append(": ");
            String string = trimmedComment = cs.getComment() == null ? "" : cs.getComment().trim();
            if (trimmedComment.contains("\n")) {
                summary.append("\n");
            }
            summary.append(trimmedComment);
            sep = "\n";
        }
        if (!revisionPair.isNull()) {
            String trimmedComment;
            summary.append(sep);
            CrucibleRevision rev = revisionPair.getFirst();
            summary.append(rev.getId()).append(": ");
            String string = trimmedComment = rev.getCommitMessage() == null ? "" : rev.getCommitMessage().trim();
            if (trimmedComment.contains("\n")) {
                summary.append("\n");
            }
            summary.append(trimmedComment);
        }
        return summary.toString();
    }

    public void setCrucibleProject(String crucibleProject) {
        this.crucibleProject = crucibleProject;
    }

    public static class SimpleRevisionInfo {
        private final String revisionId;
        private final String repoName;

        private SimpleRevisionInfo(String revisionId, String repoName) {
            this.revisionId = revisionId;
            this.repoName = repoName;
        }

        public String getRepoName() {
            return this.repoName;
        }

        public String getRevisionId() {
            return this.revisionId;
        }
    }

    private static class NewestFirstComparator
    implements Comparator<CrucibleChangeSet> {
        private NewestFirstComparator() {
        }

        @Override
        public int compare(CrucibleChangeSet o1, CrucibleChangeSet o2) {
            return o1.getDate().compareTo(o2.getDate());
        }
    }
}

