/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.actions.create;

import com.atlassian.crucible.actions.create.CreateReviewBaseAction;
import com.atlassian.fisheye.user.RecentlyVisitedManager;
import com.atlassian.fisheye.user.model.RecentlyVisitedItem;
import com.atlassian.fisheye.user.model.RecentlyVisitedProject;
import com.atlassian.xwork.RequireSecurityToken;
import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.managers.UserActionManager;
import com.cenqua.crucible.revision.source.Source;
import com.cenqua.crucible.tags.ReviewUtil;
import com.cenqua.fisheye.logging.Logs;
import com.google.common.base.Strings;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public class CreateBlankReviewAjaxAction
extends CreateReviewBaseAction {
    public static final String SELECT_PROJECT = "selectProject";
    @Autowired
    private RecentlyVisitedManager recentlyVisitedManager;
    private Review review;
    private String projectKey;
    private Project project;
    private String errorMsg;
    private boolean worked = true;
    private String result;

    @Override
    public String getErrorMsg() {
        return this.errorMsg;
    }

    @Override
    public boolean isWorked() {
        return this.worked;
    }

    public String getResult() {
        return this.result;
    }

    public boolean isShowDialog() {
        return this.getProject() == null;
    }

    public boolean isRedirect() {
        return !this.isShowDialog();
    }

    public void setProjectId(int projectId) {
        this.project = this.projectManager.getProjectById(projectId);
    }

    public void setProjectKey(String projectKey) {
        this.projectKey = projectKey;
        Project p2 = this.projectManager.getProjectByKey(projectKey);
        if (p2 != null) {
            this.project = p2;
        }
    }

    @Override
    public Project getProject() {
        return this.project;
    }

    public String getPermaId() {
        return this.review == null ? "" : this.review.getPermaId();
    }

    public Review getReview() {
        return this.review;
    }

    public String getActionName() {
        return "createReview";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequireSecurityToken(value=false)
    public String execute() throws Exception {
        try {
            Source defaultRepo;
            List<Project> allowedProjects;
            if (this.getCurrentUser() == null) {
                String string = "loginRequired";
                return string;
            }
            this.beginTx();
            if (this.project == null) {
                allowedProjects = this.getProjectsCanCreateIn();
                if (allowedProjects.isEmpty()) {
                    this.errorMsg = "You do not have permission to create reviews in any project.";
                    this.worked = false;
                    this.commitTx();
                    String string = this.result = "error";
                    return string;
                }
                if (allowedProjects.size() == 1) {
                    this.project = allowedProjects.get(0);
                } else {
                    List recentProjects = this.recentlyVisitedManager.getHistory(RecentlyVisitedItem.Type.PROJECT, this.getPrincipal());
                    for (RecentlyVisitedProject p2 : recentProjects) {
                        if (!allowedProjects.contains(p2.getEntity())) continue;
                        this.preSelectedProject = p2.getEntity();
                        break;
                    }
                }
            }
            if (this.project == null || !ReviewUtil.principalCanDoProjectAction(this.getPrincipal(), UserActionManager.ACTION_CREATE, this.project)) {
                if (this.project == null) {
                    if (!Strings.isNullOrEmpty((String)this.projectKey)) {
                        this.errorMsg = "Project " + this.projectKey + " does not exist";
                    } else if (this.projectKey != null) {
                        this.errorMsg = "Please provide a project";
                    }
                } else {
                    this.errorMsg = "You do not have permission to create a review in project " + this.project.getName();
                }
                this.commitTx();
                this.result = SELECT_PROJECT;
                allowedProjects = this.result;
                return allowedProjects;
            }
            if (this.checkIsConfirmCreateNeeded()) {
                if (this.project != null) {
                    this.preSelectedProject = this.project;
                    this.project = null;
                }
                this.result = SELECT_PROJECT;
                allowedProjects = this.result;
                return allowedProjects;
            }
            this.review = this.reviewManager.createReviewWithDefaults(this.projectManager, this.project, "", this.getCurrentUser());
            this.review.setAuthor(this.getCurrentUser());
            if (this.project.isModeratorEnabled() && !this.review.isModerated()) {
                this.review.setModerator(this.getCurrentUser());
            }
            this.review.setCreator(this.getCurrentUser());
            if (this.review.getDefaultSource() == null && (defaultRepo = this.getDefaultRepo()) != null) {
                this.review.setDefaultSource(defaultRepo.getName());
            }
            this.commitTx();
            Logs.APP_LOG.debug((Object)("Created empty review " + this.review.getPermaId()));
            String string = this.result = "done";
            return string;
        }
        finally {
            this.rollbackTxIfNotCommited();
        }
    }
}

