/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.actions.create;

import com.atlassian.crucible.actions.AjaxResponse;
import com.atlassian.crucible.actions.ReviewBaseAction;
import com.cenqua.crucible.model.FileRevisionExtraInfo;
import com.cenqua.crucible.model.managers.FRXManager;
import com.cenqua.crucible.revision.managers.ContentManager;
import com.cenqua.crucible.view.FRXDO;
import com.cenqua.fisheye.logging.Logs;

public class ChangeDiffDropdownAjaxAction
extends ReviewBaseAction
implements AjaxResponse {
    private String errorMsg = "";
    private boolean worked = false;
    private Integer frxId = null;
    private FRXDO frxDo;
    private boolean fromManagedFile = false;

    @Override
    public String getErrorMsg() {
        return this.errorMsg;
    }

    @Override
    public boolean isWorked() {
        return this.worked;
    }

    public void setFrxId(Integer frxId) {
        this.frxId = frxId;
    }

    public void setFromManagedFile(boolean fromManagedFile) {
        this.fromManagedFile = fromManagedFile;
    }

    public boolean isFromManagedFile() {
        return this.fromManagedFile;
    }

    public FRXDO getFrxDO() {
        return this.frxDo;
    }

    public String execute() throws Exception {
        ContentManager contentManager = this.getContentManager();
        FileRevisionExtraInfo frx = FRXManager.getById(this.frxId);
        if (frx == null) {
            this.errorMsg = "Cannot find FRX with id \"" + this.frxId + "\"";
            Logs.APP_LOG.warn((Object)this.errorMsg);
        } else if (frx.getFrxRevisions() == null || frx.getFrxRevisions().size() == 0) {
            this.errorMsg = "Cannot find any revisions in FRX with id \"" + this.frxId + "\"";
            Logs.APP_LOG.warn((Object)this.errorMsg);
        } else {
            this.frxDo = contentManager.makeFRXDO(frx, this.getCurrentUser(), this.getPrincipal(), this.currentUserPermissions, null, false, false, false);
            this.worked = true;
            return "success";
        }
        return "error";
    }
}

